/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.http;

import com.kontakt.sdk.android.common.FileData;
import com.kontakt.sdk.android.common.interfaces.SDKFunction;
import com.kontakt.sdk.android.common.model.IVenue;
import com.kontakt.sdk.android.common.model.Venue;
import com.kontakt.sdk.android.common.util.SDKOptional;
import com.kontakt.sdk.android.http.AbstractApiAccessor;
import com.kontakt.sdk.android.http.ETag;
import com.kontakt.sdk.android.http.HttpResult;
import com.kontakt.sdk.android.http.RequestDescription;
import com.kontakt.sdk.android.http.data.VenueData;
import com.kontakt.sdk.android.http.exception.ClientException;
import com.kontakt.sdk.android.http.interfaces.ResultApiCallback;
import com.kontakt.sdk.android.http.interfaces.UpdateApiCallback;
import com.kontakt.sdk.android.http.interfaces.VenuesApiAccessor;
import java.util.List;
import java.util.UUID;
import org.json.JSONObject;

final class VenuesApiAccessorImpl
extends AbstractApiAccessor
implements VenuesApiAccessor {
    VenuesApiAccessorImpl(String apiKey, String apiUrl) {
        super(apiKey, apiUrl);
    }

    @Override
    public HttpResult<IVenue> getVenue(UUID venueId, SDKOptional<ETag> eTag) throws ClientException {
        String uri = String.format("venue/%s", venueId.toString());
        return this.getAndTransform(uri, RequestDescription.start().setETag(eTag.isPresent() ? (ETag)eTag.get() : null).build(), new SDKFunction<JSONObject, IVenue>(){

            public Venue apply(JSONObject object) {
                return Venue.from((JSONObject)object);
            }
        });
    }

    @Override
    public void getVenue(UUID venueId, SDKOptional<ETag> etag, ResultApiCallback<IVenue> apiCallback) {
        String uri = String.format("venue/%s", venueId.toString());
        this.getAsyncAndRetrieveFromJSONObject(uri, DEFAULT_REQUEST_DESCRIPTION, 200, apiCallback, new SDKFunction<JSONObject, IVenue>(){

            public Venue apply(JSONObject object) {
                return Venue.from((JSONObject)object);
            }
        });
    }

    @Override
    public HttpResult<IVenue> createVenue(VenueData venue) throws ClientException {
        return this.createAndTransform("venue/create", venue, new SDKFunction<JSONObject, IVenue>(){

            public Venue apply(JSONObject object) {
                return Venue.from((JSONObject)object);
            }
        });
    }

    @Override
    public void createVenue(VenueData venueData, ResultApiCallback<IVenue> apiCallback) {
        RequestDescription requestDescription = RequestDescription.start().addParameters(venueData.getParameters()).build();
        this.postAsyncAndBuildFromJSONObject("venue/create", requestDescription, 201, apiCallback, new SDKFunction<JSONObject, IVenue>(){

            public IVenue apply(JSONObject object) {
                return Venue.from((JSONObject)object);
            }
        });
    }

    @Override
    public HttpResult<List<IVenue>> listVenues(RequestDescription requestDescription) throws ClientException {
        return this.getAndTransformToList("venue", requestDescription, "venues", new SDKFunction<JSONObject, IVenue>(){

            public Venue apply(JSONObject object) {
                return Venue.from((JSONObject)object);
            }
        });
    }

    @Override
    public HttpResult<List<IVenue>> listVenues() throws ClientException {
        return this.listVenues(DEFAULT_REQUEST_DESCRIPTION);
    }

    @Override
    public void listVenues(RequestDescription requestDescription, ResultApiCallback<List<IVenue>> apiCallback) {
        this.transformToListAsynchronously("venue", requestDescription, 200, "venues", apiCallback, new SDKFunction<JSONObject, IVenue>(){

            public IVenue apply(JSONObject object) {
                return Venue.from((JSONObject)object);
            }
        });
    }

    @Override
    public void listVenues(ResultApiCallback<List<IVenue>> apiCallback) {
        this.listVenues(DEFAULT_REQUEST_DESCRIPTION, apiCallback);
    }

    @Override
    public HttpResult<FileData> getVenueImage(UUID venueId) throws ClientException {
        String venueUri = String.format("venue/%s/image", venueId.toString());
        return this.getAndTransformByteArray(venueUri, DEFAULT_REQUEST_DESCRIPTION, new SDKFunction<byte[], FileData>(){

            public FileData apply(byte[] object) {
                return FileData.of((byte[])object);
            }
        });
    }

    @Override
    public void getVenueImage(UUID venueId, ResultApiCallback<FileData> apiCallback) {
        String venueUri = String.format("venue/%s/image", venueId.toString());
        this.getAsync(venueUri, DEFAULT_REQUEST_DESCRIPTION, 200, apiCallback, BYTE_ARRAY_EXTRACT_FUNCTION, new SDKFunction<byte[], FileData>(){

            public FileData apply(byte[] object) {
                return FileData.of((byte[])object);
            }
        });
    }

    @Override
    public int updateVenue(VenueData venueData) throws ClientException {
        RequestDescription requestDescription = RequestDescription.start().addHeader("Content-Type", "Content-Type").addParameters(venueData.getParameters()).build();
        return this.postAndReturnHttpStatus("venue/update", requestDescription);
    }

    @Override
    public void updateVenue(VenueData venueData, UpdateApiCallback apiCallback) {
        RequestDescription requestDescription = RequestDescription.start().addHeader("Content-Type", "Content-Type").addParameters(venueData.getParameters()).build();
        this.postAsyncAndReturnHttpStatus("venue/update", requestDescription, apiCallback);
    }

    @Override
    public int deleteVenue(UUID venueId) throws ClientException {
        RequestDescription requestDescription = RequestDescription.start().addParameter("venueId", venueId.toString()).build();
        return this.postAndReturnHttpStatus("venue/delete", requestDescription);
    }

    @Override
    public void deleteVenue(UUID venueId, UpdateApiCallback apiCallback) {
        RequestDescription requestDescription = RequestDescription.start().addParameter("venueId", venueId.toString()).build();
        this.postAsyncAndReturnHttpStatus("venue/delete", requestDescription, apiCallback);
    }
}

