/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.http;

import com.kontakt.sdk.android.common.KontaktSDK;
import com.kontakt.sdk.android.common.util.Closeables;
import com.kontakt.sdk.android.http.AbstractApiAccessor;
import com.kontakt.sdk.android.http.AbstractKontaktApiClient;
import com.kontakt.sdk.android.http.ActionsApiAccessorImpl;
import com.kontakt.sdk.android.http.CommandApiAccessorImpl;
import com.kontakt.sdk.android.http.CommonApiAccessorImpl;
import com.kontakt.sdk.android.http.ConfigurationApiAccessorImpl;
import com.kontakt.sdk.android.http.DevicesApiAccessorImpl;
import com.kontakt.sdk.android.http.FirmwareApiAccessorImpl;
import com.kontakt.sdk.android.http.ManagersApiAccessorImpl;
import com.kontakt.sdk.android.http.VenuesApiAccessorImpl;
import com.kontakt.sdk.android.http.interfaces.ActionsApiAccessor;
import com.kontakt.sdk.android.http.interfaces.CommandApiAccessor;
import com.kontakt.sdk.android.http.interfaces.CommonApiAccessor;
import com.kontakt.sdk.android.http.interfaces.ConfigurationApiAccessor;
import com.kontakt.sdk.android.http.interfaces.DevicesApiAccessor;
import com.kontakt.sdk.android.http.interfaces.FirmwareApiAccessor;
import com.kontakt.sdk.android.http.interfaces.ManagersApiAccessor;
import com.kontakt.sdk.android.http.interfaces.VenuesApiAccessor;
import java.io.Closeable;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.HashMap;

public class KontaktApiClient
extends AbstractKontaktApiClient {
    private final HashMap<String, Object> apiAccessorMap = new HashMap();
    public static final int ACCEPT_VERSION = 9;

    public KontaktApiClient() {
        this(KontaktSDK.getInstance().getApiKey(), "https://api.kontakt.io");
    }

    protected KontaktApiClient(String apiKey, String apiUrl) {
        super(apiKey, apiUrl);
    }

    @Override
    protected DevicesApiAccessor devicesApi() {
        return this.putIfAbsentAndReturnApiAccessor(DevicesApiAccessorImpl.class, "beaconsApi");
    }

    @Override
    protected VenuesApiAccessor venuesApi() {
        return this.putIfAbsentAndReturnApiAccessor(VenuesApiAccessorImpl.class, "venuesApi");
    }

    @Override
    protected ManagersApiAccessor managersApi() {
        return this.putIfAbsentAndReturnApiAccessor(ManagersApiAccessorImpl.class, "managersApi");
    }

    @Override
    protected ConfigurationApiAccessor configurationApi() {
        return this.putIfAbsentAndReturnApiAccessor(ConfigurationApiAccessorImpl.class, "configurationApi");
    }

    @Override
    protected FirmwareApiAccessor firmwareApi() {
        return this.putIfAbsentAndReturnApiAccessor(FirmwareApiAccessorImpl.class, "firmwareApi");
    }

    @Override
    protected ActionsApiAccessor actionsApi() {
        return this.putIfAbsentAndReturnApiAccessor(ActionsApiAccessorImpl.class, "actionsApi");
    }

    @Override
    protected CommonApiAccessor commonsApi() {
        return this.putIfAbsentAndReturnApiAccessor(CommonApiAccessorImpl.class, "commonApi");
    }

    @Override
    protected CommandApiAccessor commandApi() {
        return this.putIfAbsentAndReturnApiAccessor(CommandApiAccessorImpl.class, "commandApi");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        HashMap<String, Object> hashMap = this.apiAccessorMap;
        synchronized (hashMap) {
            for (Object apiAccessor : this.apiAccessorMap.values()) {
                try {
                    Closeables.close((Closeable)((AbstractApiAccessor)apiAccessor), (boolean)true);
                }
                catch (IOException iOException) {}
            }
            this.apiAccessorMap.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T putIfAbsentAndReturnApiAccessor(Class<T> clazz, String accessorKey) {
        HashMap<String, Object> hashMap = this.apiAccessorMap;
        synchronized (hashMap) {
            Object accessorInstance = this.apiAccessorMap.get(accessorKey);
            if (accessorInstance == null) {
                try {
                    Constructor<T> constructor = clazz.getDeclaredConstructor(String.class, String.class);
                    accessorInstance = constructor.newInstance(this.apiKey, this.apiUrl);
                    this.apiAccessorMap.put(accessorKey, accessorInstance);
                }
                catch (Exception e) {
                    throw new IllegalStateException(e);
                }
            }
            return (T)accessorInstance;
        }
    }
}

