/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.http;

import android.text.TextUtils;
import com.kontakt.sdk.android.common.interfaces.SDKFunction;
import com.kontakt.sdk.android.common.model.BeaconId;
import com.kontakt.sdk.android.common.model.Device;
import com.kontakt.sdk.android.common.model.DeviceCredentials;
import com.kontakt.sdk.android.common.model.DeviceType;
import com.kontakt.sdk.android.common.model.EddystoneFutureUID;
import com.kontakt.sdk.android.common.model.EddystoneUID;
import com.kontakt.sdk.android.common.model.IBeaconFutureId;
import com.kontakt.sdk.android.common.model.ICloudConfig;
import com.kontakt.sdk.android.common.model.IConfig;
import com.kontakt.sdk.android.common.model.ICredentials;
import com.kontakt.sdk.android.common.model.IDevice;
import com.kontakt.sdk.android.common.model.SecureSingleConfig;
import com.kontakt.sdk.android.common.util.EddystoneUtils;
import com.kontakt.sdk.android.common.util.HttpUtils;
import com.kontakt.sdk.android.common.util.JSONUtils;
import com.kontakt.sdk.android.common.util.SDKOptional;
import com.kontakt.sdk.android.http.AbstractApiAccessor;
import com.kontakt.sdk.android.http.ETag;
import com.kontakt.sdk.android.http.HttpResult;
import com.kontakt.sdk.android.http.ObjectRequestDescriptionHelper;
import com.kontakt.sdk.android.http.RequestDescription;
import com.kontakt.sdk.android.http.data.DeviceData;
import com.kontakt.sdk.android.http.exception.ClientException;
import com.kontakt.sdk.android.http.interfaces.DevicesApiAccessor;
import com.kontakt.sdk.android.http.interfaces.ResultApiCallback;
import com.kontakt.sdk.android.http.interfaces.UpdateApiCallback;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.json.JSONException;
import org.json.JSONObject;

final class DevicesApiAccessorImpl
extends AbstractApiAccessor
implements DevicesApiAccessor {
    DevicesApiAccessorImpl(String apiKey, String apiUrl) {
        super(apiKey, apiUrl);
    }

    @Override
    public HttpResult<List<IDevice>> getDevicesByProximity(UUID proximityUUID, int major, int minor, SDKOptional<ETag> eTag) throws ClientException {
        RequestDescription requestDescription = RequestDescription.start().addParameter("proximity", proximityUUID.toString()).addParameter("major", String.valueOf(major)).addParameter("minor", String.valueOf(minor)).setETag(eTag.isPresent() ? (ETag)eTag.get() : null).build();
        return this.getAndTransform("device", requestDescription, new SDKFunction<JSONObject, List<IDevice>>(){

            public List<IDevice> apply(JSONObject object) {
                return Device.fromList((JSONObject)object);
            }
        });
    }

    @Override
    public HttpResult<List<IDevice>> getDevicesByProximity(UUID proximityUUID, int major, int minor) throws ClientException {
        return this.getDevicesByProximity(proximityUUID, major, minor, (SDKOptional<ETag>)SDKOptional.absent());
    }

    @Override
    public void getDevicesByProximity(UUID proximityUUID, int major, int minor, SDKOptional<ETag> eTag, ResultApiCallback<List<IDevice>> apiCallback) {
        RequestDescription requestDescription = RequestDescription.start().addParameter("proximity", proximityUUID.toString()).addParameter("major", String.valueOf(major)).addParameter("minor", String.valueOf(minor)).setETag(eTag.isPresent() ? (ETag)eTag.get() : null).build();
        this.getAsync("device", requestDescription, 200, apiCallback, JSON_OBJECT_EXTRACT_FUNCTION, new SDKFunction<JSONObject, List<IDevice>>(){

            public List<IDevice> apply(JSONObject object) {
                return Device.fromList((JSONObject)object);
            }
        });
    }

    @Override
    public void getDevicesByProximity(UUID proximityUUID, int major, int minor, ResultApiCallback<List<IDevice>> apiCallback) {
        this.getDevicesByProximity(proximityUUID, major, minor, (SDKOptional<ETag>)SDKOptional.absent(), apiCallback);
    }

    @Override
    public HttpResult<IDevice> getDeviceByNamespaceAndInstanceId(String namespace, String instanceId) throws ClientException {
        return this.getDeviceByNamespaceAndInstanceId(namespace, instanceId, (SDKOptional<ETag>)SDKOptional.absent());
    }

    @Override
    public HttpResult<IDevice> getDeviceByNamespaceAndInstanceId(String namespace, String instanceId, SDKOptional<ETag> eTag) throws ClientException {
        RequestDescription requestDescription = RequestDescription.start().addParameter("instanceId", instanceId).addParameter("namespace", namespace).setETag(eTag.isPresent() ? (ETag)eTag.get() : null).build();
        return this.getAndTransform("device", requestDescription, new SDKFunction<JSONObject, IDevice>(){

            public IDevice apply(JSONObject object) {
                return Device.from((JSONObject)object);
            }
        });
    }

    @Override
    public void getDeviceByNamespaceAndInstanceId(String namespace, String instanceId, ResultApiCallback<IDevice> apiCallback) {
        this.getDeviceByNamespaceAndInstanceId(namespace, instanceId, (SDKOptional<ETag>)SDKOptional.absent(), apiCallback);
    }

    @Override
    public void getDeviceByNamespaceAndInstanceId(String namespace, String instanceId, SDKOptional<ETag> eTag, ResultApiCallback<IDevice> apiCallback) {
        RequestDescription requestDescription = RequestDescription.start().addParameter("instanceId", instanceId).addParameter("namespace", namespace).setETag(eTag.isPresent() ? (ETag)eTag.get() : null).build();
        this.getAsync("device", requestDescription, 200, apiCallback, JSON_OBJECT_EXTRACT_FUNCTION, new SDKFunction<JSONObject, IDevice>(){

            public IDevice apply(JSONObject object) {
                return Device.from((JSONObject)object);
            }
        });
    }

    @Override
    public HttpResult<IDevice> getDevice(String beaconUniqueId, SDKOptional<ETag> eTag) throws ClientException {
        RequestDescription requestDescription = RequestDescription.start().setETag(eTag.isPresent() ? (ETag)eTag.get() : null).build();
        return this.getAndTransform(String.format("device/%s", beaconUniqueId), requestDescription, new SDKFunction<JSONObject, IDevice>(){

            public IDevice apply(JSONObject object) {
                return Device.from((JSONObject)object);
            }
        });
    }

    @Override
    public HttpResult<IDevice> getDevice(String deviceUniqueId) throws ClientException {
        return this.getDevice(deviceUniqueId, (SDKOptional<ETag>)SDKOptional.absent());
    }

    @Override
    public void getDevice(String deviceUniqueId, SDKOptional<ETag> etag, ResultApiCallback<IDevice> apiCallback) {
        RequestDescription requestDescription = RequestDescription.start().setETag(etag.isPresent() ? (ETag)etag.get() : null).build();
        String uri = String.format("device/%s", deviceUniqueId);
        this.getAsync(uri, requestDescription, 200, apiCallback, JSON_OBJECT_EXTRACT_FUNCTION, new SDKFunction<JSONObject, IDevice>(){

            public IDevice apply(JSONObject object) {
                return Device.from((JSONObject)object);
            }
        });
    }

    @Override
    public void getDevice(String deviceUniqueId, ResultApiCallback<IDevice> apiCallback) {
        this.getDevice(deviceUniqueId, (SDKOptional<ETag>)SDKOptional.absent(), apiCallback);
    }

    @Override
    public HttpResult<List<IDevice>> listDevicesForManagers(Set<UUID> managerIds, SDKOptional<ETag> eTag) throws ClientException {
        RequestDescription description = RequestDescription.start().setETag(eTag.isPresent() ? (ETag)eTag.get() : null).addParameters(HttpUtils.toUrlParameterList((String)"managerId", managerIds)).build();
        return this.getAndTransformToList("device", description, "devices", new SDKFunction<JSONObject, IDevice>(){

            public IDevice apply(JSONObject object) {
                return Device.from((JSONObject)object);
            }
        });
    }

    @Override
    public HttpResult<List<IDevice>> listDevicesForManagers(Set<UUID> managerIds) throws ClientException {
        return this.listDevicesForManagers(managerIds, (SDKOptional<ETag>)SDKOptional.absent());
    }

    @Override
    public void listDevicesForManagers(Set<UUID> managerIds, SDKOptional<ETag> eTag, ResultApiCallback<List<IDevice>> apiCallback) {
        RequestDescription description = RequestDescription.start().setETag(eTag.isPresent() ? (ETag)eTag.get() : null).addParameters(HttpUtils.toUrlParameterList((String)"managerId", managerIds)).build();
        this.transformToListAsynchronously("device", description, 200, "devices", apiCallback, new SDKFunction<JSONObject, IDevice>(){

            public IDevice apply(JSONObject object) {
                return Device.from((JSONObject)object);
            }
        });
    }

    @Override
    public void listDevicesForManagers(Set<UUID> managerIds, ResultApiCallback<List<IDevice>> apiCallback) {
        this.listDevicesForManagers(managerIds, (SDKOptional<ETag>)SDKOptional.absent(), apiCallback);
    }

    @Override
    public HttpResult<List<IDevice>> listDevices() throws ClientException {
        return this.listDevices(DEFAULT_REQUEST_DESCRIPTION);
    }

    @Override
    public HttpResult<List<IDevice>> listDevices(RequestDescription requestDescription) throws ClientException {
        return this.getAndTransformToList("device", requestDescription, "devices", new SDKFunction<JSONObject, IDevice>(){

            public IDevice apply(JSONObject object) {
                return Device.from((JSONObject)object);
            }
        });
    }

    @Override
    public void listDevices(ResultApiCallback<List<IDevice>> apiCallback) {
        this.listDevices(DEFAULT_REQUEST_DESCRIPTION, apiCallback);
    }

    @Override
    public void listDevices(RequestDescription requestDescription, ResultApiCallback<List<IDevice>> apiCallback) {
        this.transformToListAsynchronously("device", requestDescription, 200, "devices", apiCallback, new SDKFunction<JSONObject, IDevice>(){

            public IDevice apply(JSONObject object) {
                return Device.from((JSONObject)object);
            }
        });
    }

    @Override
    public HttpResult<ICredentials> getDeviceCredentials(final String deviceUniqueId, SDKOptional<ETag> eTagOptional) throws ClientException {
        String endpoint = String.format("device/%s/credentials", deviceUniqueId);
        RequestDescription requestDescription = RequestDescription.start().setETag(eTagOptional.isPresent() ? (ETag)eTagOptional.get() : null).build();
        return this.getAndTransform(endpoint, requestDescription, new SDKFunction<JSONObject, ICredentials>(){

            public ICredentials apply(JSONObject object) {
                try {
                    return new DeviceCredentials.Builder().setDeviceUniqueId(deviceUniqueId).setPassword(object.getString("password")).setMasterPassword(object.getString("masterPassword")).build();
                }
                catch (JSONException e) {
                    throw new IllegalStateException(e);
                }
            }
        });
    }

    @Override
    public HttpResult<List<ICredentials>> listDevicesCredentials(Collection<String> uniqueIds, SDKOptional<ETag> eTag) throws ClientException {
        String endpoint = "device/credentials";
        RequestDescription requestDescription = RequestDescription.start().setETag(eTag.isPresent() ? (ETag)eTag.get() : null).addParameters(HttpUtils.toUrlParameterList((String)"uniqueId", uniqueIds)).setOffset(uniqueIds.size()).build();
        return this.getAndTransformToList(endpoint, requestDescription, "credentials", new SDKFunction<JSONObject, ICredentials>(){

            public ICredentials apply(JSONObject object) {
                return new DeviceCredentials.Builder().setDeviceUniqueId(JSONUtils.getString((JSONObject)object, (String)"uniqueId", null)).setPassword(JSONUtils.getString((JSONObject)object, (String)"password", null)).setMasterPassword(JSONUtils.getString((JSONObject)object, (String)"masterPassword", null)).build();
            }
        });
    }

    @Override
    public void listDevicesCredentials(Collection<String> uniqueIds, SDKOptional<ETag> eTag, ResultApiCallback<List<ICredentials>> resultApiCallback) {
        String endpoint = "device/credentials";
        RequestDescription requestDescription = RequestDescription.start().setETag(eTag.isPresent() ? (ETag)eTag.get() : null).addParameters(HttpUtils.toUrlParameterList((String)"uniqueId", uniqueIds)).setOffset(uniqueIds.size()).build();
        String jsonEntry = "credentials";
        int expectedSuccessHttpCode = 200;
        this.transformToListAsynchronously(endpoint, requestDescription, 200, jsonEntry, resultApiCallback, new SDKFunction<JSONObject, ICredentials>(){

            public ICredentials apply(JSONObject object) {
                return new DeviceCredentials.Builder().setDeviceUniqueId(JSONUtils.getString((JSONObject)object, (String)"uniqueId", null)).setPassword(JSONUtils.getString((JSONObject)object, (String)"password", null)).setMasterPassword(JSONUtils.getString((JSONObject)object, (String)"masterPassword", null)).build();
            }
        });
    }

    @Override
    public void getDeviceCredentials(final String deviceUniqueId, SDKOptional<ETag> etag, ResultApiCallback<ICredentials> apiCallback) {
        String endpoint = String.format("device/%s/credentials", deviceUniqueId);
        RequestDescription requestDescription = RequestDescription.start().setETag(etag.isPresent() ? (ETag)etag.get() : null).build();
        this.getAsync(endpoint, requestDescription, 200, apiCallback, JSON_OBJECT_EXTRACT_FUNCTION, new SDKFunction<JSONObject, ICredentials>(){

            public ICredentials apply(JSONObject object) {
                try {
                    return new DeviceCredentials.Builder().setDeviceUniqueId(deviceUniqueId).setPassword(object.getString("password")).setMasterPassword(object.getString("masterPassword")).build();
                }
                catch (JSONException e) {
                    throw new IllegalStateException(e);
                }
            }
        });
    }

    @Override
    public int assignDevicesToManager(UUID managerId, Set<UUID> beaconIdSet) throws ClientException {
        RequestDescription requestDescription = RequestDescription.start().addParameter("managerId", managerId.toString()).addParameters(HttpUtils.toUrlParameterList((String)"beaconId", beaconIdSet)).build();
        return this.postAndReturnHttpStatus("beacon/assign", requestDescription);
    }

    @Override
    public void assignDevicesToManager(UUID managerId, Set<UUID> beaconIdSet, UpdateApiCallback apiCallback) {
        RequestDescription requestDescription = RequestDescription.start().addParameter("managerId", managerId.toString()).addParameters(HttpUtils.toUrlParameterList((String)"beaconId", beaconIdSet)).build();
        this.postAsyncAndReturnHttpStatus("beacon/assign", requestDescription, apiCallback);
    }

    @Override
    public int applyConfig(IConfig config) throws ClientException {
        return this.updateDevice(this.createConfigData(config));
    }

    @Override
    public void applyConfig(IConfig config, UpdateApiCallback apiCallback) {
        this.updateDevice(this.createConfigData(config), apiCallback);
    }

    @Override
    public int applyCloudConfig(ICloudConfig config) throws ClientException {
        return this.updateDevice(this.buildIBeaconDeviceData(config));
    }

    @Override
    public void applyConfig(ICloudConfig config, UpdateApiCallback apiCallback) {
        this.updateDevice(this.buildIBeaconDeviceData(config), apiCallback);
    }

    @Override
    public HttpResult<List<SecureSingleConfig>> applySecureConfig(Collection<SecureSingleConfig> secureConfigApplies) throws ClientException {
        String endpoint = "device/update";
        RequestDescription requestDescription = ObjectRequestDescriptionHelper.prepareParameters(secureConfigApplies).setOffset(secureConfigApplies.size()).build();
        int[] statuses = new int[]{200, 204};
        return this.postAndTransformToList(endpoint, requestDescription, statuses, "configs", new SDKFunction<JSONObject, SecureSingleConfig>(){

            public SecureSingleConfig apply(JSONObject object) {
                return SecureSingleConfig.fromJson((JSONObject)object);
            }
        });
    }

    @Override
    public void applySecureConfig(Collection<SecureSingleConfig> secureConfigApplies, ResultApiCallback<List<SecureSingleConfig>> apiCallback) {
        String endpoint = "device/update";
        RequestDescription requestDescription = ObjectRequestDescriptionHelper.prepareParameters(secureConfigApplies).setOffset(secureConfigApplies.size()).build();
        int[] statuses = new int[]{200, 204};
        this.postAsyncAndBuildFromJSONObject(endpoint, requestDescription, statuses, apiCallback, new SDKFunction<JSONObject, List<SecureSingleConfig>>(){

            public List<SecureSingleConfig> apply(JSONObject object) {
                return SecureSingleConfig.fromListJson((JSONObject)object);
            }
        });
    }

    @Override
    public HttpResult<List<IDevice>> listUnassignedDevicesForManager(UUID managerId, RequestDescription requestDescription) throws ClientException {
        return this.getAndTransformToList(String.format("device/unassigned/%s", managerId.toString()), requestDescription, "devices", new SDKFunction<JSONObject, IDevice>(){

            public IDevice apply(JSONObject object) {
                return Device.from((JSONObject)object);
            }
        });
    }

    @Override
    public HttpResult<List<IDevice>> listUnassignedDevicesForManager(UUID managerId) throws ClientException {
        return this.listUnassignedDevicesForManager(managerId, DEFAULT_REQUEST_DESCRIPTION);
    }

    @Override
    public void listUnassignedDevicesForManager(UUID managerId, RequestDescription requestDescription, ResultApiCallback<List<IDevice>> apiCallback) {
        String uri = String.format("device/unassigned/%s", managerId.toString());
        this.transformToListAsynchronously(uri, requestDescription, 200, "devices", apiCallback, new SDKFunction<JSONObject, IDevice>(){

            public IDevice apply(JSONObject object) {
                return Device.from((JSONObject)object);
            }
        });
    }

    @Override
    public void listUnassignedDevicesForManager(UUID managerId, ResultApiCallback<List<IDevice>> apiCallback) {
        this.listUnassignedDevicesForManager(managerId, DEFAULT_REQUEST_DESCRIPTION, apiCallback);
    }

    @Override
    public void resolveIBeacon(Collection<BeaconId> beaconIds, SDKOptional<ETag> eTag, ResultApiCallback<List<IBeaconFutureId>> apiCallback) {
        String parameters = TextUtils.join((CharSequence)",", beaconIds);
        RequestDescription requestDescription = RequestDescription.start().setETag(eTag.isPresent() ? (ETag)eTag.get() : null).addParameter("bid", parameters).setOffset(beaconIds.size()).build();
        this.transformToListAsynchronously("device", requestDescription, 200, "devices", apiCallback, new SDKFunction<JSONObject, IBeaconFutureId>(){

            public IBeaconFutureId apply(JSONObject object) {
                return IBeaconFutureId.from((JSONObject)object);
            }
        });
    }

    @Override
    public HttpResult<List<IBeaconFutureId>> resolveIBeacon(Collection<BeaconId> beaconIds, SDKOptional<ETag> eTagSDKOptional) throws ClientException {
        String parameters = TextUtils.join((CharSequence)",", beaconIds);
        RequestDescription requestDescription = RequestDescription.start().setETag(eTagSDKOptional.isPresent() ? (ETag)eTagSDKOptional.get() : null).addParameter("bid", parameters).setOffset(beaconIds.size()).build();
        return this.getAndTransformToList("device", requestDescription, "devices", new SDKFunction<JSONObject, IBeaconFutureId>(){

            public IBeaconFutureId apply(JSONObject object) {
                return IBeaconFutureId.from((JSONObject)object);
            }
        });
    }

    @Override
    public void resolveEddystone(Collection<EddystoneUID> eddystoneUids, SDKOptional<ETag> eTag, ResultApiCallback<List<EddystoneFutureUID>> apiCallback) {
        String parameters = TextUtils.join((CharSequence)",", eddystoneUids);
        RequestDescription requestDescription = RequestDescription.start().setETag(eTag.isPresent() ? (ETag)eTag.get() : null).addParameter("euid", parameters).setOffset(eddystoneUids.size()).build();
        this.transformToListAsynchronously("device", requestDescription, 200, "devices", apiCallback, new SDKFunction<JSONObject, EddystoneFutureUID>(){

            public EddystoneFutureUID apply(JSONObject object) {
                return EddystoneFutureUID.from((JSONObject)object);
            }
        });
    }

    @Override
    public HttpResult<List<EddystoneFutureUID>> resolveEddystone(Collection<EddystoneUID> eddystoneUids, SDKOptional<ETag> eTagSDKOptional) throws ClientException {
        String parameters = TextUtils.join((CharSequence)",", eddystoneUids);
        RequestDescription requestDescription = RequestDescription.start().setETag(eTagSDKOptional.isPresent() ? (ETag)eTagSDKOptional.get() : null).addParameter("euid", parameters).setOffset(eddystoneUids.size()).build();
        return this.getAndTransformToList("device", requestDescription, "devices", new SDKFunction<JSONObject, EddystoneFutureUID>(){

            public EddystoneFutureUID apply(JSONObject object) {
                return EddystoneFutureUID.from((JSONObject)object);
            }
        });
    }

    @Override
    public int assignDevicesToVenue(UUID venueId, Set<UUID> deviceIdSet) throws ClientException {
        List parameterList = HttpUtils.toUrlParameterList((String)"deviceId", deviceIdSet);
        parameterList.add(HttpUtils.toUrlParameter((String)"venueId", (String)venueId.toString()));
        return this.postAndReturnHttpStatus("beacon/assign", RequestDescription.start().addParameters(parameterList).build());
    }

    @Override
    public void assignDevicesToVenue(UUID venueId, Set<UUID> deviceIdSet, UpdateApiCallback apiUpdateCallback) {
        List parameterList = HttpUtils.toUrlParameterList((String)"deviceId", deviceIdSet);
        parameterList.add(HttpUtils.toUrlParameter((String)"venueId", (String)venueId.toString()));
        this.postAsyncAndReturnHttpStatus("device/assign", RequestDescription.start().addParameters(parameterList).build(), apiUpdateCallback);
    }

    @Override
    public int updateDevice(DeviceData deviceData) throws ClientException {
        return this.postAndReturnHttpStatus("device/update", RequestDescription.start().addParameters(deviceData.getParameters()).build());
    }

    @Override
    public void updateDevice(DeviceData deviceData, UpdateApiCallback callback) {
        this.postAsyncAndReturnHttpStatus("device/update", RequestDescription.start().addParameters(deviceData.getParameters()).build(), callback);
    }

    @Override
    public int moveDevicesToManager(Set<String> beaconUniqueIds, UUID receiverId, UUID receiverCompanyId) throws ClientException {
        List parameterList = HttpUtils.toUrlParameterList((String)"uniqueId", beaconUniqueIds);
        parameterList.add(HttpUtils.toUrlParameter((String)"managerId", (String)receiverId.toString()));
        parameterList.add(HttpUtils.toUrlParameter((String)"companyId", (String)receiverCompanyId.toString()));
        return this.postAndReturnHttpStatus("device/move", RequestDescription.start().addParameters(parameterList).build());
    }

    @Override
    public void moveDevicesToManager(Set<String> deviceUniqueIds, UUID receiverID, UUID receiverCompanyId, UpdateApiCallback apiUpdateCallback) {
        List parameterList = HttpUtils.toUrlParameterList((String)"uniqueId", deviceUniqueIds);
        parameterList.add(HttpUtils.toUrlParameter((String)"managerId", (String)receiverID.toString()));
        parameterList.add(HttpUtils.toUrlParameter((String)"companyId", (String)receiverCompanyId.toString()));
        this.postAsyncAndReturnHttpStatus("device/move", RequestDescription.start().addParameters(parameterList).build(), apiUpdateCallback);
    }

    @Override
    public int updateDevicePassword(String beaconUniqueId, String password) throws ClientException {
        RequestDescription requestDescription = RequestDescription.start().addParameter("uniqueId", beaconUniqueId).addParameter("password", password).build();
        return this.postAndReturnHttpStatus("beacon/update", requestDescription);
    }

    @Override
    public void updateDevicePassword(String beaconUniqueId, String password, UpdateApiCallback callback) {
        RequestDescription requestDescription = RequestDescription.start().addParameter("uniqueId", beaconUniqueId).addParameter("password", password).build();
        this.postAsyncAndReturnHttpStatus("beacon/update", requestDescription, callback);
    }

    private DeviceData buildIBeaconDeviceData(ICloudConfig config) {
        return DeviceData.update(DeviceType.CLOUD_BEACON, config.getDeviceUniqueId()).withWifiScanInterval(config.getWifiScanInterval()).withBleScanDuration(config.getBleScanDuration()).withInterval(config.getInterval()).withWorkingMode(config.getWorkingMode()).withDefaultSSIDAuth(config.getDefaultSSIDAuth()).withMinor(config.getMinor()).withTxPower(config.getTxPower()).withPassword(config.getPassword()).withDataSendInterval(config.getDataSendInterval()).withProximityUUID(config.getProximityUUID()).withDefaultSSIDCrypt(config.getDefaultSSIDCrypt()).withBleScanInterval(config.getBleScanInterval()).withDefaultSSIDName(config.getDefaultSSIDName()).withName(config.getName()).withMajor(config.getMajor()).build();
    }

    private DeviceData createConfigData(IConfig config) {
        DeviceData.Builder builder = DeviceData.update(DeviceType.BEACON, config.getDeviceUniqueId()).withTxPower(config.getTxPower());
        if (config.getMajor() > 0 && config.getMajor() < 65535) {
            builder.withMajor(config.getMajor());
        }
        if (config.getMinor() > 0 && config.getMinor() < 65535) {
            builder.withMinor(config.getMinor());
        }
        if (config.getUrl() != null) {
            builder.withUrl(EddystoneUtils.toHexString((byte[])EddystoneUtils.serializeUrl((String)config.getUrl())));
        }
        if (config.getInterval() > 0) {
            builder.withInterval(config.getInterval());
        }
        if (config.getNamespace() != null) {
            builder.withNamespace(config.getNamespace());
        }
        if (config.getProximityUUID() != null) {
            builder.withProximityUUID(config.getProximityUUID());
        }
        if (config.getInstanceId() != null) {
            builder.withInstanceId(config.getInstanceId());
        }
        return builder.build();
    }
}

