/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.http;

import com.kontakt.sdk.android.common.interfaces.SDKFunction;
import com.kontakt.sdk.android.common.model.SecureCommandResponse;
import com.kontakt.sdk.android.common.model.SecureCommandType;
import com.kontakt.sdk.android.common.util.HttpUtils;
import com.kontakt.sdk.android.http.AbstractApiAccessor;
import com.kontakt.sdk.android.http.HttpResult;
import com.kontakt.sdk.android.http.RequestDescription;
import com.kontakt.sdk.android.http.exception.ClientException;
import com.kontakt.sdk.android.http.interfaces.CommandApiAccessor;
import com.kontakt.sdk.android.http.interfaces.ResultApiCallback;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import org.json.JSONObject;

public class CommandApiAccessorImpl
extends AbstractApiAccessor
implements CommandApiAccessor {
    protected CommandApiAccessorImpl(String apiKey, String apiUrl) {
        super(apiKey, apiUrl);
    }

    @Override
    public HttpResult<List<SecureCommandResponse>> getSecureCommand(Collection<String> beaconUniqueIds, SecureCommandType secureCommandType) throws ClientException {
        RequestDescription description = RequestDescription.start().addParameters(HttpUtils.toUrlParameterList((String)"uniqueId", beaconUniqueIds)).addParameter("command", secureCommandType.name()).build();
        return this.getAndTransform("command/encrypt", description, new SDKFunction<JSONObject, List<SecureCommandResponse>>(){

            public List<SecureCommandResponse> apply(JSONObject object) {
                return SecureCommandResponse.fromList((JSONObject)object);
            }
        });
    }

    @Override
    public void getSecureCommand(Collection<String> beaconUniqueIds, SecureCommandType secureCommandType, ResultApiCallback<List<SecureCommandResponse>> apiCallback) {
        RequestDescription description = RequestDescription.start().addParameters(HttpUtils.toUrlParameterList((String)"uniqueId", beaconUniqueIds)).addParameter("command", secureCommandType.name()).build();
        this.transformToListAsynchronously("command/encrypt", description, 200, "commands", apiCallback, new SDKFunction<JSONObject, SecureCommandResponse>(){

            public SecureCommandResponse apply(JSONObject object) {
                return SecureCommandResponse.from((JSONObject)object);
            }
        });
    }

    @Override
    public void close() throws IOException {
    }
}

