/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.http;

import com.kontakt.sdk.android.common.FileData;
import com.kontakt.sdk.android.common.model.BeaconId;
import com.kontakt.sdk.android.common.model.DeviceType;
import com.kontakt.sdk.android.common.model.EddystoneFutureUID;
import com.kontakt.sdk.android.common.model.EddystoneUID;
import com.kontakt.sdk.android.common.model.EventPacket;
import com.kontakt.sdk.android.common.model.IAction;
import com.kontakt.sdk.android.common.model.IBeaconFutureId;
import com.kontakt.sdk.android.common.model.IBrowserAction;
import com.kontakt.sdk.android.common.model.ICloudConfig;
import com.kontakt.sdk.android.common.model.IConfig;
import com.kontakt.sdk.android.common.model.IContentAction;
import com.kontakt.sdk.android.common.model.ICredentials;
import com.kontakt.sdk.android.common.model.IDevice;
import com.kontakt.sdk.android.common.model.IFirmware;
import com.kontakt.sdk.android.common.model.IManager;
import com.kontakt.sdk.android.common.model.INamespace;
import com.kontakt.sdk.android.common.model.IPreset;
import com.kontakt.sdk.android.common.model.IProximityUUID;
import com.kontakt.sdk.android.common.model.IVenue;
import com.kontakt.sdk.android.common.model.SecureCommandResponse;
import com.kontakt.sdk.android.common.model.SecureCommandType;
import com.kontakt.sdk.android.common.model.SecureSingleConfig;
import com.kontakt.sdk.android.common.util.IBeaconPropertyValidator;
import com.kontakt.sdk.android.common.util.SDKOptional;
import com.kontakt.sdk.android.common.util.SDKPreconditions;
import com.kontakt.sdk.android.http.AbstractApiAccessor;
import com.kontakt.sdk.android.http.ETag;
import com.kontakt.sdk.android.http.HttpResult;
import com.kontakt.sdk.android.http.RequestDescription;
import com.kontakt.sdk.android.http.RequestValidator;
import com.kontakt.sdk.android.http.data.ActionData;
import com.kontakt.sdk.android.http.data.ConfigData;
import com.kontakt.sdk.android.http.data.DeviceData;
import com.kontakt.sdk.android.http.data.ManagerData;
import com.kontakt.sdk.android.http.data.VenueData;
import com.kontakt.sdk.android.http.exception.ClientException;
import com.kontakt.sdk.android.http.interfaces.ActionsApiAccessor;
import com.kontakt.sdk.android.http.interfaces.CommandApiAccessor;
import com.kontakt.sdk.android.http.interfaces.CommonApiAccessor;
import com.kontakt.sdk.android.http.interfaces.ConfigurationApiAccessor;
import com.kontakt.sdk.android.http.interfaces.DevicesApiAccessor;
import com.kontakt.sdk.android.http.interfaces.FirmwareApiAccessor;
import com.kontakt.sdk.android.http.interfaces.IKontaktApiClient;
import com.kontakt.sdk.android.http.interfaces.ManagersApiAccessor;
import com.kontakt.sdk.android.http.interfaces.ResultApiCallback;
import com.kontakt.sdk.android.http.interfaces.UpdateApiCallback;
import com.kontakt.sdk.android.http.interfaces.VenuesApiAccessor;
import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;

abstract class AbstractKontaktApiClient
implements IKontaktApiClient {
    protected static final int ACCEPT_VERSION = 9;
    protected final String apiKey;
    protected final String apiUrl;

    protected abstract DevicesApiAccessor devicesApi();

    protected abstract VenuesApiAccessor venuesApi();

    protected abstract ManagersApiAccessor managersApi();

    protected abstract ConfigurationApiAccessor configurationApi();

    protected abstract FirmwareApiAccessor firmwareApi();

    protected abstract ActionsApiAccessor actionsApi();

    protected abstract CommonApiAccessor commonsApi();

    protected abstract CommandApiAccessor commandApi();

    protected AbstractKontaktApiClient(String apiKey, String apiUrl) {
        SDKPreconditions.checkNotNullOrEmpty((String)apiKey, (String)"Api Client: Empty Api-Key.");
        SDKPreconditions.checkNotNullOrEmpty((String)apiUrl, (String)"Api Client: Empty Api Url.");
        this.apiKey = apiKey;
        this.apiUrl = apiUrl;
    }

    public HttpResult<ICredentials> getDeviceCredentials(String beaconUniqueId) throws ClientException {
        return this.getDeviceCredentials(beaconUniqueId, (SDKOptional<ETag>)SDKOptional.absent());
    }

    @Override
    public HttpResult<ICredentials> getDeviceCredentials(String deviceUniqueId, SDKOptional<ETag> eTag) throws ClientException {
        SDKPreconditions.checkNotNullOrEmpty((String)deviceUniqueId, (String)"Beacon unique ID is null or empty.");
        RequestValidator.validateETag(eTag);
        return this.devicesApi().getDeviceCredentials(deviceUniqueId, eTag);
    }

    public void getDeviceCredentials(String deviceUniqueId, ResultApiCallback<ICredentials> apiCallback) {
        this.getDeviceCredentials(deviceUniqueId, (SDKOptional<ETag>)SDKOptional.absent(), apiCallback);
    }

    @Override
    public void getDeviceCredentials(String deviceUniqueId, SDKOptional<ETag> etag, ResultApiCallback<ICredentials> apiCallback) {
        SDKPreconditions.checkNotNullOrEmpty((String)deviceUniqueId, (String)"Beacon unique ID is null or empty.");
        RequestValidator.validateETag(etag);
        SDKPreconditions.checkNotNull(apiCallback, (Object)"Callback is null");
        this.devicesApi().getDeviceCredentials(deviceUniqueId, etag, apiCallback);
    }

    @Override
    public HttpResult<IDevice> getDevice(String beaconUniqueId) throws ClientException {
        return this.getDevice(beaconUniqueId, (SDKOptional<ETag>)SDKOptional.absent());
    }

    @Override
    public HttpResult<IDevice> getDevice(String beaconUniqueId, SDKOptional<ETag> eTag) throws ClientException {
        SDKPreconditions.checkNotNullOrEmpty((String)beaconUniqueId, (String)"Beacon unique id is null");
        RequestValidator.validateETag(eTag);
        return this.devicesApi().getDevice(beaconUniqueId, eTag);
    }

    @Override
    public void getDevice(String deviceUniqueId, ResultApiCallback<IDevice> apiCallback) {
        this.getDevice(deviceUniqueId, (SDKOptional<ETag>)SDKOptional.absent(), apiCallback);
    }

    @Override
    public void getDevice(String deviceUniqueId, SDKOptional<ETag> etag, ResultApiCallback<IDevice> apiCallback) {
        SDKPreconditions.checkNotNullOrEmpty((String)deviceUniqueId, (String)"Beacon unique id is null");
        RequestValidator.validateETag(etag);
        this.devicesApi().getDevice(deviceUniqueId, etag, apiCallback);
    }

    @Override
    public int updateDevicePassword(String beaconUniqueId, String password) throws ClientException {
        SDKPreconditions.checkNotNullOrEmpty((String)beaconUniqueId, (String)"Beacon Unique Id is null.");
        IBeaconPropertyValidator.validateBeaconPassword((String)password, null);
        return this.devicesApi().updateDevicePassword(beaconUniqueId, password);
    }

    @Override
    public void updateDevicePassword(String beaconUniqueId, String password, UpdateApiCallback callback) {
        SDKPreconditions.checkNotNullOrEmpty((String)beaconUniqueId, (String)"Beacon Unique Id is null.");
        IBeaconPropertyValidator.validateBeaconPassword((String)password, null);
        this.devicesApi().updateDevicePassword(beaconUniqueId, password, callback);
    }

    @Override
    public HttpResult<List<IDevice>> listDevicesForManagers(Set<UUID> managerIds) throws ClientException {
        return this.listDevicesForManagers(managerIds, (SDKOptional<ETag>)SDKOptional.absent());
    }

    @Override
    public HttpResult<List<IDevice>> listDevicesForManagers(Set<UUID> managerIds, SDKOptional<ETag> eTag) throws ClientException {
        SDKPreconditions.checkNotNullOrEmpty(managerIds, (String)"Managers array cannot be empty");
        RequestValidator.validateETag(eTag);
        return this.devicesApi().listDevicesForManagers(managerIds, eTag);
    }

    @Override
    public void listDevicesForManagers(Set<UUID> managerIds, ResultApiCallback<List<IDevice>> apiCallback) {
        this.listDevicesForManagers(managerIds, (SDKOptional<ETag>)SDKOptional.absent(), apiCallback);
    }

    @Override
    public void listDevicesForManagers(Set<UUID> managerIds, SDKOptional<ETag> eTag, ResultApiCallback<List<IDevice>> apiCallback) {
        SDKPreconditions.checkNotNullOrEmpty(managerIds, (String)"Managers array cannot be empty");
        RequestValidator.validateETag(eTag);
        SDKPreconditions.checkNotNull(apiCallback, (Object)"Callback is null");
        this.devicesApi().listDevicesForManagers(managerIds, eTag, apiCallback);
    }

    @Override
    public int assignDevicesToVenue(UUID venueId, Set<UUID> beaconIdSet) throws ClientException {
        SDKPreconditions.checkNotNull((Object)venueId, (Object)"Venue Id is null");
        SDKPreconditions.checkNotNullOrEmpty(beaconIdSet, (String)"Beacon Ids set is null");
        return this.devicesApi().assignDevicesToVenue(venueId, beaconIdSet);
    }

    @Override
    public void assignDevicesToVenue(UUID venueId, Set<UUID> deviceIdSet, UpdateApiCallback apiUpdateCallback) {
        SDKPreconditions.checkNotNull((Object)venueId, (Object)"Venue Id is null");
        SDKPreconditions.checkNotNullOrEmpty(deviceIdSet, (String)"Beacon Ids set is null");
        this.devicesApi().assignDevicesToVenue(venueId, deviceIdSet, apiUpdateCallback);
    }

    @Override
    public HttpResult<List<ICredentials>> listDevicesCredentials(Collection<String> uniqueIds, SDKOptional<ETag> eTag) throws ClientException {
        SDKPreconditions.checkNotNullOrEmpty(uniqueIds, (String)"Unique ids are null or empty");
        SDKPreconditions.checkNotNull(eTag, (Object)"ETag is null or empty");
        return this.devicesApi().listDevicesCredentials(uniqueIds, eTag);
    }

    @Override
    public void listDevicesCredentials(Collection<String> uniqueIds, SDKOptional<ETag> eTag, ResultApiCallback<List<ICredentials>> resultApiCallback) {
        SDKPreconditions.checkNotNullOrEmpty(uniqueIds, (String)"Unique ids are null or empty");
        SDKPreconditions.checkNotNull(eTag, (Object)"ETag is null or empty");
        SDKPreconditions.checkNotNull(resultApiCallback);
        this.devicesApi().listDevicesCredentials(uniqueIds, eTag, resultApiCallback);
    }

    @Override
    public int assignDevicesToManager(UUID managerId, Set<UUID> beaconIdSet) throws ClientException {
        SDKPreconditions.checkNotNull((Object)managerId, (Object)"Manager Id is null");
        SDKPreconditions.checkNotNullOrEmpty(beaconIdSet, (String)"Beacon ids set is null");
        return this.devicesApi().assignDevicesToManager(managerId, beaconIdSet);
    }

    @Override
    public void assignDevicesToManager(UUID managerId, Set<UUID> beaconIdSet, UpdateApiCallback apiCallback) {
        SDKPreconditions.checkNotNull((Object)managerId, (Object)"Manager Id is null");
        SDKPreconditions.checkNotNullOrEmpty(beaconIdSet, (String)"Beacon ids set is null");
        this.devicesApi().assignDevicesToManager(managerId, beaconIdSet, apiCallback);
    }

    @Override
    public int updateDevice(DeviceData deviceData) throws ClientException {
        return this.devicesApi().updateDevice(deviceData);
    }

    @Override
    public void updateDevice(DeviceData deviceData, UpdateApiCallback callback) {
        this.devicesApi().updateDevice(deviceData, callback);
    }

    @Override
    public int moveDevicesToManager(Set<String> deviceUniqueIds, UUID receiverId, UUID receiverCompanyId) throws ClientException {
        SDKPreconditions.checkNotNullOrEmpty(deviceUniqueIds, (String)"Beacon Unique Ids set is null.");
        SDKPreconditions.checkNotNull((Object)receiverId, (Object)"Receiver Id is null.");
        SDKPreconditions.checkNotNull((Object)receiverCompanyId, (Object)"Receiver's company Id is null.");
        return this.devicesApi().moveDevicesToManager(deviceUniqueIds, receiverId, receiverCompanyId);
    }

    @Override
    public void moveDevicesToManager(Set<String> deviceUniqueIds, UUID receiverId, UUID receiverCompanyId, UpdateApiCallback apiUpdateCallback) {
        SDKPreconditions.checkNotNullOrEmpty(deviceUniqueIds, (String)"Beacon Unique Ids set is null.");
        SDKPreconditions.checkNotNull((Object)receiverId, (Object)"Receiver Id is null.");
        SDKPreconditions.checkNotNull((Object)receiverCompanyId, (Object)"Receiver's company Id is null.");
        this.devicesApi().moveDevicesToManager(deviceUniqueIds, receiverId, receiverCompanyId, apiUpdateCallback);
    }

    @Override
    public int updateVenue(VenueData venueData) throws ClientException {
        return this.venuesApi().updateVenue(venueData);
    }

    @Override
    public void updateVenue(VenueData venueData, UpdateApiCallback apiCallback) {
        this.venuesApi().updateVenue(venueData, apiCallback);
    }

    @Override
    public HttpResult<IVenue> createVenue(VenueData venue) throws ClientException {
        SDKPreconditions.checkNotNull((Object)venue, (Object)"Venue data is null.");
        return this.venuesApi().createVenue(venue);
    }

    @Override
    public void createVenue(VenueData venueData, ResultApiCallback<IVenue> apiCallback) {
        SDKPreconditions.checkNotNull((Object)venueData, (Object)"Venue data is null.");
        this.venuesApi().createVenue(venueData, apiCallback);
    }

    public HttpResult<IVenue> getVenue(UUID venueId) throws ClientException {
        return this.getVenue(venueId, (SDKOptional<ETag>)SDKOptional.absent());
    }

    public void getVenue(UUID venueId, ResultApiCallback<IVenue> apiCallback) {
        this.getVenue(venueId, (SDKOptional<ETag>)SDKOptional.absent(), apiCallback);
    }

    @Override
    public void getVenue(UUID venueId, SDKOptional<ETag> etag, ResultApiCallback<IVenue> apiCallback) {
        SDKPreconditions.checkNotNull((Object)venueId, (Object)"Venue Id is null.");
        this.venuesApi().getVenue(venueId, etag, apiCallback);
    }

    @Override
    public HttpResult<IVenue> getVenue(UUID venueId, SDKOptional<ETag> eTag) throws ClientException {
        SDKPreconditions.checkArgument((venueId != null ? 1 : 0) != 0, (Object)"Venue Id is null");
        RequestValidator.validateETag(eTag);
        return this.venuesApi().getVenue(venueId, eTag);
    }

    @Override
    public int deleteVenue(UUID venueId) throws ClientException {
        SDKPreconditions.checkNotNull((Object)venueId, (Object)"Venue Id is null.");
        return this.venuesApi().deleteVenue(venueId);
    }

    @Override
    public void deleteVenue(UUID venueId, UpdateApiCallback apiCallback) {
        SDKPreconditions.checkNotNull((Object)venueId, (String)"Venue Id is null", (Object[])new Object[]{venueId});
        SDKPreconditions.checkNotNull((Object)apiCallback, (Object)"Callback is null");
        this.venuesApi().deleteVenue(venueId, apiCallback);
    }

    @Override
    public HttpResult<FileData> getVenueImage(UUID venueId) throws ClientException {
        SDKPreconditions.checkNotNull((Object)venueId, (Object)"Venue Id is null.");
        return this.venuesApi().getVenueImage(venueId);
    }

    @Override
    public void getVenueImage(UUID venueId, ResultApiCallback<FileData> apiCallback) {
        SDKPreconditions.checkNotNull((Object)venueId, (Object)"Venue Id is null.");
        this.venuesApi().getVenueImage(venueId, apiCallback);
    }

    @Override
    public HttpResult<List<IManager>> listSubordinatesForManager(UUID managerId) throws ClientException {
        return this.listSubordinatesForManager(managerId, AbstractApiAccessor.DEFAULT_REQUEST_DESCRIPTION);
    }

    @Override
    public void listSubordinatesForManager(UUID managerId, ResultApiCallback<List<IManager>> resultApiCallback) {
        this.listSubordinatesForManager(managerId, AbstractApiAccessor.DEFAULT_REQUEST_DESCRIPTION, resultApiCallback);
    }

    @Override
    public void listSubordinatesForManager(UUID managerId, RequestDescription requestDescription, ResultApiCallback<List<IManager>> resultApiCallback) {
        SDKPreconditions.checkNotNull((Object)managerId, (Object)"Manager id is null");
        SDKPreconditions.checkNotNull((Object)requestDescription, (Object)"Request description is null.");
        this.managersApi().listSubordinatesForManager(managerId, requestDescription, resultApiCallback);
    }

    @Override
    public HttpResult<List<IManager>> listSubordinatesForManager(UUID managerId, RequestDescription requestDescription) throws ClientException {
        SDKPreconditions.checkNotNull((Object)managerId, (Object)"Manager Id is null.");
        SDKPreconditions.checkNotNull((Object)requestDescription, (Object)"Request Description is null.");
        return this.managersApi().listSubordinatesForManager(managerId, requestDescription);
    }

    @Override
    public int deleteManager(UUID managerId) throws ClientException {
        SDKPreconditions.checkNotNull((Object)managerId, (Object)"Manager Id is null.");
        return this.managersApi().deleteManager(managerId);
    }

    @Override
    public void deleteManager(UUID managerId, UpdateApiCallback apiCallback) {
        SDKPreconditions.checkNotNull((Object)managerId, (Object)"Manager Id is null.");
        this.managersApi().deleteManager(managerId, apiCallback);
    }

    @Override
    public int updateManager(ManagerData managerData) throws ClientException {
        SDKPreconditions.checkNotNull((Object)managerData, (Object)"Manager data cannot be null");
        return this.managersApi().updateManager(managerData);
    }

    @Override
    public void updateManager(ManagerData managerData, UpdateApiCallback updateApiCallback) {
        SDKPreconditions.checkNotNull((Object)managerData, (Object)"Manager data cannot be null");
        this.managersApi().updateManager(managerData, updateApiCallback);
    }

    @Override
    public HttpResult<IManager> createManager(ManagerData manager) throws ClientException {
        SDKPreconditions.checkNotNull((Object)manager, (Object)"Manager data is null");
        return this.managersApi().createManager(manager);
    }

    @Override
    public void createManager(ManagerData managerData, ResultApiCallback<IManager> apiCallback) {
        SDKPreconditions.checkNotNull((Object)managerData, (Object)"Manager data is null");
        this.managersApi().createManager(managerData, apiCallback);
    }

    @Override
    public HttpResult<IManager> getManager(UUID managerId, SDKOptional<ETag> eTagOptional) throws ClientException {
        SDKPreconditions.checkNotNull((Object)managerId, (Object)"Manager Id is null");
        RequestValidator.validateETag(eTagOptional);
        return this.managersApi().getManager(managerId, eTagOptional);
    }

    @Override
    public void getManager(UUID managerId, ResultApiCallback<IManager> apiCallback) {
        this.getManager(managerId, (SDKOptional<ETag>)SDKOptional.absent(), apiCallback);
    }

    @Override
    public HttpResult<IManager> getManager(UUID managerId) throws ClientException {
        return this.getManager(managerId, (SDKOptional<ETag>)SDKOptional.absent());
    }

    @Override
    public void getManager(UUID managerId, SDKOptional<ETag> etag, ResultApiCallback<IManager> apiCallback) {
        SDKPreconditions.checkNotNull((Object)managerId, (Object)"Manager id is null.");
        RequestValidator.validateETag(etag);
        this.managersApi().getManager(managerId, etag, apiCallback);
    }

    @Override
    public int assignManagersToSupervisor(UUID supervisorId, Set<UUID> managerIdSet) throws ClientException {
        SDKPreconditions.checkNotNull((Object)supervisorId, (Object)"Supervisor Id cannot be null");
        SDKPreconditions.checkNotNullOrEmpty(managerIdSet, (String)"Manager Ids cannot be null");
        return this.managersApi().assignManagersToSupervisor(supervisorId, managerIdSet);
    }

    @Override
    public void assignManagersToSupervisor(UUID supervisorId, Set<UUID> managerIdSet, UpdateApiCallback apiCallback) {
        SDKPreconditions.checkNotNull((Object)supervisorId, (Object)"Supervisor Id cannot be null");
        SDKPreconditions.checkNotNullOrEmpty(managerIdSet, (String)"Manager Ids cannot be null");
        this.managersApi().assignManagersToSupervisor(supervisorId, managerIdSet, apiCallback);
    }

    @Override
    public HttpResult<List<IConfig>> listConfigs() throws ClientException {
        RequestDescription requestDescription = RequestDescription.start().addParameter("deviceType", DeviceType.BEACON.name()).build();
        return this.listConfigs(requestDescription);
    }

    @Override
    public void listConfigs(ResultApiCallback<List<IConfig>> apiCallback) {
        RequestDescription requestDescription = RequestDescription.start().addParameter("deviceType", DeviceType.BEACON.name()).build();
        this.listConfigs(requestDescription, apiCallback);
    }

    @Override
    public void listConfigs(RequestDescription requestDescription, ResultApiCallback<List<IConfig>> apiCallback) {
        RequestValidator.configsListingPreconditions(requestDescription);
        this.configurationApi().listConfigs(requestDescription, apiCallback);
    }

    @Override
    public HttpResult<List<IConfig>> listConfigs(RequestDescription requestDescription) throws ClientException {
        RequestValidator.configsListingPreconditions(requestDescription);
        return this.configurationApi().listConfigs(requestDescription);
    }

    @Override
    public HttpResult<List<ICloudConfig>> listCloudConfigs() throws ClientException {
        return this.listCloudConfigs(RequestDescription.start().addParameter("deviceType", DeviceType.CLOUD_BEACON.name()).build());
    }

    @Override
    public void listCloudConfigs(ResultApiCallback<List<ICloudConfig>> apiCallback) {
        this.listCloudConfigs(AbstractApiAccessor.DEFAULT_REQUEST_DESCRIPTION, apiCallback);
    }

    @Override
    public HttpResult<List<ICloudConfig>> listCloudConfigs(RequestDescription requestDescription) throws ClientException {
        RequestValidator.cloudConfigsListingPreconditions(requestDescription);
        return this.configurationApi().listCloudConfigs(requestDescription);
    }

    @Override
    public void listCloudConfigs(RequestDescription requestDescription, ResultApiCallback<List<ICloudConfig>> apiCallback) {
        RequestValidator.cloudConfigsListingPreconditions(requestDescription);
        SDKPreconditions.checkNotNull(apiCallback, (Object)"Callback is null.");
        this.configurationApi().listCloudConfigs(requestDescription, apiCallback);
    }

    @Override
    public HttpResult<IConfig> createConfig(ConfigData configData) throws ClientException {
        SDKPreconditions.checkNotNull((Object)configData, (Object)"Config data is null.");
        return this.configurationApi().createConfig(configData);
    }

    @Override
    public void createConfig(ConfigData configData, ResultApiCallback<IConfig> apiCallback) {
        SDKPreconditions.checkNotNull((Object)configData, (Object)"Config data is null.");
        this.configurationApi().createConfig(configData, apiCallback);
    }

    @Override
    public void createCloudConfig(ConfigData configData, ResultApiCallback<ICloudConfig> apiCallback) {
        SDKPreconditions.checkNotNull((Object)configData, (Object)"Config data is null.");
        this.configurationApi().createCloudConfig(configData, apiCallback);
    }

    @Override
    public HttpResult<ICloudConfig> createCloudConfig(ConfigData configData) throws ClientException {
        SDKPreconditions.checkNotNull((Object)configData, (Object)"Config data is null.");
        return this.configurationApi().createCloudConfig(configData);
    }

    @Override
    public int applyConfig(IConfig config) throws ClientException {
        SDKPreconditions.checkNotNull((Object)config, (Object)"Config is null");
        return this.devicesApi().applyConfig(config);
    }

    @Override
    public void applyConfig(IConfig config, UpdateApiCallback apiCallback) {
        SDKPreconditions.checkNotNull((Object)config, (Object)"Config is null");
        SDKPreconditions.checkNotNull((Object)apiCallback, (Object)"Callback is null.");
        this.devicesApi().applyConfig(config, apiCallback);
    }

    @Override
    public int applyCloudConfig(ICloudConfig cloudConfig) throws ClientException {
        SDKPreconditions.checkNotNull((Object)cloudConfig, (Object)"Config is null");
        return this.devicesApi().applyCloudConfig(cloudConfig);
    }

    @Override
    public void applyConfig(ICloudConfig cloudConfig, UpdateApiCallback apiCallback) {
        SDKPreconditions.checkNotNull((Object)cloudConfig, (Object)"Config is null");
        SDKPreconditions.checkNotNull((Object)apiCallback, (Object)"Callback is null.");
        this.devicesApi().applyConfig(cloudConfig, apiCallback);
    }

    @Override
    public HttpResult<IConfig> getConfigForDevice(String beaconUniqueId) throws ClientException {
        return this.getConfigForDevice(beaconUniqueId, (SDKOptional<ETag>)SDKOptional.absent());
    }

    @Override
    public void getConfigForDevice(String beaconUniqueId, ResultApiCallback<IConfig> apiCallback) {
        this.getConfigForDevice(beaconUniqueId, (SDKOptional<ETag>)SDKOptional.absent(), apiCallback);
    }

    @Override
    public void getConfigForDevice(String beaconUniqueId, SDKOptional<ETag> etag, ResultApiCallback<IConfig> apiCallback) {
        SDKPreconditions.checkNotNullOrEmpty((String)beaconUniqueId, (String)"Device Unique id is null or empty");
        RequestValidator.validateETag(etag);
        this.configurationApi().getConfigForDevice(beaconUniqueId, etag, apiCallback);
    }

    @Override
    public HttpResult<IConfig> getConfigForDevice(String beaconUniqueId, SDKOptional<ETag> eTag) throws ClientException {
        SDKPreconditions.checkNotNullOrEmpty((String)beaconUniqueId, (String)"Beacon unique Id is null or empty");
        RequestValidator.validateETag(eTag);
        return this.configurationApi().getConfigForDevice(beaconUniqueId, eTag);
    }

    @Override
    public HttpResult<ICloudConfig> getCloudConfigForDevice(String deviceUniqueId) throws ClientException {
        return this.getCloudConfigForDevice(deviceUniqueId, (SDKOptional<ETag>)SDKOptional.absent());
    }

    @Override
    public HttpResult<ICloudConfig> getCloudConfigForDevice(String beaconUniqueId, SDKOptional<ETag> eTag) throws ClientException {
        SDKPreconditions.checkNotNullOrEmpty((String)beaconUniqueId, (String)"Beacon Unique Id is null or empty");
        RequestValidator.validateETag(eTag);
        return this.configurationApi().getCloudConfigForDevice(beaconUniqueId, eTag);
    }

    @Override
    public void getCloudConfigForDevice(String beaconUniqueId, ResultApiCallback<ICloudConfig> apiCallback) {
        this.getCloudConfigForDevice(beaconUniqueId, (SDKOptional<ETag>)SDKOptional.absent(), apiCallback);
    }

    @Override
    public void getCloudConfigForDevice(String beaconUniqueId, SDKOptional<ETag> eTag, ResultApiCallback<ICloudConfig> apiCallback) {
        SDKPreconditions.checkNotNullOrEmpty((String)beaconUniqueId, (String)"Beacon Unique Id is null or empty");
        RequestValidator.validateETag(eTag);
        this.configurationApi().getCloudConfigForDevice(beaconUniqueId, eTag, apiCallback);
    }

    @Override
    public HttpResult<List<IPreset>> getPresets() throws ClientException {
        return this.getPresets((SDKOptional<ETag>)SDKOptional.absent());
    }

    @Override
    public void getPresets(ResultApiCallback<List<IPreset>> apiCallback) {
        this.getPresets((SDKOptional<ETag>)SDKOptional.absent(), apiCallback);
    }

    @Override
    public void getPresets(SDKOptional<ETag> eTag, ResultApiCallback<List<IPreset>> apiCallback) {
        RequestValidator.validateETag(eTag);
        SDKPreconditions.checkNotNull(apiCallback, (Object)"Api callback is null.");
        this.configurationApi().getPresets(eTag, apiCallback);
    }

    @Override
    public HttpResult<List<IPreset>> getPresets(SDKOptional<ETag> eTag) throws ClientException {
        RequestValidator.validateETag(eTag);
        return this.configurationApi().getPresets(eTag);
    }

    @Override
    public HttpResult<IPreset> getPreset(String profileName) throws ClientException {
        return this.getPreset(profileName, (SDKOptional<ETag>)SDKOptional.absent());
    }

    @Override
    public void getPreset(String profileName, ResultApiCallback<IPreset> apiCallback) {
        this.configurationApi().getPreset(profileName, (SDKOptional<ETag>)SDKOptional.absent(), apiCallback);
    }

    @Override
    public void getPreset(String profileName, SDKOptional<ETag> etag, ResultApiCallback<IPreset> apiCallback) {
        SDKPreconditions.checkNotNullOrEmpty((String)profileName, (String)"Preset name is null or empty");
        RequestValidator.validateETag(etag);
        this.configurationApi().getPreset(profileName, etag, apiCallback);
    }

    @Override
    public HttpResult<IPreset> getPreset(String profileName, SDKOptional<ETag> eTag) throws ClientException {
        SDKPreconditions.checkNotNullOrEmpty((String)profileName, (String)"Preset name is null or empty");
        RequestValidator.validateETag(eTag);
        return this.configurationApi().getPreset(profileName, eTag);
    }

    @Override
    public HttpResult<List<SecureSingleConfig>> listSecureConfigs(SDKOptional<ETag> etag) throws ClientException {
        return this.configurationApi().listSecureConfigs(etag);
    }

    @Override
    public void listSecureConfigs(SDKOptional<ETag> etag, ResultApiCallback<List<SecureSingleConfig>> apiCallback) {
        this.configurationApi().listSecureConfigs(etag, apiCallback);
    }

    @Override
    public HttpResult<List<SecureSingleConfig>> listSecureConfigs(RequestDescription requestDescription) throws ClientException {
        return this.configurationApi().listSecureConfigs(requestDescription);
    }

    @Override
    public void listSecureConfigs(RequestDescription requestDescription, ResultApiCallback<List<SecureSingleConfig>> apiCallback) {
        this.configurationApi().listSecureConfigs(requestDescription, apiCallback);
    }

    @Override
    public void listSecureConfigs(Collection<String> uniqueId, SDKOptional<ETag> eTag, ResultApiCallback<List<SecureSingleConfig>> apiCallback) {
        this.configurationApi().listSecureConfigs(uniqueId, eTag, apiCallback);
    }

    @Override
    public HttpResult<List<SecureSingleConfig>> listSecureConfigs(Collection<String> uniqueId, SDKOptional<ETag> eTag) throws ClientException {
        return this.configurationApi().listSecureConfigs(uniqueId, eTag);
    }

    @Override
    public HttpResult<List<SecureSingleConfig>> applySecureConfig(Collection<SecureSingleConfig> secureConfigApplies) throws ClientException {
        return this.devicesApi().applySecureConfig(secureConfigApplies);
    }

    @Override
    public void applySecureConfig(Collection<SecureSingleConfig> secureConfigApplies, ResultApiCallback<List<SecureSingleConfig>> apiCallback) {
        this.devicesApi().applySecureConfig(secureConfigApplies, apiCallback);
    }

    @Override
    @Deprecated
    public HttpResult<Map<String, IFirmware>> getLatestFirmwareForBeacons(Set<String> beaconUniqueIds) throws ClientException {
        return this.getLatestFirmwareForBeacons(beaconUniqueIds, (SDKOptional<ETag>)SDKOptional.absent());
    }

    @Override
    @Deprecated
    public void getLatestFirmwareForBeacons(Set<String> deviceUniqueIds, ResultApiCallback<Map<String, IFirmware>> callback) {
        this.getLatestFirmwareForBeacons(deviceUniqueIds, (SDKOptional<ETag>)SDKOptional.absent(), callback);
    }

    @Override
    public void fetchFirmwareFileData(String firmwareName, ResultApiCallback<FileData> resultApiCallback) {
        this.fetchFirmwareFileData(firmwareName, (SDKOptional<ETag>)SDKOptional.absent(), resultApiCallback);
    }

    @Override
    public void getFirmware(String firmwareName, DeviceType deviceType, ResultApiCallback<IFirmware> apiCallback) {
        this.getFirmware(firmwareName, deviceType, (SDKOptional<ETag>)SDKOptional.absent(), apiCallback);
    }

    @Override
    public HttpResult<List<IFirmware>> getFirmwares(Set<String> deviceUniqueIds) throws ClientException {
        return this.firmwareApi().getFirmwares(deviceUniqueIds);
    }

    @Override
    public void getFirmwares(Set<String> deviceUniqueIds, ResultApiCallback<List<IFirmware>> apiCallback) {
        this.firmwareApi().getFirmwares(deviceUniqueIds, apiCallback);
    }

    @Override
    @Deprecated
    public HttpResult<Map<String, IFirmware>> getLatestFirmwareForBeacons(Set<String> beaconUniqueIds, SDKOptional<ETag> eTag) throws ClientException {
        SDKPreconditions.checkNotNullOrEmpty(beaconUniqueIds, (String)"Beacon Unique Ids set is null or empty.");
        return this.firmwareApi().getLatestFirmwareForBeacons(beaconUniqueIds, eTag);
    }

    @Override
    @Deprecated
    public void getLatestFirmwareForBeacons(Set<String> deviceUniqueIds, SDKOptional<ETag> eTag, ResultApiCallback<Map<String, IFirmware>> apiCallback) {
        SDKPreconditions.checkNotNullOrEmpty(deviceUniqueIds, (String)"Beacon Unique Ids set is null or empty.");
        RequestValidator.validateETag(eTag);
        this.firmwareApi().getLatestFirmwareForBeacons(deviceUniqueIds, eTag, apiCallback);
    }

    @Override
    public HttpResult<IFirmware> getFirmware(String firmwareName, DeviceType deviceType) throws ClientException {
        return this.getFirmware(firmwareName, deviceType, (SDKOptional<ETag>)SDKOptional.absent());
    }

    @Override
    public HttpResult<IFirmware> getFirmware(String firmwareName, DeviceType deviceType, SDKOptional<ETag> eTag) throws ClientException {
        SDKPreconditions.checkNotNullOrEmpty((String)firmwareName, (String)"Firmware name is null or empty");
        SDKPreconditions.checkNotNull((Object)deviceType, (Object)"Device type is null");
        RequestValidator.validateETag(eTag);
        return this.firmwareApi().getFirmware(firmwareName, deviceType, eTag);
    }

    @Override
    public void getFirmware(String firmwareName, DeviceType deviceType, SDKOptional<ETag> eTag, ResultApiCallback<IFirmware> apiCallback) {
        SDKPreconditions.checkNotNullOrEmpty((String)firmwareName, (String)"Firmware name is null or empty");
        SDKPreconditions.checkNotNull((Object)deviceType, (Object)"Device type is null");
        RequestValidator.validateETag(eTag);
        this.firmwareApi().getFirmware(firmwareName, deviceType, eTag, apiCallback);
    }

    @Override
    public HttpResult<FileData> fetchFirmwareFileData(String firmwareName) throws ClientException {
        return this.fetchFirmwareFileData(firmwareName, (SDKOptional<ETag>)SDKOptional.absent());
    }

    @Override
    public HttpResult<FileData> fetchFirmwareFileData(String firmwareName, SDKOptional<ETag> eTag) throws ClientException {
        SDKPreconditions.checkNotNullOrEmpty((String)firmwareName, (String)"Firmware name is null or empty.");
        RequestValidator.validateETag(eTag);
        return this.firmwareApi().fetchFirmwareFileData(firmwareName, eTag);
    }

    @Override
    public void fetchFirmwareFileData(String firmwareName, SDKOptional<ETag> etag, ResultApiCallback<FileData> resultApiCallback) {
        SDKPreconditions.checkNotNull((Object)firmwareName, (Object)"Firmware name is null");
        RequestValidator.validateETag(etag);
        this.firmwareApi().fetchFirmwareFileData(firmwareName, etag, resultApiCallback);
    }

    @Override
    public HttpResult<IDevice> getDeviceByNamespaceAndInstanceId(String namespace, String instanceId) throws ClientException {
        SDKPreconditions.checkNotNull((Object)namespace, (Object)"Namespace is null.");
        SDKPreconditions.checkNotNull((Object)instanceId, (Object)"Instance id is null.");
        return this.devicesApi().getDeviceByNamespaceAndInstanceId(namespace, instanceId);
    }

    @Override
    public HttpResult<IDevice> getDeviceByNamespaceAndInstanceId(String namespace, String instanceId, SDKOptional<ETag> eTag) throws ClientException {
        SDKPreconditions.checkNotNull((Object)namespace, (Object)"Namespace is null.");
        SDKPreconditions.checkNotNull((Object)instanceId, (Object)"Instance id is null.");
        RequestValidator.validateETag(eTag);
        return this.devicesApi().getDeviceByNamespaceAndInstanceId(namespace, instanceId, eTag);
    }

    @Override
    public void getDeviceByNamespaceAndInstanceId(String namespace, String instanceId, ResultApiCallback<IDevice> apiCallback) {
        this.getDeviceByNamespaceAndInstanceId(namespace, instanceId, (SDKOptional<ETag>)SDKOptional.absent(), apiCallback);
    }

    @Override
    public void getDeviceByNamespaceAndInstanceId(String namespace, String instanceId, SDKOptional<ETag> eTag, ResultApiCallback<IDevice> apiCallback) {
        SDKPreconditions.checkNotNull((Object)namespace, (Object)"Namespace is null.");
        SDKPreconditions.checkNotNull((Object)instanceId, (Object)"Instance id is null.");
        SDKPreconditions.checkNotNull(apiCallback, (Object)"Callback is null.");
        RequestValidator.validateETag(eTag);
        this.devicesApi().getDeviceByNamespaceAndInstanceId(namespace, instanceId, eTag, apiCallback);
    }

    public HttpResult<FileData> getActionContent(UUID actionId) throws ClientException {
        return this.getActionContent(actionId, (SDKOptional<ETag>)SDKOptional.absent());
    }

    @Override
    public HttpResult<FileData> getActionContent(UUID actionId, SDKOptional<ETag> eTag) throws ClientException {
        SDKPreconditions.checkNotNull((Object)actionId, (Object)"Action Id is null.");
        return this.actionsApi().getActionContent(actionId, eTag);
    }

    @Override
    public HttpResult<IAction> getAction(UUID actionId) throws ClientException {
        return this.getAction(actionId, (SDKOptional<ETag>)SDKOptional.absent());
    }

    @Override
    public HttpResult<IContentAction> createContentAction(ActionData actionData, File file) throws ClientException {
        RequestValidator.contentActionCreationPreconditions(actionData, file);
        return this.actionsApi().createContentAction(actionData, file);
    }

    @Override
    public void createContentAction(ActionData actionData, File contentFile, ResultApiCallback<IContentAction> apiCallback) {
        RequestValidator.contentActionCreationPreconditions(actionData, contentFile);
        SDKPreconditions.checkNotNull(apiCallback, (Object)"Callback is null.");
        this.actionsApi().createContentAction(actionData, contentFile, apiCallback);
    }

    @Override
    public HttpResult<IBrowserAction> createBrowserAction(ActionData actionData) throws ClientException {
        RequestValidator.browserActionCreationPreconditions(actionData);
        return this.actionsApi().createBrowserAction(actionData);
    }

    @Override
    public void createBrowserAction(ActionData actionData, ResultApiCallback<IBrowserAction> resultApiCallback) {
        RequestValidator.browserActionCreationPreconditions(actionData);
        SDKPreconditions.checkNotNull(resultApiCallback, (Object)"Callback is null.");
        this.actionsApi().createBrowserAction(actionData, resultApiCallback);
    }

    @Override
    public void getAction(UUID actionId, ResultApiCallback<IAction> resultApiCallback) {
        this.getAction(actionId, (SDKOptional<ETag>)SDKOptional.absent(), resultApiCallback);
    }

    @Override
    public HttpResult<IAction> getAction(UUID actionId, SDKOptional<ETag> eTag) throws ClientException {
        RequestValidator.actionRetrievalPreconditions(actionId, eTag);
        return this.actionsApi().getAction(actionId, eTag);
    }

    @Override
    public void getAction(UUID actionId, SDKOptional<ETag> etag, ResultApiCallback<IAction> resultApiCallback) {
        RequestValidator.actionRetrievalPreconditions(actionId, etag);
        SDKPreconditions.checkNotNull(resultApiCallback, (Object)"Callback is null.");
        this.actionsApi().getAction(actionId, etag, resultApiCallback);
    }

    @Override
    public int updateAction(UUID actionId, File file) throws ClientException {
        RequestValidator.actionUpdatePreconditions(actionId, file);
        return this.actionsApi().updateAction(actionId, file);
    }

    @Override
    public void updateAction(UUID actionId, File file, UpdateApiCallback callback) {
        RequestValidator.actionUpdatePreconditions(actionId, file);
        SDKPreconditions.checkNotNull((Object)callback, (Object)"Callback is null.");
        this.actionsApi().updateAction(actionId, file, callback);
    }

    @Override
    public int updateAction(UUID actionId, String url) throws ClientException {
        RequestValidator.actionUpdatePreconditions(actionId, url);
        return this.actionsApi().updateAction(actionId, url);
    }

    @Override
    public void updateAction(UUID actionId, String url, UpdateApiCallback callback) {
        RequestValidator.actionUpdatePreconditions(actionId, url);
        SDKPreconditions.checkNotNull((Object)callback, (Object)"Callback is null.");
        this.actionsApi().updateAction(actionId, url, callback);
    }

    @Override
    public int deleteAction(UUID actionId) throws ClientException {
        RequestValidator.actionDeletionPreconditions(actionId);
        return this.actionsApi().deleteAction(actionId);
    }

    @Override
    public void deleteAction(UUID actionId, UpdateApiCallback apiCallback) {
        RequestValidator.actionDeletionPreconditions(actionId);
        SDKPreconditions.checkNotNull((Object)apiCallback, (Object)"Callback is null.");
        this.actionsApi().deleteAction(actionId, apiCallback);
    }

    @Override
    public void getActionContent(UUID actionId, SDKOptional<ETag> eTagSDKOptional, ResultApiCallback<FileData> resultApiCallback) {
        SDKPreconditions.checkNotNull((Object)actionId, (Object)"Action Id is null.");
        RequestValidator.validateETag(eTagSDKOptional);
        this.actionsApi().getActionContent(actionId, eTagSDKOptional, resultApiCallback);
    }

    @Override
    public HttpResult<List<IAction>> getActionsForDevice(String deviceUniqueId) throws ClientException {
        SDKPreconditions.checkNotNull((Object)deviceUniqueId, (Object)"Device unique id is null.");
        return this.actionsApi().getActionsForDevice(deviceUniqueId);
    }

    @Override
    public void getActionsForDevice(String deviceUniqueId, ResultApiCallback<List<IAction>> resultApiCallback) {
        SDKPreconditions.checkNotNull((Object)deviceUniqueId, (Object)"Device unique id is null.");
        this.actionsApi().getActionsForDevice(deviceUniqueId, resultApiCallback);
    }

    @Override
    public HttpResult<List<IProximityUUID>> listProximities() throws ClientException {
        return this.commonsApi().listProximities();
    }

    @Override
    public void listProximities(SDKOptional<ETag> etag, ResultApiCallback<List<IProximityUUID>> apiCallback) {
        RequestValidator.validateETag(etag);
        SDKPreconditions.checkNotNull(apiCallback, (Object)"Callback is null.");
        this.commonsApi().listProximities(etag, apiCallback);
    }

    @Override
    public void listProximities(ResultApiCallback<List<IProximityUUID>> apiCallback) {
        SDKPreconditions.checkNotNull(apiCallback, (Object)"Callback is null.");
        this.commonsApi().listProximities(apiCallback);
    }

    @Override
    public HttpResult<List<IProximityUUID>> listProximities(SDKOptional<ETag> eTag) throws ClientException {
        RequestValidator.validateETag(eTag);
        return this.commonsApi().listProximities(eTag);
    }

    @Override
    public HttpResult<List<IProximityUUID>> resolveProximities(List<UUID> proximities) throws ClientException {
        SDKPreconditions.checkNotNull(proximities, (Object)"Provided proximities list is null");
        return this.commonsApi().resolveProximities(proximities);
    }

    @Override
    public HttpResult<List<IProximityUUID>> resolveProximities(List<UUID> proximities, SDKOptional<ETag> etag) throws ClientException {
        SDKPreconditions.checkNotNull(proximities, (Object)"Provided proximities list is null");
        RequestValidator.validateETag(etag);
        return this.commonsApi().resolveProximities(proximities, etag);
    }

    @Override
    public void resolveProximities(List<UUID> proximities, ResultApiCallback<List<IProximityUUID>> apiCallback) {
        SDKPreconditions.checkNotNull(proximities, (Object)"Provided proximities list is null");
        SDKPreconditions.checkNotNull(apiCallback, (Object)"Callback is null.");
        this.commonsApi().resolveProximities(proximities, apiCallback);
    }

    @Override
    public void resolveProximities(List<UUID> proximities, SDKOptional<ETag> etag, ResultApiCallback<List<IProximityUUID>> apiCallback) {
        SDKPreconditions.checkNotNull(proximities, (Object)"Provided proximities list is null");
        RequestValidator.validateETag(etag);
        SDKPreconditions.checkNotNull(apiCallback, (Object)"Callback is null.");
        this.commonsApi().resolveProximities(proximities, etag, apiCallback);
    }

    @Override
    public HttpResult<List<INamespace>> listNamespaces() throws ClientException {
        return this.commonsApi().listNamespaces();
    }

    @Override
    public HttpResult<List<INamespace>> listNamespaces(SDKOptional<ETag> etag) throws ClientException {
        RequestValidator.validateETag(etag);
        return this.commonsApi().listNamespaces(etag);
    }

    @Override
    public void listNamespaces(ResultApiCallback<List<INamespace>> apiCallback) {
        SDKPreconditions.checkNotNull(apiCallback, (Object)"Callback is null.");
        this.commonsApi().listNamespaces(apiCallback);
    }

    @Override
    public void listNamespaces(SDKOptional<ETag> etag, ResultApiCallback<List<INamespace>> apiCallback) {
        RequestValidator.validateETag(etag);
        SDKPreconditions.checkNotNull(apiCallback, (Object)"Callback is null.");
        this.commonsApi().listNamespaces(etag, apiCallback);
    }

    @Override
    public HttpResult<List<INamespace>> resolveNamespaces(List<String> namespaces) throws ClientException {
        SDKPreconditions.checkNotNull(namespaces, (Object)"Provided namespaces list is null");
        return this.commonsApi().resolveNamespaces(namespaces);
    }

    @Override
    public HttpResult<List<INamespace>> resolveNamespaces(List<String> namespaces, SDKOptional<ETag> etag) throws ClientException {
        SDKPreconditions.checkNotNull(namespaces, (Object)"Provided namespaces list is null");
        RequestValidator.validateETag(etag);
        return this.commonsApi().resolveNamespaces(namespaces, etag);
    }

    @Override
    public void resolveNamespaces(List<String> namespaces, ResultApiCallback<List<INamespace>> apiCallback) {
        SDKPreconditions.checkNotNull(namespaces, (Object)"Provided namespaces list is null");
        SDKPreconditions.checkNotNull(apiCallback, (Object)"Callback is null.");
        this.commonsApi().resolveNamespaces(namespaces, apiCallback);
    }

    @Override
    public void resolveNamespaces(List<String> namespaces, SDKOptional<ETag> etag, ResultApiCallback<List<INamespace>> apiCallback) {
        SDKPreconditions.checkNotNull(namespaces, (Object)"Provided namespaces list is null");
        SDKPreconditions.checkNotNull(apiCallback, (Object)"Callback is null.");
        RequestValidator.validateETag(etag);
        this.commonsApi().resolveNamespaces(namespaces, etag, apiCallback);
    }

    @Override
    public HttpResult<List<IVenue>> listVenues() throws ClientException {
        return this.venuesApi().listVenues(AbstractApiAccessor.DEFAULT_REQUEST_DESCRIPTION);
    }

    @Override
    public HttpResult<List<IVenue>> listVenues(RequestDescription requestDescription) throws ClientException {
        SDKPreconditions.checkNotNull((Object)requestDescription, (Object)"RequestDescription is null.");
        return this.venuesApi().listVenues(requestDescription);
    }

    @Override
    public void listVenues(ResultApiCallback<List<IVenue>> apiCallback) {
        SDKPreconditions.checkNotNull(apiCallback, (Object)"Callback is null.");
        this.listVenues(AbstractApiAccessor.DEFAULT_REQUEST_DESCRIPTION, apiCallback);
    }

    @Override
    public void listVenues(RequestDescription requestDescription, ResultApiCallback<List<IVenue>> apiCallback) {
        SDKPreconditions.checkNotNull(apiCallback, (Object)"Callback is null.");
        SDKPreconditions.checkNotNull((Object)requestDescription, (Object)"RequestDescription is null.");
        this.venuesApi().listVenues(requestDescription, apiCallback);
    }

    @Override
    public HttpResult<List<IDevice>> listDevices() throws ClientException {
        return this.devicesApi().listDevices();
    }

    @Override
    public HttpResult<List<IDevice>> listDevices(RequestDescription requestDescription) throws ClientException {
        SDKPreconditions.checkNotNull((Object)requestDescription, (Object)"RequestDescription is null.");
        return this.devicesApi().listDevices(requestDescription);
    }

    @Override
    public void listDevices(ResultApiCallback<List<IDevice>> apiCallback) {
        SDKPreconditions.checkNotNull(apiCallback, (Object)"Callback is null.");
        this.devicesApi().listDevices(apiCallback);
    }

    @Override
    public void listDevices(RequestDescription requestDescription, ResultApiCallback<List<IDevice>> apiCallback) {
        SDKPreconditions.checkNotNull(apiCallback, (Object)"Callback is null.");
        SDKPreconditions.checkNotNull((Object)requestDescription, (Object)"RequestDescription is null.");
        this.devicesApi().listDevices(requestDescription, apiCallback);
    }

    @Override
    public HttpResult<List<IDevice>> getDevicesByProximity(UUID proximityUUID, int major, int minor) throws ClientException {
        return this.devicesApi().getDevicesByProximity(proximityUUID, major, minor, (SDKOptional<ETag>)SDKOptional.absent());
    }

    @Override
    public HttpResult<List<IDevice>> getDevicesByProximity(UUID proximityUUID, int major, int minor, SDKOptional<ETag> eTag) throws ClientException {
        return this.devicesApi().getDevicesByProximity(proximityUUID, major, minor, eTag);
    }

    @Override
    public void getDevicesByProximity(UUID proximityUUID, int major, int minor, ResultApiCallback<List<IDevice>> apiCallback) {
        SDKPreconditions.checkNotNull(apiCallback, (Object)"Callback is null.");
        this.devicesApi().getDevicesByProximity(proximityUUID, major, minor, (SDKOptional<ETag>)SDKOptional.absent(), apiCallback);
    }

    @Override
    public void getDevicesByProximity(UUID proximityUUID, int major, int minor, SDKOptional<ETag> eTag, ResultApiCallback<List<IDevice>> apiCallback) {
        SDKPreconditions.checkNotNull(apiCallback, (Object)"Callback is null.");
        this.devicesApi().getDevicesByProximity(proximityUUID, major, minor, eTag, apiCallback);
    }

    @Override
    public HttpResult<List<IManager>> listManagers() throws ClientException {
        return this.managersApi().listManagers(AbstractApiAccessor.DEFAULT_REQUEST_DESCRIPTION);
    }

    @Override
    public HttpResult<List<IManager>> listManagers(RequestDescription requestDescription) throws ClientException {
        SDKPreconditions.checkNotNull((Object)requestDescription, (Object)"request description is null.");
        return this.managersApi().listManagers(requestDescription);
    }

    @Override
    public void listManagers(ResultApiCallback<List<IManager>> apiCallback) {
        SDKPreconditions.checkNotNull(apiCallback, (Object)"Callback is null.");
        this.listManagers(AbstractApiAccessor.DEFAULT_REQUEST_DESCRIPTION, apiCallback);
    }

    @Override
    public void listManagers(RequestDescription requestDescription, ResultApiCallback<List<IManager>> apiCallback) {
        SDKPreconditions.checkNotNull((Object)requestDescription, (Object)"request description is null.");
        SDKPreconditions.checkNotNull(apiCallback, (Object)"Callback is null.");
        this.managersApi().listManagers(requestDescription, apiCallback);
    }

    @Override
    public HttpResult<List<IDevice>> listUnassignedDevicesForManager(UUID managerId) throws ClientException {
        return this.listUnassignedDevicesForManager(managerId, AbstractApiAccessor.DEFAULT_REQUEST_DESCRIPTION);
    }

    @Override
    public void listUnassignedDevicesForManager(UUID managerId, ResultApiCallback<List<IDevice>> apiCallback) {
        SDKPreconditions.checkNotNull(apiCallback, (Object)"Callback is null.");
        this.listUnassignedDevicesForManager(managerId, AbstractApiAccessor.DEFAULT_REQUEST_DESCRIPTION, apiCallback);
    }

    @Override
    public void listUnassignedDevicesForManager(UUID managerId, RequestDescription requestDescription, ResultApiCallback<List<IDevice>> apiCallback) {
        SDKPreconditions.checkNotNull((Object)managerId, (Object)"Manager id is null");
        SDKPreconditions.checkNotNull((Object)requestDescription, (Object)"request description is null");
        SDKPreconditions.checkNotNull(apiCallback, (Object)"Callback is null.");
        this.devicesApi().listUnassignedDevicesForManager(managerId, requestDescription, apiCallback);
    }

    @Override
    public HttpResult<List<IDevice>> listUnassignedDevicesForManager(UUID managerId, RequestDescription requestDescription) throws ClientException {
        SDKPreconditions.checkNotNull((Object)managerId, (Object)"Manager Id is null");
        SDKPreconditions.checkNotNull((Object)requestDescription, (Object)"Request description is null");
        return this.devicesApi().listUnassignedDevicesForManager(managerId, requestDescription);
    }

    @Override
    public void resolveIBeacon(Collection<BeaconId> beaconIds, SDKOptional<ETag> eTag, ResultApiCallback<List<IBeaconFutureId>> apiCallback) {
        SDKPreconditions.checkNotNull(beaconIds, (Object)"Provided beaconid list is null");
        SDKPreconditions.checkNotNull(apiCallback, (Object)"Callback is null");
        this.devicesApi().resolveIBeacon(beaconIds, eTag, apiCallback);
    }

    @Override
    public HttpResult<List<IBeaconFutureId>> resolveIBeacon(Collection<BeaconId> beaconIds, SDKOptional<ETag> eTagSDKOptional) throws ClientException {
        SDKPreconditions.checkNotNull(beaconIds, (Object)"Provided beaconid list is null");
        return this.devicesApi().resolveIBeacon(beaconIds, eTagSDKOptional);
    }

    @Override
    public void resolveEddystone(Collection<EddystoneUID> eddystoneUids, SDKOptional<ETag> eTag, ResultApiCallback<List<EddystoneFutureUID>> apiCallback) {
        SDKPreconditions.checkNotNull(eddystoneUids, (Object)"Provided eddystone uids list is null");
        SDKPreconditions.checkNotNull(apiCallback, (Object)"Callback is null");
        this.devicesApi().resolveEddystone(eddystoneUids, eTag, apiCallback);
    }

    @Override
    public HttpResult<List<EddystoneFutureUID>> resolveEddystone(Collection<EddystoneUID> eddystoneUids, SDKOptional<ETag> eTagSDKOptional) throws ClientException {
        SDKPreconditions.checkNotNull(eddystoneUids, (Object)"Provided eddystone uids list is null");
        return this.devicesApi().resolveEddystone(eddystoneUids, eTagSDKOptional);
    }

    @Override
    public int sendEvents(EventPacket packet) throws ClientException {
        SDKPreconditions.checkNotNull((Object)packet, (Object)"Provided event packet is null");
        return this.commonsApi().sendEvents(packet);
    }

    @Override
    public HttpResult<List<SecureCommandResponse>> getSecureCommand(Collection<String> beaconUniqueIds, SecureCommandType secureCommandType) throws ClientException {
        SDKPreconditions.checkNotNullOrEmpty(beaconUniqueIds, (String)"Beacon ids cannot be null or empty");
        SDKPreconditions.checkNotNull((Object)secureCommandType, (Object)"Command type cannot be null");
        SDKPreconditions.checkAllowedSize(beaconUniqueIds, (int)100, (String)"Beacon ids count is greater than 100");
        return this.commandApi().getSecureCommand(beaconUniqueIds, secureCommandType);
    }

    @Override
    public void getSecureCommand(Collection<String> beaconUniqueIds, SecureCommandType secureCommandType, ResultApiCallback<List<SecureCommandResponse>> apiCallback) {
        SDKPreconditions.checkNotNullOrEmpty(beaconUniqueIds, (String)"Beacon ids cannot be null or empty");
        SDKPreconditions.checkNotNull((Object)secureCommandType, (Object)"Command type cannot be null");
        SDKPreconditions.checkNotNull(apiCallback, (Object)"Callback cannot be null");
        SDKPreconditions.checkAllowedSize(beaconUniqueIds, (int)100, (String)"Beacon ids count is greater than 100");
        this.commandApi().getSecureCommand(beaconUniqueIds, secureCommandType, apiCallback);
    }
}

