package com.kontakt.sdk.android.http.interfaces;

import com.kontakt.sdk.android.common.model.INamespace;
import com.kontakt.sdk.android.common.model.IProximityUUID;
import com.kontakt.sdk.android.common.model.EventPacket;
import com.kontakt.sdk.android.common.util.SDKOptional;
import com.kontakt.sdk.android.http.ETag;
import com.kontakt.sdk.android.http.HttpResult;
import com.kontakt.sdk.android.http.exception.ClientException;

import java.util.List;
import java.util.UUID;

/**
 * The interface Common api accessor.
 */
public interface CommonApiAccessor extends ApiAccessor {

    /**
     * List proximities.
     *
     * @return the http result
     * @throws ClientException the client exception
     */
    HttpResult<List<IProximityUUID>> listProximities() throws ClientException;

    /**
     * List proximities.
     *
     * @param etag the etag
     * @return the http result
     * @throws ClientException the client exception
     */
    HttpResult<List<IProximityUUID>> listProximities(SDKOptional<ETag> etag) throws ClientException;

    /**
     * List proximities.
     *
     * @param apiCallback the api callback
     */
    void listProximities(ResultApiCallback<List<IProximityUUID>> apiCallback);

    /**
     * List proximities.
     *
     * @param etag        the etag
     * @param apiCallback the api callback
     */
    void listProximities(SDKOptional<ETag> etag, ResultApiCallback<List<IProximityUUID>> apiCallback);

    /**
     * Resolves proximities to secure proximities.
     *
     * @param proximities to resolve
     * @return resolved proximities
     * @throws ClientException
     */
    HttpResult<List<IProximityUUID>> resolveProximities(List<UUID> proximities) throws ClientException;

    /**
     * Resolves proximities to secure proximities.
     *
     * @param proximities to resolve
     * @param etag        the etag
     * @return resolved proximities
     * @throws ClientException
     */
    HttpResult<List<IProximityUUID>> resolveProximities(List<UUID> proximities, SDKOptional<ETag> etag) throws ClientException;

    /**
     * Resolves proximities to secure proximities.
     *
     * @param proximities to resolve
     * @param apiCallback the api callback
     */
    void resolveProximities(List<UUID> proximities, ResultApiCallback<List<IProximityUUID>> apiCallback);

    /**
     * Resolves proximities to secure proximities
     *
     * @param proximities to resolve
     * @param etag        the etag
     * @param apiCallback the api callback
     */
    void resolveProximities(List<UUID> proximities, SDKOptional<ETag> etag, ResultApiCallback<List<IProximityUUID>> apiCallback);

    /**
     * List namespaces.
     *
     * @return the http result
     * @throws ClientException the client exception
     */
    HttpResult<List<INamespace>> listNamespaces() throws ClientException;

    /**
     * List namespaces.
     *
     * @param etag the etag
     * @return the http result
     * @throws ClientException the client exception
     */
    HttpResult<List<INamespace>> listNamespaces(SDKOptional<ETag> etag) throws ClientException;

    /**
     * List namespaces.
     *
     * @param apiCallback the api callback
     */
    void listNamespaces(ResultApiCallback<List<INamespace>> apiCallback);

    /**
     * List namespaces.
     *
     * @param etag        the etag
     * @param apiCallback the api callback
     */
    void listNamespaces(SDKOptional<ETag> etag, ResultApiCallback<List<INamespace>> apiCallback);

    /**
     * Resolves namespaces to secure namespaces.
     *
     * @param namespaces to resolve
     * @return resolved namespaces
     * @throws ClientException
     */
    HttpResult<List<INamespace>> resolveNamespaces(List<String> namespaces) throws ClientException;

    /**
     * Resolves namespaces to secure namespaces.
     *
     * @param namespaces to resolve
     * @param etag       the etag
     * @return resolved namespaces
     * @throws ClientException
     */
    HttpResult<List<INamespace>> resolveNamespaces(List<String> namespaces, SDKOptional<ETag> etag) throws ClientException;

    /**
     * Resolves namespaces to secure namespaces.
     *
     * @param namespaces  to resolve
     * @param apiCallback the api callback
     */
    void resolveNamespaces(List<String> namespaces, ResultApiCallback<List<INamespace>> apiCallback);

    /**
     * Resolves namespaces to secure namespaces
     *
     * @param namespaces  to resolve
     * @param etag        the etag
     * @param apiCallback the api callback
     */
    void resolveNamespaces(List<String> namespaces, SDKOptional<ETag> etag, ResultApiCallback<List<INamespace>> apiCallback);

    /**
     * Sends collected events in packet
     *
     * @param packet event packet
     * @return http response status
     * @throws ClientException
     */
    int sendEvents(EventPacket packet) throws ClientException;
}
