package com.kontakt.sdk.android.http.exception;

/**
 * Thrown by REST Client if desired interaction fails.
 */
public class ClientException extends Exception {

    private final int httpStatus;

    /**
     * Instantiates a new Client exception.
     *
     * @param detailMessage the detail message
     */
    public ClientException(String detailMessage) {
        super(detailMessage);
        httpStatus = -1;
    }

    /**
     * Instantiates a new Client exception.
     *
     * @param throwable the throwable
     */
    public ClientException(Throwable throwable) {
        this(-1, throwable);
    }

    public ClientException(final int httpStatus, final Throwable throwable) {
        super(throwable);
        this.httpStatus = httpStatus;
    }

    public int getHttpStatus() {
        return httpStatus;
    }
}
