package com.kontakt.sdk.android.http;

import com.kontakt.sdk.android.common.model.SecureSingleConfig;
import com.kontakt.sdk.android.common.util.HttpUtils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

class ObjectRequestDescriptionHelper {

    static RequestDescription.Descriptor prepareParameters(Collection<SecureSingleConfig> configApplies) {
        RequestDescription.Descriptor descriptor = RequestDescription.start();
        List<String> uniqueIds = new ArrayList<String>();
        List<String> responses = new ArrayList<String>();
        List<String> updated = new ArrayList<String>();

        for (SecureSingleConfig apply : configApplies) {
            uniqueIds.add(apply.getUniqueId().trim());
            responses.add(apply.getSecureMessage().trim());
            updated.add(String.valueOf(apply.getUnixTimestamp()));

        }

        descriptor.addParameters(HttpUtils.toUrlParameterList("uniqueId", uniqueIds));
        descriptor.addParameters(HttpUtils.toUrlParameterList("response", responses));
        descriptor.addParameters(HttpUtils.toUrlParameterList("updated", updated));

        return descriptor;
    }
}
