package com.kontakt.sdk.android.http;

import com.kontakt.sdk.android.common.util.HashCodeBuilder;
import com.kontakt.sdk.android.common.util.SDKEqualsBuilder;

/**
 * ETag is introduced to provide web cache validation and to allow to make
 * conditional requests. Its primal aim is to enable more efficient collaboration with REST API
 * as a web server does not need to send a full response if the content has not changed.
 */
public final class ETag {

    /**
     * The constant HEADER_NAME_RESPONSE.
     */
    public static final String HEADER_NAME_RESPONSE = "ETag";

    /**
     * The constant HEADER_NAME_REQUEST.
     */
    public static final String HEADER_NAME_REQUEST = "If-None-Match";

    private final String value;

    private final int hashCode;

    /**
     * Creates new ETag instance.
     *
     * @param value the value
     * @return the e tag
     */
    public static ETag of(final String value) {
        return new ETag(value);
    }

    private ETag(String value) {
        this.value = value;
        this.hashCode = HashCodeBuilder.init().append(value).build();
    }

    /**
     * Gets request name.
     *
     * @return the request name
     */
    public String getRequestName() {
        return HEADER_NAME_REQUEST;
    }

    /**
     * Gets response name.
     *
     * @return the response name
     */
    public String getResponseName() {
        return HEADER_NAME_RESPONSE;
    }

    /**
     * Gets ETag value.
     *
     * @return the value
     */
    public String getValue() {
        return value;
    }

    @Override
    public int hashCode() {
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }

        if (obj == null || !(obj instanceof ETag)) {
            return false;
        }

        final ETag eTag = (ETag) obj;

        return SDKEqualsBuilder.start().equals(value, eTag.value).result();
    }

    @Override
    public String toString() {
        return String.format("ETag: %s", value);
    }
}
