/*
 * Decompiled with CFR 0.152.
 */
package kong.unirest.java;

import kong.unirest.java.Upstream;

class Prefetcher {
    public static final int PREFETCH = 16;
    public static final int PREFETCH_THRESHOLD = 8;
    private final int prefetch;
    private final int prefetchThreshold;
    private volatile int upstreamWindow;

    public Prefetcher() {
        this.prefetch = 16;
        this.prefetchThreshold = 8;
    }

    public void initialize(Upstream upstream) {
        this.upstreamWindow = this.prefetch;
        upstream.request(this.prefetch);
    }

    public void update(Upstream upstream) {
        int update = this.upstreamWindow - 1;
        if (update <= this.prefetchThreshold) {
            this.upstreamWindow = this.prefetch;
            upstream.request(this.prefetch - update);
        } else {
            this.upstreamWindow = update;
        }
    }

    int currentWindow() {
        return this.upstreamWindow;
    }
}

