/*
 * Decompiled with CFR 0.152.
 */
package kong.unirest;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import kong.unirest.Header;
import kong.unirest.Util;

public class Headers {
    private static final long serialVersionUID = 71310341388734766L;
    private List<Header> headers = new ArrayList<Header>();

    public Headers() {
    }

    public Headers(Collection<Entry> entries) {
        entries.forEach(e -> this.add(((Entry)e).name, ((Entry)e).value));
    }

    public void add(String name, String value) {
        this.add(name, () -> value);
    }

    public void add(String name, Supplier<String> value) {
        if (Objects.nonNull(name)) {
            this.headers.add(new Entry(name, value));
        }
    }

    public void replace(String name, String value) {
        this.remove(name);
        this.add(name, value);
    }

    private void remove(String name) {
        this.headers.removeIf(h -> this.isName((Header)h, name));
    }

    public int size() {
        return this.headers.stream().map(Header::getName).collect(Collectors.toSet()).size();
    }

    public List<String> get(String name) {
        return this.headers.stream().filter(h -> this.isName((Header)h, name)).map(Header::getValue).collect(Collectors.toList());
    }

    public void putAll(Headers header) {
        this.headers.addAll(header.headers);
    }

    public boolean containsKey(String name) {
        return this.headers.stream().anyMatch(h -> this.isName((Header)h, name));
    }

    public void clear() {
        this.headers.clear();
    }

    public String getFirst(String key) {
        return this.headers.stream().filter(h -> this.isName((Header)h, key)).findFirst().map(Header::getValue).orElse("");
    }

    public List<Header> all() {
        return new ArrayList<Header>(this.headers);
    }

    private boolean isName(Header h, String name) {
        return Util.nullToEmpty(name).equalsIgnoreCase(h.getName());
    }

    void remove(String key, String value) {
        List header = this.headers.stream().filter(h -> key.equalsIgnoreCase(h.getName()) && value.equalsIgnoreCase(h.getValue())).collect(Collectors.toList());
        this.headers.removeAll(header);
    }

    static class Entry
    implements Header {
        private final String name;
        private final Supplier<String> value;

        public Entry(String name, String value) {
            this.name = name;
            this.value = () -> value;
        }

        public Entry(String name, Supplier<String> value) {
            this.name = name;
            this.value = value;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getValue() {
            return this.value.get();
        }
    }
}

