/*
 * Decompiled with CFR 0.152.
 */
package kong.unirest;

import java.io.File;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import kong.unirest.BaseRequest;
import kong.unirest.Body;
import kong.unirest.Config;
import kong.unirest.ContentType;
import kong.unirest.HttpMethod;
import kong.unirest.HttpRequestMultiPart;
import kong.unirest.HttpRequestUniBody;
import kong.unirest.HttpRequestWithBody;
import kong.unirest.JsonNode;
import kong.unirest.MultipartBody;
import kong.unirest.RequestBodyEntity;
import org.json.JSONArray;
import org.json.JSONObject;

class HttpRequestBody
extends BaseRequest<HttpRequestWithBody>
implements HttpRequestWithBody {
    private Charset charSet = StandardCharsets.UTF_8;

    public HttpRequestBody(Config config, HttpMethod method, String url) {
        super(config, method, url);
    }

    @Override
    public MultipartBody field(String name, Collection<?> value) {
        return new HttpRequestMultiPart(this).field(name, value);
    }

    @Override
    public MultipartBody field(String name, File file) {
        return this.field(name, file, null);
    }

    @Override
    public MultipartBody field(String name, File file, String contentType) {
        return new HttpRequestMultiPart(this).field(name, file, contentType);
    }

    @Override
    public MultipartBody field(String name, Object value) {
        return this.field(name, value, null);
    }

    @Override
    public MultipartBody field(String name, Object value, String contentType) {
        return new HttpRequestMultiPart(this).field(name, value, contentType);
    }

    @Override
    public MultipartBody fields(Map<String, Object> parameters) {
        return new HttpRequestMultiPart(this).fields(parameters);
    }

    @Override
    public MultipartBody field(String name, InputStream stream, ContentType contentType, String fileName) {
        return new HttpRequestMultiPart(this).field(name, stream, contentType, fileName);
    }

    @Override
    public MultipartBody multiPartContent() {
        return new HttpRequestMultiPart(this).forceMultiPart(true);
    }

    @Override
    public MultipartBody field(String name, InputStream stream, String fileName) {
        return this.field(name, stream, ContentType.APPLICATION_OCTET_STREAM, fileName);
    }

    @Override
    public HttpRequestBody charset(Charset charset) {
        this.charSet = charset;
        return this;
    }

    @Override
    public RequestBodyEntity body(JsonNode body) {
        return this.body(body.toString());
    }

    @Override
    public RequestBodyEntity body(String body) {
        return new HttpRequestUniBody(this).body(body);
    }

    @Override
    public RequestBodyEntity body(Object body) {
        return this.body(this.getObjectMapper().writeValue(body));
    }

    @Override
    public RequestBodyEntity body(byte[] body) {
        return new HttpRequestUniBody(this).body(body);
    }

    @Override
    public RequestBodyEntity body(JSONObject body) {
        return this.body(body.toString());
    }

    @Override
    public RequestBodyEntity body(JSONArray body) {
        return this.body(body.toString());
    }

    @Override
    public Charset getCharset() {
        return this.charSet;
    }

    void setCharset(Charset charset) {
        this.charSet = charset;
    }

    @Override
    public Optional<Body> getBody() {
        return Optional.empty();
    }
}

