/*
 * Decompiled with CFR 0.152.
 */
package kong.unirest;

import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import kong.unirest.Config;
import kong.unirest.Headers;
import kong.unirest.HttpResponse;
import kong.unirest.MappedResponse;
import kong.unirest.RawResponse;
import kong.unirest.SimpleResponse;
import kong.unirest.UnirestParsingException;

abstract class BaseResponse<T>
implements HttpResponse<T> {
    private final Headers headers;
    private final String statusText;
    private final int statusCode;
    private Optional<UnirestParsingException> parsingerror = Optional.empty();
    private final Config config;

    protected BaseResponse(RawResponse response) {
        this.headers = response.getHeaders();
        this.statusCode = response.getStatus();
        this.statusText = response.getStatusText();
        this.config = response.getConfig();
    }

    protected BaseResponse(BaseResponse other) {
        this.headers = other.headers;
        this.statusCode = other.statusCode;
        this.statusText = other.statusText;
        this.config = other.config;
    }

    @Override
    public int getStatus() {
        return this.statusCode;
    }

    @Override
    public String getStatusText() {
        return this.statusText;
    }

    @Override
    public Headers getHeaders() {
        return this.headers;
    }

    @Override
    public abstract T getBody();

    @Override
    public Optional<UnirestParsingException> getParsingError() {
        return this.parsingerror;
    }

    @Override
    public <V> V mapBody(Function<T, V> func) {
        return func.apply(this.getBody());
    }

    @Override
    public <V> HttpResponse<V> map(Function<T, V> func) {
        return new MappedResponse<V>(this, this.mapBody(func));
    }

    protected void setParsingException(String originalBody, RuntimeException e) {
        this.parsingerror = Optional.of(new UnirestParsingException(originalBody, e));
    }

    @Override
    public boolean isSuccess() {
        return this.getStatus() >= 200 && this.getStatus() < 300 && !this.getParsingError().isPresent();
    }

    @Override
    public HttpResponse<T> ifSuccess(Consumer<HttpResponse<T>> consumer) {
        if (this.isSuccess()) {
            consumer.accept(this);
        }
        return this;
    }

    @Override
    public HttpResponse<T> ifFailure(Consumer<HttpResponse<T>> consumer) {
        if (!this.isSuccess()) {
            consumer.accept(this);
        }
        return this;
    }

    @Override
    public <E> E mapError(Class<? extends E> errorClass) {
        if (!this.isSuccess()) {
            try {
                return this.config.getObjectMapper().readValue(this.getParsingError().get().getOriginalBody(), errorClass);
            }
            catch (RuntimeException e) {
                this.setParsingException(this.getParsingError().get().getOriginalBody(), e);
            }
        }
        return null;
    }

    @Override
    public <E> HttpResponse<T> ifFailure(Class<? extends E> errorClass, Consumer<HttpResponse<E>> consumer) {
        if (!this.isSuccess()) {
            E error = this.mapError(errorClass);
            consumer.accept(new SimpleResponse<E>(error, this));
        }
        return this;
    }
}

