/*
 * Decompiled with CFR 0.152.
 */
package kong.unirest;

import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import kong.unirest.Headers;
import kong.unirest.HttpResponse;
import kong.unirest.RawResponse;
import kong.unirest.UnirestParsingException;

abstract class BaseResponse<T>
implements HttpResponse<T> {
    private final Headers headers;
    private final String statusText;
    private final int statusCode;
    private Optional<UnirestParsingException> parsingerror = Optional.empty();

    protected BaseResponse(RawResponse response) {
        this.headers = response.getHeaders();
        this.statusCode = response.getStatus();
        this.statusText = response.getStatusText();
    }

    @Override
    public int getStatus() {
        return this.statusCode;
    }

    @Override
    public String getStatusText() {
        return this.statusText;
    }

    @Override
    public Headers getHeaders() {
        return this.headers;
    }

    @Override
    public abstract T getBody();

    @Override
    public Optional<UnirestParsingException> getParsingError() {
        return this.parsingerror;
    }

    @Override
    public <V> V mapBody(Function<T, V> func) {
        return func.apply(this.getBody());
    }

    protected void setParsingException(String originalBody, RuntimeException e) {
        this.parsingerror = Optional.of(new UnirestParsingException(originalBody, e));
    }

    @Override
    public HttpResponse<T> ifSuccess(Consumer<HttpResponse<T>> consumer) {
        if (this.isSuccess()) {
            consumer.accept(this);
        }
        return this;
    }

    @Override
    public HttpResponse<T> ifFailure(Consumer<HttpResponse<T>> consumer) {
        if (!this.isSuccess()) {
            consumer.accept(this);
        }
        return this;
    }

    @Override
    public boolean isSuccess() {
        return this.getStatus() >= 200 && this.getStatus() < 300 && !this.getParsingError().isPresent();
    }
}

