/*
 * Decompiled with CFR 0.152.
 */
package kong.unirest.apache;

import java.io.Closeable;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Stream;
import kong.unirest.Client;
import kong.unirest.Config;
import kong.unirest.HttpRequest;
import kong.unirest.HttpResponse;
import kong.unirest.RawResponse;
import kong.unirest.UnirestException;
import kong.unirest.apache.ApacheResponse;
import kong.unirest.apache.BaseApacheClient;
import kong.unirest.apache.RequestPrep;
import kong.unirest.apache.SyncIdleConnectionMonitorThread;
import kong.unirest.apache.Util;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;

public class ApacheClient
extends BaseApacheClient
implements Client {
    private final HttpClient client;
    private final Config config;
    private final PoolingHttpClientConnectionManager manager;
    private final SyncIdleConnectionMonitorThread syncMonitor;

    public ApacheClient(Config config) {
        this.config = config;
        this.manager = new PoolingHttpClientConnectionManager();
        this.syncMonitor = new SyncIdleConnectionMonitorThread((HttpClientConnectionManager)this.manager);
        this.syncMonitor.start();
        HttpClientBuilder cb = HttpClientBuilder.create().setDefaultRequestConfig(this.getRequestConfig(config)).setDefaultCredentialsProvider(this.toApacheCreds(config.getProxy())).setConnectionManager((HttpClientConnectionManager)this.manager).useSystemProperties();
        if (!config.isRequestCompressionOn()) {
            cb.disableContentCompression();
        }
        if (config.useSystemProperties()) {
            cb.useSystemProperties();
        }
        if (!config.getFollowRedirects()) {
            cb.disableRedirectHandling();
        }
        if (!config.getEnabledCookieManagement()) {
            cb.disableCookieManagement();
        }
        config.getInterceptors().stream().forEach(arg_0 -> ((HttpClientBuilder)cb).addInterceptorFirst(arg_0));
        this.client = cb.build();
    }

    public ApacheClient(HttpClient httpClient, Config config, PoolingHttpClientConnectionManager clientManager, SyncIdleConnectionMonitorThread connMonitor) {
        this.client = httpClient;
        this.config = config;
        this.manager = clientManager;
        this.syncMonitor = connMonitor;
    }

    @Override
    public <T> HttpResponse<T> request(HttpRequest request, Function<RawResponse, HttpResponse<T>> transformer) {
        HttpRequestBase requestObj = new RequestPrep(request, this.config, false).prepare();
        try {
            org.apache.http.HttpResponse execute = this.client.execute((HttpUriRequest)requestObj);
            HttpResponse<T> httpResponse = transformer.apply(new ApacheResponse(execute, this.config));
            requestObj.releaseConnection();
            HttpResponse<T> httpResponse2 = httpResponse;
            return httpResponse2;
        }
        catch (Exception e) {
            throw new UnirestException(e);
        }
        finally {
            requestObj.releaseConnection();
        }
    }

    public HttpClient getClient() {
        return this.client;
    }

    public PoolingHttpClientConnectionManager getManager() {
        return this.manager;
    }

    public SyncIdleConnectionMonitorThread getSyncMonitor() {
        return this.syncMonitor;
    }

    @Override
    public Stream<Exception> close() {
        return Util.collectExceptions(Util.tryCast(this.client, CloseableHttpClient.class).map(c -> Util.tryDo(c, Closeable::close)).filter(Optional::isPresent).map(Optional::get), Util.tryDo(this.manager, m -> m.close()), Util.tryDo(this.syncMonitor, i -> i.interrupt()));
    }
}

