/*
 * Decompiled with CFR 0.152.
 */
package kong.unirest.apache;

import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import kong.unirest.Body;
import kong.unirest.BodyPart;
import kong.unirest.HttpRequest;
import org.apache.http.HttpEntity;
import org.apache.http.NameValuePair;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.entity.BasicHttpEntity;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.ByteArrayBody;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.entity.mime.content.InputStreamBody;
import org.apache.http.entity.mime.content.StringBody;
import org.apache.http.message.BasicNameValuePair;

class ApacheBodyMapper {
    private final HttpRequest request;

    ApacheBodyMapper(HttpRequest request) {
        this.request = request;
    }

    HttpEntity apply() {
        Optional<Body> body = this.request.getBody();
        return body.map(this::applyBody).orElseGet(BasicHttpEntity::new);
    }

    private HttpEntity applyBody(Body o) {
        if (o.isMultiPart()) {
            return this.mapToMultipart(o);
        }
        return this.mapToUniBody(o);
    }

    private HttpEntity mapToUniBody(Body b) {
        BodyPart bodyPart = b.uniPart();
        if (String.class.isAssignableFrom(bodyPart.getPartType())) {
            return new StringEntity((String)bodyPart.getValue(), b.getCharset());
        }
        return new ByteArrayEntity((byte[])bodyPart.getValue());
    }

    private HttpEntity mapToMultipart(Body body) {
        if (body.multiParts().stream().anyMatch(BodyPart::isFile)) {
            MultipartEntityBuilder builder = MultipartEntityBuilder.create();
            builder.setCharset(body.getCharset());
            builder.setMode(HttpMultipartMode.valueOf((String)body.getMode().name()));
            for (BodyPart key : body.multiParts()) {
                builder.addPart(key.getName(), this.apply(key));
            }
            return builder.build();
        }
        return new UrlEncodedFormEntity(ApacheBodyMapper.getList(body.multiParts()), body.getCharset());
    }

    private ContentBody apply(BodyPart value) {
        if (this.is(value, File.class)) {
            File file = (File)value.getValue();
            return new FileBody(file, this.toApacheType(value.getContentType()));
        }
        if (this.is(value, InputStream.class)) {
            InputStream part = (InputStream)value.getValue();
            return new InputStreamBody(part, this.toApacheType(value.getContentType()), value.getFileName());
        }
        if (this.is(value, byte[].class)) {
            byte[] part = (byte[])value.getValue();
            return new ByteArrayBody(part, this.toApacheType(value.getContentType()), value.getFileName());
        }
        return new StringBody(String.valueOf(value.getValue()), this.toApacheType(value.getContentType()));
    }

    private boolean is(BodyPart value, Class<?> cls) {
        return cls.isAssignableFrom(value.getPartType());
    }

    private ContentType toApacheType(String type) {
        return ContentType.parse((String)type);
    }

    static List<NameValuePair> getList(Collection<BodyPart> parameters) {
        ArrayList<NameValuePair> result = new ArrayList<NameValuePair>();
        for (BodyPart entry : parameters) {
            result.add((NameValuePair)new BasicNameValuePair(entry.getName(), entry.getValue().toString()));
        }
        return result;
    }
}

