/*
 * Decompiled with CFR 0.152.
 */
package kong.unirest.apache;

import kong.unirest.Config;
import kong.unirest.Proxy;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.impl.client.BasicCredentialsProvider;

abstract class BaseApacheClient {
    BaseApacheClient() {
    }

    protected RequestConfig getRequestConfig(Config config) {
        Integer connectionTimeout = config.getConnectionTimeout();
        Integer socketTimeout = config.getSocketTimeout();
        HttpHost proxy = this.toApacheProxy(config.getProxy());
        return RequestConfig.custom().setConnectTimeout(connectionTimeout.intValue()).setSocketTimeout(socketTimeout.intValue()).setConnectionRequestTimeout(socketTimeout.intValue()).setProxy(proxy).build();
    }

    private HttpHost toApacheProxy(Proxy proxy) {
        if (proxy == null) {
            return null;
        }
        return new HttpHost(proxy.getHost(), proxy.getPort().intValue());
    }

    protected CredentialsProvider toApacheCreds(Proxy proxy) {
        if (proxy != null && proxy.isAuthenticated()) {
            BasicCredentialsProvider proxyCreds = new BasicCredentialsProvider();
            proxyCreds.setCredentials(new AuthScope(proxy.getHost(), proxy.getPort().intValue()), (Credentials)new UsernamePasswordCredentials(proxy.getUsername(), proxy.getPassword()));
            return proxyCreds;
        }
        return null;
    }
}

