/*
 * Decompiled with CFR 0.152.
 */
package kong.unirest.core;

import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Stream;
import kong.unirest.core.Config;
import kong.unirest.core.Cookie;
import kong.unirest.core.Headers;
import kong.unirest.core.Path;
import kong.unirest.core.SseHandler;
import kong.unirest.core.SseRequest;
import kong.unirest.core.java.Event;

public class SseRequestImpl
implements SseRequest {
    private final Config config;
    private final Path url;
    protected Headers headers = new Headers();

    public SseRequestImpl(Config config, String url) {
        Objects.requireNonNull(config, "Config cannot be null");
        Objects.requireNonNull(url, "URL cannot be null");
        this.config = config;
        this.url = new Path(url, config.getDefaultBaseUrl());
        this.headers.putAll(config.getDefaultHeaders());
    }

    @Override
    public SseRequest routeParam(String name, String value) {
        this.url.param(name, value);
        return this;
    }

    @Override
    public SseRequest routeParam(Map<String, Object> params) {
        this.url.param(params);
        return this;
    }

    @Override
    public SseRequest basicAuth(String username, String password) {
        this.headers.setBasicAuth(username, password);
        return this;
    }

    @Override
    public SseRequest accept(String value) {
        this.headers.accepts(value);
        return this;
    }

    @Override
    public SseRequest header(String name, String value) {
        this.headers.add(name, value);
        return this;
    }

    @Override
    public SseRequest headerReplace(String name, String value) {
        this.headers.replace(name, value);
        return this;
    }

    @Override
    public SseRequest headers(Map<String, String> headerMap) {
        this.headers.add(headerMap);
        return this;
    }

    @Override
    public SseRequest cookie(String name, String value) {
        this.headers.cookie(new Cookie(name, value));
        return this;
    }

    @Override
    public SseRequest cookie(Cookie cookie) {
        this.headers.cookie(cookie);
        return this;
    }

    @Override
    public SseRequest cookie(Collection<Cookie> cookies) {
        this.headers.cookie(cookies);
        return this;
    }

    @Override
    public SseRequest queryString(String name, Object value) {
        this.url.queryString(name, value);
        return this;
    }

    @Override
    public SseRequest queryString(String name, Collection<?> value) {
        this.url.queryString(name, value);
        return this;
    }

    @Override
    public SseRequest queryString(Map<String, Object> parameters) {
        this.url.queryString(parameters);
        return this;
    }

    @Override
    public SseRequest lastEventId(String id) {
        return this.header("Last-Event-ID", id);
    }

    @Override
    public CompletableFuture<Void> connect(SseHandler handler) {
        return this.config.getClient().sse(this, handler);
    }

    @Override
    public Stream<Event> connect() {
        return this.config.getClient().sse(this);
    }

    @Override
    public Headers getHeaders() {
        return this.headers;
    }

    @Override
    public String getUrl() {
        return this.url.toString();
    }
}

