/*
 * Decompiled with CFR 0.152.
 */
package kong.unirest.core.java;

import java.util.Objects;
import kong.unirest.core.Config;
import kong.unirest.core.GenericType;

public class Event {
    private final Config config;
    private final String id;
    private final String data;
    private final String event;

    public Event(String id, String event, String data, Config config) {
        this.config = config;
        this.id = id;
        this.event = event;
        this.data = data;
    }

    public Event(String id, String event, String data) {
        this(id, event, data, null);
    }

    public String data() {
        return this.data;
    }

    public String id() {
        return this.id;
    }

    public String event() {
        return this.event;
    }

    public <T> T asObject(Class<? extends T> responseClass) {
        return this.config.getObjectMapper().readValue(this.data, responseClass);
    }

    public <T> T asObject(GenericType<T> genericType) {
        return this.config.getObjectMapper().readValue(this.data, genericType);
    }

    public boolean equals(Object o) {
        if (!(o instanceof Event)) {
            return false;
        }
        Event event = (Event)o;
        return Objects.equals(this.id, event.id) && Objects.equals(this.data, event.data) && Objects.equals(this.event, event.event);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.data, this.event);
    }

    public String toString() {
        return "SseEvent{data=" + this.data + ", field=" + this.event + ", id=" + this.id + "}";
    }
}

