/*
 * Decompiled with CFR 0.152.
 */
package kong.unirest.core.java;

import java.net.http.HttpResponse;
import java.util.Iterator;
import java.util.Spliterators;
import java.util.function.Consumer;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import kong.unirest.core.Config;
import kong.unirest.core.SseHandler;
import kong.unirest.core.java.Event;

class SseResponseHandler
implements Consumer<HttpResponse<Stream<String>>> {
    private final Config config;
    private final SseHandler listener;
    private EventBuffer databuffer = new EventBuffer();

    public SseResponseHandler(Config config, SseHandler listener) {
        this.config = config;
        this.listener = listener;
    }

    @Override
    public void accept(HttpResponse<Stream<String>> response) {
        response.body().forEach(this::accept);
    }

    @Override
    private void accept(String line) {
        this.accept(line, this.listener);
    }

    private void accept(String line, SseHandler handler) {
        ParsedLine pl = this.parse(line);
        if (pl.isDispatch() && this.databuffer.buffer.length() > 0) {
            handler.onEvent(this.databuffer.toEvent());
            this.databuffer = new EventBuffer();
        } else if (pl.isComment()) {
            handler.onComment(pl.value());
        } else if (pl.isData()) {
            this.databuffer.buffer.append(pl.value()).append("\n");
        } else if (pl.isEvent()) {
            this.databuffer.type = pl.value();
        } else if (pl.isId()) {
            this.databuffer.id = pl.value();
        } else if (pl.isRetry()) {
            // empty if block
        }
    }

    private ParsedLine parse(String line) {
        if (line == null || line.isBlank()) {
            return new ParsedLine();
        }
        if (line.startsWith(":")) {
            return new ParsedLine(line.substring(1));
        }
        if (!line.contains(":")) {
            return new ParsedLine(line, "");
        }
        String[] spl = line.split(":", 2);
        return new ParsedLine(spl[0].trim(), spl[1]);
    }

    public Stream<Event> map(Stream<String> stream) {
        final Iterator it = stream.iterator();
        return StreamSupport.stream(new Spliterators.AbstractSpliterator<Event>(Long.MAX_VALUE, 0){

            @Override
            public boolean tryAdvance(Consumer<? super Event> action) {
                while (it.hasNext()) {
                    SseResponseHandler.this.accept((String)it.next(), action::accept);
                }
                return false;
            }
        }, false);
    }

    private class EventBuffer {
        String id = "";
        String type = "";
        StringBuffer buffer = new StringBuffer();

        private EventBuffer() {
        }

        public Event toEvent() {
            return new Event(this.id, this.type, this.getValue(), SseResponseHandler.this.config);
        }

        private String getValue() {
            String string = this.buffer.toString();
            if (string.endsWith("\n")) {
                return string.substring(0, string.length() - 1);
            }
            return string;
        }
    }

    private class ParsedLine {
        private final String value;
        private final String field;

        public ParsedLine(String value) {
            this(null, value);
        }

        public ParsedLine() {
            this(null, null);
        }

        public ParsedLine(String field, String value) {
            this.field = field;
            this.value = value == null ? null : (value.startsWith(" ") ? value.substring(1) : value);
        }

        public boolean isDispatch() {
            return this.field == null && this.value == null;
        }

        public boolean isComment() {
            return this.field == null;
        }

        public String value() {
            return this.value;
        }

        public String name() {
            return this.field;
        }

        public boolean isData() {
            return this.field != null && this.field.equalsIgnoreCase("data");
        }

        public boolean isEvent() {
            return this.field != null && this.field.equalsIgnoreCase("event");
        }

        public boolean isId() {
            return this.field != null && this.field.equalsIgnoreCase("id") && this.value != null;
        }

        public boolean isRetry() {
            return this.value == null && this.field != null && this.field.matches("^\\d+$");
        }
    }
}

