/*
 * Decompiled with CFR 0.152.
 */
package kong.unirest.core;

import java.time.Instant;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import kong.unirest.core.HttpResponse;
import kong.unirest.core.UnirestException;
import kong.unirest.core.Util;

public interface RetryStrategy {
    public boolean isRetryable(HttpResponse<?> var1);

    public long getWaitTime(HttpResponse<?> var1);

    public int getMaxAttempts();

    default public void waitFor(long millies) {
        try {
            TimeUnit.MILLISECONDS.sleep(millies);
        }
        catch (InterruptedException e) {
            throw new UnirestException(e);
        }
    }

    public static class Standard
    implements RetryStrategy {
        private static final Set<Integer> RETRY_CODES = Set.of(Integer.valueOf(301), Integer.valueOf(429), Integer.valueOf(503), Integer.valueOf(529));
        private static final String RETRY_AFTER = "Retry-After";
        private final int maxAttempts;

        public Standard(int maxAttempts) {
            this.maxAttempts = maxAttempts;
        }

        public boolean isRetryable(HttpResponse response) {
            return RETRY_CODES.contains(response.getStatus()) && response.getHeaders().containsKey(RETRY_AFTER);
        }

        public long getWaitTime(HttpResponse response) {
            String value = response.getHeaders().getFirst(RETRY_AFTER);
            return this.parseToMillies(value);
        }

        protected Long parseToMillies(String value) {
            return Standard.trySeconds(value).orElseGet(() -> Standard.tryAsDateTime(value));
        }

        @Override
        public int getMaxAttempts() {
            return this.maxAttempts;
        }

        private static Long tryAsDateTime(String value) {
            ZonedDateTime zdt = Util.tryParseToDate(value);
            if (zdt == null) {
                return 0L;
            }
            Instant now = Util.now();
            return ChronoUnit.MILLIS.between(now, zdt.toInstant());
        }

        private static Optional<Long> trySeconds(String s) {
            try {
                long seconds = Standard.parse(s);
                return Optional.of(seconds);
            }
            catch (NumberFormatException e) {
                return Optional.empty();
            }
        }

        private static long parse(String s) {
            if (s.contains(".")) {
                double d = Double.parseDouble(s);
                return Math.round(d * 1000.0);
            }
            return Long.parseLong(s) * 1000L;
        }
    }
}

