/*
 * Decompiled with CFR 0.152.
 */
package org.newsclub.net.unix.vsock;

import com.kohlschutter.annotations.compiletime.SuppressFBWarnings;
import java.io.IOException;
import java.net.ProtocolFamily;
import java.net.SocketAddress;
import org.eclipse.jdt.annotation.NonNull;
import org.newsclub.net.unix.AFAddressFamily;
import org.newsclub.net.unix.AFAddressFamilyConfig;
import org.newsclub.net.unix.AFDatagramChannel;
import org.newsclub.net.unix.AFDatagramSocket;
import org.newsclub.net.unix.AFSelectorProvider;
import org.newsclub.net.unix.AFServerSocket;
import org.newsclub.net.unix.AFServerSocketChannel;
import org.newsclub.net.unix.AFSocket;
import org.newsclub.net.unix.AFSocketChannel;
import org.newsclub.net.unix.AFSocketPair;
import org.newsclub.net.unix.AFSomeSocket;
import org.newsclub.net.unix.AFVSOCKSocketAddress;
import org.newsclub.net.unix.vsock.AFVSOCKDatagramChannel;
import org.newsclub.net.unix.vsock.AFVSOCKDatagramSocket;
import org.newsclub.net.unix.vsock.AFVSOCKProtocolFamily;
import org.newsclub.net.unix.vsock.AFVSOCKServerSocket;
import org.newsclub.net.unix.vsock.AFVSOCKServerSocketChannel;
import org.newsclub.net.unix.vsock.AFVSOCKSocket;
import org.newsclub.net.unix.vsock.AFVSOCKSocketChannel;
import org.newsclub.net.unix.vsock.AFVSOCKSocketPair;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public final class AFVSOCKSelectorProvider
extends AFSelectorProvider<AFVSOCKSocketAddress> {
    private static final AFVSOCKSelectorProvider INSTANCE = new AFVSOCKSelectorProvider();
    static final AFAddressFamily<@NonNull AFVSOCKSocketAddress> AF_VSOCK = AFAddressFamily.registerAddressFamilyImpl((String)"vsock", (AFAddressFamily)AFVSOCKSocketAddress.addressFamily(), (AFAddressFamilyConfig)new AFAddressFamilyConfig<AFVSOCKSocketAddress>(){

        protected Class<? extends AFSocket<AFVSOCKSocketAddress>> socketClass() {
            return AFVSOCKSocket.class;
        }

        protected AFSocket.Constructor<AFVSOCKSocketAddress> socketConstructor() {
            return AFVSOCKSocket::new;
        }

        protected Class<? extends AFServerSocket<AFVSOCKSocketAddress>> serverSocketClass() {
            return AFVSOCKServerSocket.class;
        }

        protected AFServerSocket.Constructor<AFVSOCKSocketAddress> serverSocketConstructor() {
            return AFVSOCKServerSocket::new;
        }

        protected Class<? extends AFSocketChannel<AFVSOCKSocketAddress>> socketChannelClass() {
            return AFVSOCKSocketChannel.class;
        }

        protected Class<? extends AFServerSocketChannel<AFVSOCKSocketAddress>> serverSocketChannelClass() {
            return AFVSOCKServerSocketChannel.class;
        }

        protected Class<? extends AFDatagramSocket<AFVSOCKSocketAddress>> datagramSocketClass() {
            return AFVSOCKDatagramSocket.class;
        }

        protected AFDatagramSocket.Constructor<AFVSOCKSocketAddress> datagramSocketConstructor() {
            return AFVSOCKDatagramSocket::new;
        }

        protected Class<? extends AFDatagramChannel<AFVSOCKSocketAddress>> datagramChannelClass() {
            return AFVSOCKDatagramChannel.class;
        }
    });

    private AFVSOCKSelectorProvider() {
    }

    @SuppressFBWarnings(value={"MS_EXPOSE_REP"})
    public static AFVSOCKSelectorProvider getInstance() {
        return INSTANCE;
    }

    public static AFVSOCKSelectorProvider provider() {
        return AFVSOCKSelectorProvider.getInstance();
    }

    protected <P extends AFSomeSocket> AFSocketPair<P> newSocketPair(P s1, P s2) {
        return new AFVSOCKSocketPair<P>(s1, s2);
    }

    public AFVSOCKSocketPair<AFVSOCKSocketChannel> openSocketChannelPair() throws IOException {
        return (AFVSOCKSocketPair)super.openSocketChannelPair();
    }

    public AFVSOCKSocketPair<AFVSOCKDatagramChannel> openDatagramChannelPair() throws IOException {
        return (AFVSOCKSocketPair)super.openDatagramChannelPair();
    }

    protected AFVSOCKSocket newSocket() throws IOException {
        return AFVSOCKSocket.newInstance();
    }

    public AFVSOCKDatagramChannel openDatagramChannel() throws IOException {
        return AFVSOCKDatagramSocket.newInstance().getChannel();
    }

    public AFVSOCKDatagramChannel openDatagramChannel(ProtocolFamily family) throws IOException {
        return (AFVSOCKDatagramChannel)super.openDatagramChannel(family);
    }

    public AFVSOCKServerSocketChannel openServerSocketChannel() throws IOException {
        return AFVSOCKServerSocket.newInstance().getChannel();
    }

    public AFVSOCKServerSocketChannel openServerSocketChannel(SocketAddress sa) throws IOException {
        return AFVSOCKServerSocket.bindOn(AFVSOCKSocketAddress.unwrap((SocketAddress)sa)).getChannel();
    }

    public AFVSOCKSocketChannel openSocketChannel() throws IOException {
        return (AFVSOCKSocketChannel)super.openSocketChannel();
    }

    public AFVSOCKSocketChannel openSocketChannel(SocketAddress sa) throws IOException {
        return AFVSOCKSocket.connectTo(AFVSOCKSocketAddress.unwrap((SocketAddress)sa)).getChannel();
    }

    protected ProtocolFamily protocolFamily() {
        return AFVSOCKProtocolFamily.VSOCK;
    }

    protected AFAddressFamily<@NonNull AFVSOCKSocketAddress> addressFamily() {
        return AF_VSOCK;
    }
}

