/*
 * Decompiled with CFR 0.152.
 */
package org.newsclub.net.unix.ssl;

import com.kohlschutter.annotations.compiletime.SuppressFBWarnings;
import com.kohlschutter.testutil.TestAbortedWithImportantMessageException;
import com.kohlschutter.testutil.TestResourceUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.security.Provider;
import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.net.ssl.HandshakeCompletedEvent;
import javax.net.ssl.HandshakeCompletedListener;
import javax.net.ssl.SNIHostName;
import javax.net.ssl.SNIMatcher;
import javax.net.ssl.SNIServerName;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.EnumSource;
import org.newsclub.net.unix.AFSocket;
import org.newsclub.net.unix.AFUNIXSocket;
import org.newsclub.net.unix.AFUNIXSocketAddress;
import org.newsclub.net.unix.KnownJavaBugIOException;
import org.newsclub.net.unix.ssl.BuilderSSLSocketFactory;
import org.newsclub.net.unix.ssl.SNIHostnameCapture;
import org.newsclub.net.unix.ssl.SSLContextBuilder;
import org.newsclub.net.unix.ssl.SSLContextBuilderTest;
import org.newsclub.net.unix.ssl.SSLParametersUtil;
import org.newsclub.net.unix.ssl.SSLTestBase;
import org.newsclub.net.unix.ssl.TestUtil;
import org.newsclub.net.unix.ssl.TestingAFSocketServer;
import org.opentest4j.AssertionFailedError;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class SNIHostnameCaptureTest
extends SSLTestBase {
    private static SSLSocketFactory initClientSocketFactory(SSLTestBase.TestSSLConfiguration configuration) throws Exception {
        try {
            return configuration.configure(SSLContextBuilder.forClient()).withTrustStore(TestResourceUtil.getRequiredResource(SSLContextBuilderTest.class, (String)"juxclient.truststore"), () -> "clienttrustpass".toCharArray()).buildAndDestroyBuilder().getSocketFactory();
        }
        catch (KnownJavaBugIOException e) {
            throw new TestAbortedWithImportantMessageException(TestAbortedWithImportantMessageException.MessageType.TEST_ABORTED_SHORT_WITH_ISSUES, e.getMessage(), (Throwable)e);
        }
    }

    @ParameterizedTest
    @EnumSource(value=SSLTestBase.TestSSLConfiguration.class)
    public void testSNISuccessExpectDefault_NO_serverNullDefault_NO_clientEmptyDefault_NO(SSLTestBase.TestSSLConfiguration configuration) throws Exception {
        this.testSNISuccess(configuration, false, false, false);
    }

    @ParameterizedTest
    @EnumSource(value=SSLTestBase.TestSSLConfiguration.class)
    public void testSNISuccessExpectDefault_NO_serverNullDefault_YES_clientEmptyDefault_NO(SSLTestBase.TestSSLConfiguration configuration) throws Exception {
        this.testSNISuccess(configuration, false, true, false);
    }

    @ParameterizedTest
    @EnumSource(value=SSLTestBase.TestSSLConfiguration.class)
    public void testSNISuccessExpectDefault_NO_serverNullDefault_NO_clientEmptyDefault_YES(SSLTestBase.TestSSLConfiguration configuration) throws Exception {
        this.testSNISuccess(configuration, false, false, true);
    }

    @ParameterizedTest
    @EnumSource(value=SSLTestBase.TestSSLConfiguration.class)
    public void testSNISuccessExpectDefault_NO_serverNullDefault_YES_clientEmptyDefault_YES(SSLTestBase.TestSSLConfiguration configuration) throws Exception {
        this.testSNISuccess(configuration, false, true, true);
    }

    @ParameterizedTest
    @EnumSource(value=SSLTestBase.TestSSLConfiguration.class)
    public void testSNISuccessExpectDefault_YES_serverNullDefault_NO_clientEmptyDefault_NO(SSLTestBase.TestSSLConfiguration configuration) throws Exception {
        this.testSNISuccess(configuration, true, false, false);
    }

    @ParameterizedTest
    @EnumSource(value=SSLTestBase.TestSSLConfiguration.class)
    public void testSNISuccessExpectDefault_YES_serverNullDefault_YES_clientEmptyDefault_NO(SSLTestBase.TestSSLConfiguration configuration) throws Exception {
        this.testSNISuccess(configuration, true, true, false);
    }

    @ParameterizedTest
    @EnumSource(value=SSLTestBase.TestSSLConfiguration.class)
    public void testSNISuccessExpectDefault_YES_serverNullDefault_NO_clientEmptyDefault_YES(SSLTestBase.TestSSLConfiguration configuration) throws Exception {
        this.testSNISuccess(configuration, true, false, true);
    }

    @ParameterizedTest
    @EnumSource(value=SSLTestBase.TestSSLConfiguration.class)
    public void testSNISuccessExpectDefault_YES_serverNullDefault_YES_clientEmptyDefault_YES(SSLTestBase.TestSSLConfiguration configuration) throws Exception {
        this.testSNISuccess(configuration, true, true, true);
    }

    private void testSNISuccess(SSLTestBase.TestSSLConfiguration configuration, boolean expectDefault, boolean serverNullDefaultHostname, boolean clientEmptyDefaultHostname) throws Exception {
        AFUNIXSocketAddress addr = AFUNIXSocketAddress.ofNewTempFile();
        try {
            SSLSocketFactory serverSocketFactory = configuration.configure(SSLContextBuilder.forServer()).withKeyStore(TestResourceUtil.getRequiredResource(SSLContextBuilderTest.class, (String)"juxserver.p12"), () -> "serverpass".toCharArray()).buildAndDestroyBuilder().getSocketFactory();
            Assertions.assertTimeoutPreemptively((Duration)Duration.ofSeconds(5L), () -> this.runServerAndClient(configuration, addr, serverSocketFactory, expectDefault, serverNullDefaultHostname, clientEmptyDefaultHostname));
        }
        catch (KnownJavaBugIOException e) {
            throw new TestAbortedWithImportantMessageException(TestAbortedWithImportantMessageException.MessageType.TEST_ABORTED_SHORT_WITH_ISSUES, e.getMessage(), (Throwable)e);
        }
        catch (Error | Exception e) {
            throw configuration.handleException(e);
        }
        finally {
            Files.deleteIfExists(addr.getFile().toPath());
        }
    }

    private static boolean isBouncyCastleJSSE(SSLSocketFactory socketFactory) {
        Provider p;
        SSLContext context = socketFactory instanceof BuilderSSLSocketFactory ? ((BuilderSSLSocketFactory)socketFactory).getContext() : null;
        return context != null && (p = context.getProvider()) != null && "BCJSSE".equals(p.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runServerAndClient(final SSLTestBase.TestSSLConfiguration configuration, AFUNIXSocketAddress addr, final SSLSocketFactory serverSocketFactory, final boolean expectDefault, final boolean serverNullDefaultHostname, final boolean clientEmptyDefaultHostname) throws Exception {
        final CompletableFuture failureServer = new CompletableFuture();
        CompletableFuture<Exception> failureClient = new CompletableFuture<Exception>();
        SSLSocketFactory clientSocketFactory = SNIHostnameCaptureTest.initClientSocketFactory(configuration);
        final AtomicBoolean gotHostnameInTime = new AtomicBoolean(false);
        TestingAFSocketServer<AFUNIXSocketAddress> server = new TestingAFSocketServer<AFUNIXSocketAddress>(this, addr){
            final /* synthetic */ SNIHostnameCaptureTest this$0;
            {
                this.this$0 = this$0;
                super(listenAddress);
            }

            protected void doServeSocket(AFSocket<? extends AFUNIXSocketAddress> plainSocket) throws IOException {
                boolean sniBroken = false;
                try (SSLSocket sslSocket = (SSLSocket)serverSocketFactory.createSocket((Socket)plainSocket, "localhost.junixsocket", plainSocket.getPort(), false);){
                    SNIHostnameCapture hnc = serverNullDefaultHostname ? SNIHostnameCapture.configure((SSLSocket)sslSocket, (SNIMatcher)SNIHostnameCapture.ACCEPT_ANY_HOSTNAME) : SNIHostnameCapture.configure((SSLSocket)sslSocket, (SNIMatcher)SNIHostnameCapture.ACCEPT_ANY_HOSTNAME, () -> "defaulthost");
                    Assertions.assertFalse((boolean)hnc.isComplete());
                    Assertions.assertThrows(IllegalStateException.class, () -> hnc.getHostname());
                    sslSocket.startHandshake();
                    hnc.isComplete(1L, TimeUnit.SECONDS);
                    gotHostnameInTime.set(hnc.isComplete());
                    try {
                        if (expectDefault) {
                            if (serverNullDefaultHostname && clientEmptyDefaultHostname) {
                                Assertions.assertNull((Object)hnc.getHostname());
                            } else if (clientEmptyDefaultHostname) {
                                Assertions.assertEquals((Object)"defaulthost", (Object)hnc.getHostname());
                            } else {
                                Assertions.assertEquals((Object)"localhost.junixsocket", (Object)hnc.getHostname());
                            }
                        } else if ("defaulthost".equals(hnc.getHostname()) && AFSocket.isRunningOnAndroid()) {
                            failureServer.complete(new TestAbortedWithImportantMessageException(TestAbortedWithImportantMessageException.MessageType.TEST_ABORTED_SHORT_WITH_ISSUES, "Android seems to not properly send the SNI hostname request"));
                        } else {
                            Assertions.assertEquals((Object)"subdomain.example.com", (Object)hnc.getHostname());
                        }
                    }
                    catch (AssertionFailedError e) {
                        if (configuration.isSniBroken()) {
                            sniBroken = true;
                        }
                        throw e;
                    }
                    try (InputStream in = sslSocket.getInputStream();
                         OutputStream out = sslSocket.getOutputStream();){
                        block37: {
                            int v = in.read();
                            Assertions.assertEquals((int)63, (int)v);
                            if (!hnc.isComplete()) {
                                Assertions.fail((String)"Handshake is not marked complete, but data can be read");
                            }
                            CompletableFuture cf = new CompletableFuture();
                            try {
                                Assertions.assertEquals((Object)hnc.getHostnameFromSSLSession(sslSocket, cf::complete), (Object)hnc.getHostname());
                            }
                            catch (AssertionFailedError e) {
                                if (cf.isDone() && SNIHostnameCaptureTest.isBouncyCastleJSSE(serverSocketFactory)) break block37;
                                throw e;
                            }
                        }
                        Assertions.assertEquals((int)(expectDefault ? 1 : 0), (int)in.read());
                        Assertions.assertEquals((int)(serverNullDefaultHostname ? 1 : 0), (int)in.read());
                        Assertions.assertEquals((int)(clientEmptyDefaultHostname ? 1 : 0), (int)in.read());
                        out.write("Hello World".getBytes(StandardCharsets.UTF_8));
                        out.flush();
                    }
                    if (!gotHostnameInTime.get()) {
                        Assertions.fail((String)"Handshake was not marked complete in time, but eventually was");
                    }
                    if (sniBroken) {
                        throw new TestAbortedWithImportantMessageException(TestAbortedWithImportantMessageException.MessageType.TEST_ABORTED_SHORT_WITH_ISSUES, "SNI support is knowingly incomplete for " + (Object)((Object)configuration));
                    }
                }
                catch (Error | Exception e) {
                    failureServer.complete(e);
                }
                if (!gotHostnameInTime.get()) {
                    failureServer.complete(new AssertionFailedError("Handshake was not marked complete in time"));
                }
            }
        };
        try {
            server.startAndWaitToBecomeReady();
            try (AFUNIXSocket plainSocket = AFUNIXSocket.connectTo((AFUNIXSocketAddress)addr);
                 SSLSocket sslSocket = (SSLSocket)clientSocketFactory.createSocket((Socket)plainSocket, clientEmptyDefaultHostname ? "" : "localhost.junixsocket", plainSocket.getPort(), false);){
                if (!expectDefault) {
                    SSLParametersUtil.setSNIServerName((SSLSocket)sslSocket, (SNIServerName)new SNIHostName("subdomain.example.com"));
                }
                try (InputStream in = sslSocket.getInputStream();
                     OutputStream out = sslSocket.getOutputStream();){
                    int offset;
                    int r;
                    out.write(63);
                    out.write(expectDefault ? 1 : 0);
                    out.write(serverNullDefaultHostname ? 1 : 0);
                    out.write(clientEmptyDefaultHostname ? 1 : 0);
                    out.flush();
                    byte[] by = new byte[11];
                    for (offset = 0; offset < by.length && (r = in.read(by, offset, by.length - offset)) >= 0; offset += r) {
                    }
                    Assertions.assertEquals((Object)"Hello World", (Object)new String(by, 0, offset, StandardCharsets.UTF_8));
                }
                catch (Exception e) {
                    failureClient.complete(e);
                }
            }
        }
        finally {
            server.stop();
            TestUtil.throwMoreInterestingThrowableThanSocketException(() -> failureServer.getNow(null), () -> failureClient.getNow(null));
            server.checkThrowable();
        }
    }

    @Test
    public void testWonkySSLSocket() throws Exception {
        this.testWonkySSLSocket(0);
        this.testWonkySSLSocket(23);
    }

    private void testWonkySSLSocket(final int matchType) throws Exception {
        SSLSocket sslSocket = new SSLSocket(){
            private HandshakeCompletedListener hcl;
            private SSLParameters params = new SSLParameters();

            @Override
            @SuppressFBWarnings(value={"RV_RETURN_VALUE_IGNORED_NO_SIDE_EFFECT"})
            public void startHandshake() throws IOException {
                for (SNIMatcher sm : this.getSSLParameters().getSNIMatchers()) {
                    sm.matches(new SNIHostName("hostname"));
                    sm.matches(new SNIServerName(23, "WAT".getBytes(StandardCharsets.US_ASCII)){});
                    sm.matches(new SNIHostName("hostname"));
                    sm.matches(new SNIHostName("anotherHostname"));
                }
                this.hcl.handshakeCompleted(new HandshakeCompletedEvent(this, null));
            }

            @Override
            public void setWantClientAuth(boolean want) {
            }

            @Override
            public void setUseClientMode(boolean mode) {
            }

            @Override
            public void setNeedClientAuth(boolean need) {
            }

            @Override
            public void setEnabledProtocols(String[] protocols) {
            }

            @Override
            public void setEnabledCipherSuites(String[] suites) {
            }

            @Override
            public void setEnableSessionCreation(boolean flag) {
            }

            @Override
            public void removeHandshakeCompletedListener(HandshakeCompletedListener listener) {
            }

            @Override
            public boolean getWantClientAuth() {
                return false;
            }

            @Override
            public boolean getUseClientMode() {
                return false;
            }

            @Override
            public String[] getSupportedProtocols() {
                return null;
            }

            @Override
            public String[] getSupportedCipherSuites() {
                return null;
            }

            @Override
            public SSLSession getSession() {
                return null;
            }

            @Override
            public boolean getNeedClientAuth() {
                return false;
            }

            @Override
            public String[] getEnabledProtocols() {
                return null;
            }

            @Override
            public String[] getEnabledCipherSuites() {
                return null;
            }

            @Override
            public boolean getEnableSessionCreation() {
                return false;
            }

            @Override
            public SSLParameters getSSLParameters() {
                return this.params;
            }

            @Override
            public void setSSLParameters(SSLParameters params) {
                this.params = params;
            }

            @Override
            public void addHandshakeCompletedListener(HandshakeCompletedListener listener) {
                if (this.hcl != null) {
                    throw new IllegalStateException();
                }
                this.hcl = listener;
            }
        };
        SNIHostnameCapture shc = SNIHostnameCapture.configure((SSLSocket)sslSocket, (SNIMatcher)new SNIMatcher(this, matchType){
            final /* synthetic */ SNIHostnameCaptureTest this$0;
            {
                this.this$0 = this$0;
                super(arg0);
            }

            @Override
            public boolean matches(SNIServerName serverName) {
                return serverName.getType() == matchType;
            }
        });
        sslSocket.startHandshake();
        if (matchType == 0) {
            Assertions.assertEquals((Object)"hostname", (Object)shc.getHostname());
        } else {
            Assertions.assertNull((Object)shc.getHostname());
        }
    }
}

