/*
 * Decompiled with CFR 0.152.
 */
package org.newsclub.net.unix.ssl;

import com.kohlschutter.testutil.AssertUtil;
import com.kohlschutter.testutil.TestAbortedWithImportantMessageException;
import com.kohlschutter.testutil.TestResourceUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.security.KeyStore;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import javax.net.ssl.SNIHostName;
import javax.net.ssl.SNIServerName;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLProtocolException;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.EnumSource;
import org.newsclub.net.unix.AFSocket;
import org.newsclub.net.unix.AFUNIXSocket;
import org.newsclub.net.unix.AFUNIXSocketAddress;
import org.newsclub.net.unix.KnownJavaBugIOException;
import org.newsclub.net.unix.ssl.FilterX509TrustManager;
import org.newsclub.net.unix.ssl.SSLContextBuilder;
import org.newsclub.net.unix.ssl.SSLContextBuilderTest;
import org.newsclub.net.unix.ssl.SSLParametersUtil;
import org.newsclub.net.unix.ssl.SSLTestBase;
import org.newsclub.net.unix.ssl.TestUtil;
import org.newsclub.net.unix.ssl.TestingAFSocketServer;
import org.newsclub.net.unix.ssl.ValidatingX509TrustManager;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class ValidatingX509TrustManagerTest
extends SSLTestBase {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ParameterizedTest
    @EnumSource(value=SSLTestBase.TestSSLConfiguration.class)
    public void testInspectTrustedCertificateExpired(SSLTestBase.TestSSLConfiguration configuration) throws Exception {
        SSLSocketFactory clientSocketFactory;
        SSLSocketFactory serverSocketFactory;
        AFUNIXSocketAddress addr = AFUNIXSocketAddress.ofNewTempFile();
        try {
            serverSocketFactory = configuration.configure(SSLContextBuilder.forServer()).withKeyStore(TestResourceUtil.getRequiredResource(ValidatingX509TrustManagerTest.class, (String)"juxserver.p12"), () -> "serverpass".toCharArray()).buildAndDestroyBuilder().getSocketFactory();
            clientSocketFactory = configuration.configure(SSLContextBuilder.forClient()).withTrustManagers(tmf -> {
                KeyStore ks = SSLContextBuilder.newKeyStorePKCS12();
                try (InputStream in = TestResourceUtil.getRequiredResource(SSLContextBuilderTest.class, (String)"juxclient.truststore").openStream();){
                    ks.load(in, "clienttrustpass".toCharArray());
                }
                tmf.init(ks);
                X509TrustManager underlyingTrustManager = (X509TrustManager)tmf.getTrustManagers()[0];
                ValidatingX509TrustManager tm = new ValidatingX509TrustManager(underlyingTrustManager);
                Assertions.assertArrayEquals((Object[])underlyingTrustManager.getAcceptedIssuers(), (Object[])tm.getAcceptedIssuers());
                return new TrustManager[]{tm};
            }).buildAndDestroyBuilder().getSocketFactory();
        }
        catch (KnownJavaBugIOException e) {
            throw new TestAbortedWithImportantMessageException(TestAbortedWithImportantMessageException.MessageType.TEST_ABORTED_SHORT_WITH_ISSUES, e.getMessage(), (Throwable)e);
        }
        CompletableFuture serverException = new CompletableFuture();
        CompletableFuture clientException = new CompletableFuture();
        try {
            Assertions.assertTimeoutPreemptively((Duration)Duration.ofSeconds(5L), () -> Assertions.assertThrows(IOException.class, () -> this.runServerAndClient(addr, serverSocketFactory, clientSocketFactory, serverException, clientException)));
            AssertUtil.assertInstanceOf((Throwable)((Throwable)serverException.get()), (Class[])new Class[]{SocketException.class, SSLHandshakeException.class, SSLProtocolException.class, BOUNCYCASTLE_TLS_EXCEPTION, SSLException.class});
            AssertUtil.assertInstanceOf((Throwable)((Throwable)clientException.get()), (Class[])new Class[]{SocketException.class, SSLHandshakeException.class, SSLProtocolException.class, BOUNCYCASTLE_TLS_EXCEPTION, SSLException.class});
        }
        finally {
            Files.deleteIfExists(addr.getFile().toPath());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ParameterizedTest
    @EnumSource(value=SSLTestBase.TestSSLConfiguration.class)
    public void testInspectTrustedCertificateNotExpired(SSLTestBase.TestSSLConfiguration configuration) throws Exception {
        SSLSocketFactory clientSocketFactory;
        SSLSocketFactory serverSocketFactory;
        AFUNIXSocketAddress addr = AFUNIXSocketAddress.ofNewTempFile();
        try {
            serverSocketFactory = configuration.configure(SSLContextBuilder.forServer()).withKeyStore(TestResourceUtil.getRequiredResource(ValidatingX509TrustManagerTest.class, (String)"juxclient.p12"), () -> "clientpass".toCharArray()).buildAndDestroyBuilder().getSocketFactory();
            clientSocketFactory = configuration.configure(SSLContextBuilder.forClient()).withTrustManagers(tmf -> {
                KeyStore ks = SSLContextBuilder.newKeyStorePKCS12();
                try (InputStream in = TestResourceUtil.getRequiredResource(SSLContextBuilderTest.class, (String)"juxserver.truststore").openStream();){
                    ks.load(in, "servertrustpass".toCharArray());
                }
                tmf.init(ks);
                X509TrustManager underlyingTrustManager = (X509TrustManager)tmf.getTrustManagers()[0];
                ValidatingX509TrustManager tm = new ValidatingX509TrustManager(underlyingTrustManager);
                Assertions.assertArrayEquals((Object[])underlyingTrustManager.getAcceptedIssuers(), (Object[])tm.getAcceptedIssuers());
                return new TrustManager[]{tm};
            }).buildAndDestroyBuilder().getSocketFactory();
        }
        catch (KnownJavaBugIOException e) {
            throw new TestAbortedWithImportantMessageException(TestAbortedWithImportantMessageException.MessageType.TEST_ABORTED_SHORT_WITH_ISSUES, e.getMessage(), (Throwable)e);
        }
        CompletableFuture serverException = new CompletableFuture();
        CompletableFuture clientException = new CompletableFuture();
        try {
            Assertions.assertTimeoutPreemptively((Duration)Duration.ofSeconds(5L), () -> this.runServerAndClient(addr, serverSocketFactory, clientSocketFactory, serverException, clientException));
            Assertions.assertNull(serverException.get());
            Assertions.assertNull(clientException.get());
        }
        finally {
            Files.deleteIfExists(addr.getFile().toPath());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ParameterizedTest
    @EnumSource(value=SSLTestBase.TestSSLConfiguration.class)
    public void testInspectTrustedCertificateExpiredNested(SSLTestBase.TestSSLConfiguration configuration) throws Exception {
        SSLSocketFactory clientSocketFactory;
        SSLSocketFactory serverSocketFactory;
        AFUNIXSocketAddress addr = AFUNIXSocketAddress.ofNewTempFile();
        try {
            serverSocketFactory = configuration.configure(SSLContextBuilder.forServer()).withKeyStore(TestResourceUtil.getRequiredResource(ValidatingX509TrustManagerTest.class, (String)"juxserver.p12"), () -> "serverpass".toCharArray()).buildAndDestroyBuilder().getSocketFactory();
            clientSocketFactory = configuration.configure(SSLContextBuilder.forClient()).withTrustManagers(tmf -> {
                KeyStore ks = SSLContextBuilder.newKeyStorePKCS12();
                try (InputStream in = TestResourceUtil.getRequiredResource(SSLContextBuilderTest.class, (String)"juxclient.truststore").openStream();){
                    ks.load(in, "clienttrustpass".toCharArray());
                }
                tmf.init(ks);
                X509TrustManager underlyingTrustManager = (X509TrustManager)tmf.getTrustManagers()[0];
                ValidatingX509TrustManager tm = new ValidatingX509TrustManager((X509TrustManager)new ValidatingX509TrustManager(underlyingTrustManager));
                Assertions.assertArrayEquals((Object[])underlyingTrustManager.getAcceptedIssuers(), (Object[])tm.getAcceptedIssuers());
                return new TrustManager[]{tm};
            }).buildAndDestroyBuilder().getSocketFactory();
        }
        catch (KnownJavaBugIOException e) {
            throw new TestAbortedWithImportantMessageException(TestAbortedWithImportantMessageException.MessageType.TEST_ABORTED_SHORT_WITH_ISSUES, e.getMessage(), (Throwable)e);
        }
        CompletableFuture serverException = new CompletableFuture();
        CompletableFuture clientException = new CompletableFuture();
        try {
            Assertions.assertTimeoutPreemptively((Duration)Duration.ofSeconds(5L), () -> Assertions.assertThrows(IOException.class, () -> this.runServerAndClient(addr, serverSocketFactory, clientSocketFactory, serverException, clientException)));
            AssertUtil.assertInstanceOf((Throwable)((Throwable)serverException.get()), (Class[])new Class[]{SocketException.class, SSLHandshakeException.class, SSLProtocolException.class, BOUNCYCASTLE_TLS_EXCEPTION, SSLException.class});
            AssertUtil.assertInstanceOf((Throwable)((Throwable)clientException.get()), (Class[])new Class[]{SocketException.class, SSLHandshakeException.class, SSLProtocolException.class, BOUNCYCASTLE_TLS_EXCEPTION, SSLException.class});
        }
        finally {
            Files.deleteIfExists(addr.getFile().toPath());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ParameterizedTest
    @EnumSource(value=SSLTestBase.TestSSLConfiguration.class)
    public void testInspectTrustedCertificateExpiredNestedFilter(SSLTestBase.TestSSLConfiguration configuration) throws Exception {
        SSLSocketFactory clientSocketFactory;
        SSLSocketFactory serverSocketFactory;
        AFUNIXSocketAddress addr = AFUNIXSocketAddress.ofNewTempFile();
        try {
            serverSocketFactory = configuration.configure(SSLContextBuilder.forServer()).withKeyStore(TestResourceUtil.getRequiredResource(ValidatingX509TrustManagerTest.class, (String)"juxserver.p12"), () -> "serverpass".toCharArray()).buildAndDestroyBuilder().getSocketFactory();
            clientSocketFactory = configuration.configure(SSLContextBuilder.forClient()).withTrustManagers(tmf -> {
                KeyStore ks = SSLContextBuilder.newKeyStorePKCS12();
                try (InputStream in = TestResourceUtil.getRequiredResource(SSLContextBuilderTest.class, (String)"juxclient.truststore").openStream();){
                    ks.load(in, "clienttrustpass".toCharArray());
                }
                tmf.init(ks);
                X509TrustManager underlyingTrustManager = (X509TrustManager)tmf.getTrustManagers()[0];
                FilterX509TrustManager tm = new FilterX509TrustManager((X509TrustManager)new ValidatingX509TrustManager(underlyingTrustManager)){

                    protected void onCertificateException(boolean checkClient, CertificateException e, X509Certificate[] chain, String authType) throws CertificateException {
                        Assertions.assertFalse((boolean)checkClient);
                    }

                    protected void onCertificateTrusted(boolean checkClient, X509Certificate[] chain, String authType) throws CertificateException {
                        Assertions.fail((String)"unexpected");
                    }
                };
                Assertions.assertArrayEquals((Object[])underlyingTrustManager.getAcceptedIssuers(), (Object[])tm.getAcceptedIssuers());
                return new TrustManager[]{tm};
            }).buildAndDestroyBuilder().getSocketFactory();
        }
        catch (KnownJavaBugIOException e) {
            throw new TestAbortedWithImportantMessageException(TestAbortedWithImportantMessageException.MessageType.TEST_ABORTED_SHORT_WITH_ISSUES, e.getMessage(), (Throwable)e);
        }
        CompletableFuture serverException = new CompletableFuture();
        CompletableFuture clientException = new CompletableFuture();
        try {
            Assertions.assertTimeoutPreemptively((Duration)Duration.ofSeconds(5L), () -> this.runServerAndClient(addr, serverSocketFactory, clientSocketFactory, serverException, clientException));
        }
        finally {
            Files.deleteIfExists(addr.getFile().toPath());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ParameterizedTest
    @EnumSource(value=SSLTestBase.TestSSLConfiguration.class)
    public void testInspectTrustedClientCertificate(SSLTestBase.TestSSLConfiguration configuration) throws Exception {
        SSLSocketFactory clientSocketFactory;
        SSLSocketFactory serverSocketFactory;
        AFUNIXSocketAddress addr = AFUNIXSocketAddress.ofNewTempFile();
        try {
            serverSocketFactory = configuration.configure(SSLContextBuilder.forServer()).withKeyStore(TestResourceUtil.getRequiredResource(ValidatingX509TrustManagerTest.class, (String)"juxserver.p12"), () -> "serverpass".toCharArray()).withDefaultSSLParameters(p -> p.setNeedClientAuth(true)).withTrustManagers(tmf -> {
                KeyStore ks = SSLContextBuilder.newKeyStorePKCS12();
                try (InputStream in = TestResourceUtil.getRequiredResource(SSLContextBuilderTest.class, (String)"juxserver.truststore").openStream();){
                    ks.load(in, "servertrustpass".toCharArray());
                }
                tmf.init(ks);
                X509TrustManager underlyingTrustManager = (X509TrustManager)tmf.getTrustManagers()[0];
                ValidatingX509TrustManager tm = new ValidatingX509TrustManager(underlyingTrustManager);
                return new TrustManager[]{tm};
            }).buildAndDestroyBuilder().getSocketFactory();
            clientSocketFactory = configuration.configure(SSLContextBuilder.forClient()).withKeyStore(TestResourceUtil.getRequiredResource(ValidatingX509TrustManagerTest.class, (String)"juxclient.p12"), () -> "clientpass".toCharArray()).withTrustStore(TestResourceUtil.getRequiredResource(ValidatingX509TrustManagerTest.class, (String)"juxclient.truststore"), () -> "clienttrustpass".toCharArray()).buildAndDestroyBuilder().getSocketFactory();
        }
        catch (KnownJavaBugIOException e) {
            throw new TestAbortedWithImportantMessageException(TestAbortedWithImportantMessageException.MessageType.TEST_ABORTED_SHORT_WITH_ISSUES, e.getMessage(), (Throwable)e);
        }
        CompletableFuture serverException = new CompletableFuture();
        CompletableFuture clientException = new CompletableFuture();
        try {
            Assertions.assertTimeoutPreemptively((Duration)Duration.ofSeconds(5L), () -> this.runServerAndClient(addr, serverSocketFactory, clientSocketFactory, serverException, clientException));
            Assertions.assertNull(serverException.get());
            Assertions.assertNull(clientException.get());
        }
        finally {
            Files.deleteIfExists(addr.getFile().toPath());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ParameterizedTest
    @EnumSource(value=SSLTestBase.TestSSLConfiguration.class)
    public void testInspectTrustedClientCertificateExpired(SSLTestBase.TestSSLConfiguration configuration) throws Exception {
        SSLSocketFactory clientSocketFactory;
        SSLSocketFactory serverSocketFactory;
        AFUNIXSocketAddress addr = AFUNIXSocketAddress.ofNewTempFile();
        try {
            serverSocketFactory = configuration.configure(SSLContextBuilder.forServer()).withKeyStore(TestResourceUtil.getRequiredResource(ValidatingX509TrustManagerTest.class, (String)"juxclient.p12"), () -> "clientpass".toCharArray()).withDefaultSSLParameters(p -> p.setNeedClientAuth(true)).withTrustManagers(tmf -> {
                KeyStore ks = SSLContextBuilder.newKeyStorePKCS12();
                try (InputStream in = TestResourceUtil.getRequiredResource(SSLContextBuilderTest.class, (String)"juxclient.truststore").openStream();){
                    ks.load(in, "clienttrustpass".toCharArray());
                }
                tmf.init(ks);
                X509TrustManager underlyingTrustManager = (X509TrustManager)tmf.getTrustManagers()[0];
                ValidatingX509TrustManager tm = new ValidatingX509TrustManager(underlyingTrustManager);
                return new TrustManager[]{tm};
            }).buildAndDestroyBuilder().getSocketFactory();
            clientSocketFactory = configuration.configure(SSLContextBuilder.forClient()).withKeyStore(TestResourceUtil.getRequiredResource(ValidatingX509TrustManagerTest.class, (String)"juxserver.p12"), () -> "serverpass".toCharArray()).withTrustStore(TestResourceUtil.getRequiredResource(ValidatingX509TrustManagerTest.class, (String)"juxserver.truststore"), () -> "servertrustpass".toCharArray()).buildAndDestroyBuilder().getSocketFactory();
        }
        catch (KnownJavaBugIOException e) {
            throw new TestAbortedWithImportantMessageException(TestAbortedWithImportantMessageException.MessageType.TEST_ABORTED_SHORT_WITH_ISSUES, e.getMessage(), (Throwable)e);
        }
        CompletableFuture serverException = new CompletableFuture();
        CompletableFuture clientException = new CompletableFuture();
        try {
            Assertions.assertTimeoutPreemptively((Duration)Duration.ofSeconds(5L), () -> Assertions.assertThrows(IOException.class, () -> this.runServerAndClient(addr, serverSocketFactory, clientSocketFactory, serverException, clientException)));
            AssertUtil.assertInstanceOf((Throwable)((Throwable)serverException.get()), (Class[])new Class[]{SocketException.class, SSLHandshakeException.class, SSLProtocolException.class, BOUNCYCASTLE_TLS_EXCEPTION, SSLException.class});
            AssertUtil.assertInstanceOf((Throwable)((Throwable)clientException.get()), (Class[])new Class[]{SocketException.class, SSLHandshakeException.class, SSLProtocolException.class, BOUNCYCASTLE_TLS_EXCEPTION, SSLException.class});
        }
        finally {
            Files.deleteIfExists(addr.getFile().toPath());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ParameterizedTest
    @EnumSource(value=SSLTestBase.TestSSLConfiguration.class)
    public void testInspectTrustedClientCertificateExpiredNested(SSLTestBase.TestSSLConfiguration configuration) throws Exception {
        SSLSocketFactory clientSocketFactory;
        SSLSocketFactory serverSocketFactory;
        AFUNIXSocketAddress addr = AFUNIXSocketAddress.ofNewTempFile();
        try {
            serverSocketFactory = configuration.configure(SSLContextBuilder.forServer()).withKeyStore(TestResourceUtil.getRequiredResource(ValidatingX509TrustManagerTest.class, (String)"juxclient.p12"), () -> "clientpass".toCharArray()).withDefaultSSLParameters(p -> p.setNeedClientAuth(true)).withTrustManagers(tmf -> {
                KeyStore ks = SSLContextBuilder.newKeyStorePKCS12();
                try (InputStream in = TestResourceUtil.getRequiredResource(SSLContextBuilderTest.class, (String)"juxclient.truststore").openStream();){
                    ks.load(in, "clienttrustpass".toCharArray());
                }
                tmf.init(ks);
                X509TrustManager underlyingTrustManager = (X509TrustManager)tmf.getTrustManagers()[0];
                FilterX509TrustManager tm = new FilterX509TrustManager((X509TrustManager)new ValidatingX509TrustManager(underlyingTrustManager)){

                    protected void onCertificateTrusted(boolean checkClient, X509Certificate[] chain, String authType) throws CertificateException {
                        Assertions.fail((String)"unexpected");
                    }

                    protected void onCertificateException(boolean checkClient, CertificateException e, X509Certificate[] chain, String authType) throws CertificateException {
                    }
                };
                return new TrustManager[]{tm};
            }).buildAndDestroyBuilder().getSocketFactory();
            clientSocketFactory = configuration.configure(SSLContextBuilder.forClient()).withKeyStore(TestResourceUtil.getRequiredResource(ValidatingX509TrustManagerTest.class, (String)"juxserver.p12"), () -> "serverpass".toCharArray()).withTrustStore(TestResourceUtil.getRequiredResource(ValidatingX509TrustManagerTest.class, (String)"juxserver.truststore"), () -> "servertrustpass".toCharArray()).buildAndDestroyBuilder().getSocketFactory();
        }
        catch (KnownJavaBugIOException e) {
            throw new TestAbortedWithImportantMessageException(TestAbortedWithImportantMessageException.MessageType.TEST_ABORTED_SHORT_WITH_ISSUES, e.getMessage(), (Throwable)e);
        }
        CompletableFuture serverException = new CompletableFuture();
        CompletableFuture clientException = new CompletableFuture();
        try {
            Assertions.assertTimeoutPreemptively((Duration)Duration.ofSeconds(5L), () -> this.runServerAndClient(addr, serverSocketFactory, clientSocketFactory, serverException, clientException));
            Assertions.assertNull(serverException.get());
            Assertions.assertNull(clientException.get());
        }
        finally {
            Files.deleteIfExists(addr.getFile().toPath());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runServerAndClient(AFUNIXSocketAddress addr, final SSLSocketFactory serverSocketFactory, SSLSocketFactory clientSocketFactory, final CompletableFuture<Exception> serverException, CompletableFuture<Exception> clientException) throws Exception {
        TestingAFSocketServer<AFUNIXSocketAddress> server = new TestingAFSocketServer<AFUNIXSocketAddress>(this, addr){
            final /* synthetic */ ValidatingX509TrustManagerTest this$0;
            {
                this.this$0 = this$0;
                super(listenAddress);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void doServeSocket(AFSocket<? extends AFUNIXSocketAddress> plainSocket) throws IOException {
                Exception caught = null;
                try (SSLSocket sslSocket = (SSLSocket)serverSocketFactory.createSocket((Socket)plainSocket, "localhost.junixsocket", plainSocket.getPort(), false);
                     InputStream in = sslSocket.getInputStream();
                     OutputStream out = sslSocket.getOutputStream();){
                    int v = in.read();
                    Assertions.assertEquals((int)33, (int)v);
                    out.write("Hello World".getBytes(StandardCharsets.UTF_8));
                    out.flush();
                }
                catch (Exception e) {
                    caught = e;
                }
                finally {
                    serverException.complete(caught);
                }
            }
        };
        try {
            server.startAndWaitToBecomeReady();
            SNIHostName hostname = new SNIHostName("subdomain.example.com");
            Exception caught = null;
            try (AFUNIXSocket plainSocket = AFUNIXSocket.connectTo((AFUNIXSocketAddress)addr);
                 SSLSocket sslSocket = (SSLSocket)clientSocketFactory.createSocket((Socket)plainSocket, "localhost.junixsocket", plainSocket.getPort(), false);){
                SSLParametersUtil.setSNIServerName((SSLSocket)sslSocket, (SNIServerName)hostname);
                sslSocket.startHandshake();
                try (InputStream in = sslSocket.getInputStream();
                     OutputStream out = sslSocket.getOutputStream();){
                    int offset;
                    int r;
                    out.write(33);
                    out.flush();
                    byte[] by = new byte[11];
                    for (offset = 0; offset < by.length && (r = in.read(by, offset, by.length - offset)) >= 0; offset += r) {
                    }
                    Assertions.assertEquals((Object)"Hello World", (Object)new String(by, 0, offset, StandardCharsets.UTF_8));
                }
            }
            catch (SocketException e) {
                caught = e;
            }
            catch (Exception e) {
                caught = e;
                throw e;
            }
            finally {
                clientException.complete(caught);
            }
        }
        finally {
            server.stop();
            TestUtil.throwMoreInterestingThrowableThanSocketException(() -> serverException.getNow(null), () -> clientException.getNow(null));
            server.checkThrowable();
        }
    }
}

