/*
 * Decompiled with CFR 0.152.
 */
package org.newsclub.net.unix.domain;

import com.kohlschutter.annotations.compiletime.SuppressFBWarnings;
import com.kohlschutter.testutil.ForkedVM;
import com.kohlschutter.testutil.ProcessUtilRequirement;
import com.kohlschutter.testutil.TestAbortedWithImportantMessageException;
import java.io.BufferedReader;
import java.io.FileDescriptor;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.StandardSocketOptions;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.newsclub.net.unix.AFSocketAddress;
import org.newsclub.net.unix.AFSocketCapability;
import org.newsclub.net.unix.AFSocketCapabilityRequirement;
import org.newsclub.net.unix.AFUNIXDatagramChannel;
import org.newsclub.net.unix.AFUNIXServerSocket;
import org.newsclub.net.unix.AFUNIXSocket;
import org.newsclub.net.unix.AFUNIXSocketAddress;
import org.newsclub.net.unix.AFUNIXSocketChannel;
import org.newsclub.net.unix.AFUNIXSocketPair;
import org.newsclub.net.unix.FileDescriptorCast;
import org.newsclub.net.unix.StdinSocketApp;
import org.newsclub.net.unix.TestUtil;
import org.opentest4j.AssertionFailedError;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
@AFSocketCapabilityRequirement(value={AFSocketCapability.CAPABILITY_UNIX_DOMAIN})
@SuppressFBWarnings(value={"THROWS_METHOD_THROWS_CLAUSE_THROWABLE", "THROWS_METHOD_THROWS_CLAUSE_BASIC_EXCEPTION"})
public class FileDescriptorCastTest {
    @Test
    @AFSocketCapabilityRequirement(value={AFSocketCapability.CAPABILITY_NATIVE_SOCKETPAIR})
    public void testSocketPair() throws Exception {
        block10: {
            try (AFUNIXSocketPair socketPair = AFUNIXSocketPair.open();){
                AFUNIXSocketChannel sock1chan = (AFUNIXSocketChannel)socketPair.getSocket1();
                FileDescriptor sock2fd = ((AFUNIXSocketChannel)socketPair.getSocket2()).getFileDescriptor();
                Assertions.assertTrue((boolean)sock1chan.isConnected());
                FileDescriptorCast fdc = FileDescriptorCast.using((FileDescriptor)sock2fd);
                Assertions.assertEquals((Object)AFUNIXSocket.supports((AFSocketCapability)AFSocketCapability.CAPABILITY_NATIVE_SOCKETPAIR), (Object)fdc.isAvailable(Socket.class));
                if (!AFUNIXSocket.supports((AFSocketCapability)AFSocketCapability.CAPABILITY_NATIVE_SOCKETPAIR)) {
                    FileDescriptorCast.using((FileDescriptor)sock2fd).as(FileChannel.class);
                    break block10;
                }
                Socket sock2 = (Socket)FileDescriptorCast.using((FileDescriptor)sock2fd).as(Socket.class);
                Assertions.assertEquals(AFUNIXSocket.class, sock2.getClass());
                Assertions.assertEquals((Object)sock2fd, (Object)((AFUNIXSocket)sock2).getFileDescriptor());
                try {
                    Assertions.assertTrue((boolean)sock2.isConnected());
                }
                catch (AssertionFailedError e) {
                    if (TestUtil.isHaikuOS()) {
                        throw TestUtil.haikuBug18534(e);
                    }
                    throw e;
                }
            }
        }
    }

    @Test
    @AFSocketCapabilityRequirement(value={AFSocketCapability.CAPABILITY_NATIVE_SOCKETPAIR})
    public void testSocketPairNative() throws Exception {
        try (AFUNIXSocketPair socketPair = AFUNIXSocketPair.open();){
            AFUNIXSocketChannel sock1chan = (AFUNIXSocketChannel)socketPair.getSocket1();
            FileDescriptor sock2fd = ((AFUNIXSocketChannel)socketPair.getSocket2()).getFileDescriptor();
            Assertions.assertTrue((boolean)sock1chan.isConnected());
            AFUNIXSocketChannel sock2chan = (AFUNIXSocketChannel)FileDescriptorCast.using((FileDescriptor)sock2fd).as(AFUNIXSocketChannel.class);
            Assertions.assertEquals((Object)sock2fd, (Object)sock2chan.getFileDescriptor());
            try {
                Assertions.assertTrue((boolean)sock2chan.isConnected());
            }
            catch (AssertionFailedError e) {
                if (TestUtil.isHaikuOS()) {
                    throw TestUtil.haikuBug18534(e);
                }
                throw e;
            }
            ByteBuffer bb = ByteBuffer.allocate(32);
            bb.putInt(305419896);
            bb.flip();
            sock1chan.write(bb);
            bb.clear();
            Assertions.assertEquals((int)4, (int)sock2chan.read(bb));
            bb.flip();
            Assertions.assertEquals((int)305419896, (int)bb.getInt());
        }
    }

    @Test
    public void testUnconnectedServerAsSocket() throws Exception {
        try (AFUNIXServerSocket ass = AFUNIXServerSocket.bindOn((AFUNIXSocketAddress)AFUNIXSocketAddress.ofNewTempFile(), (boolean)true);
             AFUNIXServerSocket ass2 = AFUNIXServerSocket.bindOn((AFUNIXSocketAddress)AFUNIXSocketAddress.ofNewTempFile(), (boolean)true);){
            FileDescriptor fd = ass.getFileDescriptor();
            Assertions.assertTrue((boolean)fd.valid());
            AFUNIXSocket sock = (AFUNIXSocket)FileDescriptorCast.using((FileDescriptor)fd).as(AFUNIXSocket.class);
            Assertions.assertTrue((boolean)sock.isBound());
            Assertions.assertFalse((boolean)sock.isConnected());
            sock.setSoTimeout(1);
            Assertions.assertThrows(SocketException.class, () -> {
                try {
                    sock.connect((SocketAddress)ass2.getLocalSocketAddress());
                }
                catch (SocketTimeoutException e) {
                    throw new SocketException().initCause(e);
                }
            });
            Assertions.assertThrows(SocketException.class, () -> {
                try {
                    sock.connect((SocketAddress)ass.getLocalSocketAddress());
                }
                catch (SocketTimeoutException e) {
                    throw new SocketException().initCause(e);
                }
            });
            Assertions.assertThrows(SocketException.class, () -> {
                try {
                    sock.getInputStream().read();
                }
                catch (SocketTimeoutException e) {
                    throw new SocketException().initCause(e);
                }
            });
            Assertions.assertNull((Object)sock.getRemoteSocketAddress());
            Assertions.assertFalse((boolean)sock.isConnected());
        }
    }

    @Test
    public void testServer() throws Exception {
        AFUNIXSocketAddress serverAddress = AFUNIXSocketAddress.ofNewTempFile();
        try (AFUNIXServerSocket ass = AFUNIXServerSocket.bindOn((AFUNIXSocketAddress)serverAddress, (boolean)true);
             AFUNIXSocket sock = AFUNIXSocket.connectTo((AFUNIXSocketAddress)serverAddress);){
            AFUNIXSocket sock1 = (AFUNIXSocket)FileDescriptorCast.using((FileDescriptor)sock.getFileDescriptor()).as(AFUNIXSocket.class);
            try {
                Assertions.assertEquals((Object)sock.isBound(), (Object)sock1.isBound());
                Assertions.assertEquals((Object)sock.isConnected(), (Object)sock1.isConnected());
                Assertions.assertTrue((boolean)sock1.isConnected());
            }
            catch (AssertionFailedError e) {
                if (TestUtil.isHaikuOS()) {
                    throw TestUtil.haikuBug18534(e);
                }
                throw e;
            }
            Assertions.assertEquals((Object)sock.getRemoteSocketAddress(), (Object)sock1.getRemoteSocketAddress());
            Assertions.assertEquals((Object)ass.getLocalSocketAddress(), (Object)sock.getRemoteSocketAddress());
            AFUNIXServerSocket serverSock = (AFUNIXServerSocket)FileDescriptorCast.using((FileDescriptor)ass.getFileDescriptor()).as(AFUNIXServerSocket.class);
            AFUNIXSocket sock0 = serverSock.accept();
            Assertions.assertEquals((Object)ass.getLocalSocketAddress(), (Object)sock0.getLocalSocketAddress());
            sock0.getOutputStream().write(23);
            Assertions.assertEquals((int)23, (int)sock1.getInputStream().read());
        }
    }

    @Test
    @AFSocketCapabilityRequirement(value={AFSocketCapability.CAPABILITY_UNIX_DATAGRAMS})
    public void testDatagramSocket() throws Exception {
        AFUNIXSocketAddress addr1 = AFUNIXSocketAddress.ofNewTempFile();
        AFUNIXSocketAddress addr2 = AFUNIXSocketAddress.ofNewTempFile();
        try (AFUNIXDatagramChannel dc1 = AFUNIXDatagramChannel.open();
             AFUNIXDatagramChannel dc2 = AFUNIXDatagramChannel.open();){
            dc1.setDeleteOnClose(true);
            dc2.setDeleteOnClose(true);
            ByteBuffer bb = ByteBuffer.allocate(32);
            bb.putInt(1234);
            bb.flip();
            dc1.getOption(StandardSocketOptions.SO_SNDBUF);
            AFUNIXDatagramChannel dc1c = (AFUNIXDatagramChannel)FileDescriptorCast.using((FileDescriptor)dc1.getFileDescriptor()).as(AFUNIXDatagramChannel.class);
            AFUNIXDatagramChannel dc2c = (AFUNIXDatagramChannel)FileDescriptorCast.using((FileDescriptor)dc2.getFileDescriptor()).as(AFUNIXDatagramChannel.class);
            Assertions.assertFalse((boolean)dc1.isBound());
            Assertions.assertFalse((boolean)dc1c.isBound());
            Assertions.assertFalse((boolean)dc2.isBound());
            Assertions.assertFalse((boolean)dc2c.isBound());
            dc1.bind((SocketAddress)addr1);
            dc2.bind((SocketAddress)addr2);
            Assertions.assertTrue((boolean)dc1.isBound());
            Assertions.assertTrue((boolean)dc1c.isBound());
            Assertions.assertTrue((boolean)dc2.isBound());
            Assertions.assertTrue((boolean)dc2c.isBound());
            Assertions.assertEquals((Object)dc1.getLocalAddress(), (Object)dc1c.getLocalAddress());
            Assertions.assertEquals((Object)dc2.getLocalAddress(), (Object)dc2c.getLocalAddress());
            dc1c.connect((SocketAddress)addr2);
            dc2c.connect((SocketAddress)addr1);
            Assertions.assertTrue((boolean)dc1c.isConnected());
            Assertions.assertEquals((int)4, (int)dc1c.write(bb));
            bb.clear();
            Assertions.assertEquals((int)4, (int)dc2c.read(bb));
            bb.flip();
            Assertions.assertEquals((int)1234, (int)bb.getInt());
            try {
                Assertions.assertTrue((boolean)dc1.isConnected());
                Assertions.assertEquals((Object)dc1.getLocalAddress(), (Object)dc2c.getRemoteAddress());
                Assertions.assertEquals((Object)dc1.getRemoteAddress(), (Object)dc2c.getLocalAddress());
                Assertions.assertEquals((Object)dc1c.getLocalAddress(), (Object)dc2.getRemoteAddress());
                Assertions.assertEquals((Object)dc1c.getRemoteAddress(), (Object)dc2.getLocalAddress());
            }
            catch (AssertionFailedError e) {
                if (TestUtil.isHaikuOS()) {
                    throw TestUtil.haikuBug18534(e);
                }
                throw e;
            }
        }
    }

    @Test
    @SuppressFBWarnings(value={"DCN_NULLPOINTER_EXCEPTION"})
    public void testSocketPorts() throws Exception {
        AFUNIXSocketAddress addr = AFUNIXSocketAddress.ofNewTempPath((int)123);
        try (AFUNIXServerSocket ass = AFUNIXServerSocket.bindOn((AFUNIXSocketAddress)addr);){
            Assertions.assertEquals((int)123, (int)ass.getLocalPort());
            AFUNIXServerSocket ass1 = (AFUNIXServerSocket)FileDescriptorCast.using((FileDescriptor)ass.getFileDescriptor()).withLocalPort(123).as(AFUNIXServerSocket.class);
            Assertions.assertEquals((int)123, (int)ass.getLocalPort());
            try (AFUNIXSocket socket = AFUNIXSocket.connectTo((AFUNIXSocketAddress)addr);){
                AFUNIXSocketAddress rsa = (AFUNIXSocketAddress)socket.getRemoteSocketAddress();
                try {
                    Objects.requireNonNull(rsa);
                }
                catch (NullPointerException e) {
                    if (TestUtil.isHaikuOS()) {
                        throw TestUtil.haikuBug18534(e);
                    }
                    throw e;
                }
                Assertions.assertEquals((int)123, (int)rsa.getPort());
                AFUNIXSocket socket1 = (AFUNIXSocket)FileDescriptorCast.using((FileDescriptor)socket.getFileDescriptor()).withRemotePort(123).as(AFUNIXSocket.class);
                Assertions.assertEquals((Object)socket.getRemoteSocketAddress(), (Object)socket1.getRemoteSocketAddress());
                Assertions.assertEquals((int)123, (int)((AFUNIXSocketAddress)socket1.getRemoteSocketAddress()).getPort());
                AFUNIXSocket ss = ass1.accept();
                Assertions.assertEquals((int)123, (int)ss.getLocalPort());
                Assertions.assertEquals((int)123, (int)((AFUNIXSocketAddress)ss.getLocalSocketAddress()).getPort());
            }
        }
    }

    private int getPort(AFSocketAddress addr) {
        if (addr == null) {
            return -1;
        }
        return addr.getPort();
    }

    @Test
    @AFSocketCapabilityRequirement(value={AFSocketCapability.CAPABILITY_UNIX_DATAGRAMS})
    public void testDatagramPorts() throws Exception {
        AFUNIXSocketAddress addr = AFUNIXSocketAddress.ofNewTempPath((int)123);
        Assertions.assertEquals((int)123, (int)addr.getPort());
        try (AFUNIXDatagramChannel dc1 = AFUNIXDatagramChannel.open();
             AFUNIXDatagramChannel dc2 = AFUNIXDatagramChannel.open();){
            int remotePort;
            dc1.setDeleteOnClose(true);
            dc2.setDeleteOnClose(true);
            Assertions.assertNull((Object)dc1.getLocalAddress());
            Assertions.assertNull((Object)dc1.getRemoteAddress());
            Assertions.assertNull((Object)dc2.getLocalAddress());
            Assertions.assertNull((Object)dc2.getRemoteAddress());
            dc1.bind((SocketAddress)addr);
            dc2.connect((SocketAddress)addr);
            try {
                Assertions.assertEquals((Object)dc1.getLocalAddress(), (Object)dc2.getRemoteAddress());
            }
            catch (AssertionFailedError e) {
                if (TestUtil.isHaikuOS() && dc2.getRemoteAddress() == null) {
                    throw TestUtil.haikuBug18534(e);
                }
                throw e;
            }
            Assertions.assertEquals((int)123, (int)this.getPort(dc1.getLocalAddress()));
            AFUNIXDatagramChannel dc1c = (AFUNIXDatagramChannel)FileDescriptorCast.using((FileDescriptor)dc1.getFileDescriptor()).as(AFUNIXDatagramChannel.class);
            AFUNIXDatagramChannel dc2c = (AFUNIXDatagramChannel)FileDescriptorCast.using((FileDescriptor)dc2.getFileDescriptor()).as(AFUNIXDatagramChannel.class);
            Assertions.assertEquals((int)0, (int)this.getPort(dc1c.getLocalAddress()));
            Assertions.assertEquals((int)0, (int)this.getPort(dc2c.getRemoteAddress()));
            dc1c = (AFUNIXDatagramChannel)FileDescriptorCast.using((FileDescriptor)dc1.getFileDescriptor()).withLocalPort(123).as(AFUNIXDatagramChannel.class);
            dc2c = (AFUNIXDatagramChannel)FileDescriptorCast.using((FileDescriptor)dc2.getFileDescriptor()).withRemotePort(123).as(AFUNIXDatagramChannel.class);
            if (dc1c.getLocalAddress() != null) {
                Assertions.assertEquals((int)123, (int)this.getPort(dc1c.getLocalAddress()));
            }
            if ((remotePort = this.getPort(dc2c.getRemoteAddress())) == -1) {
                Assertions.assertNull((Object)dc2c.getRemoteAddress());
            } else {
                Assertions.assertEquals((int)123, (int)remotePort);
            }
        }
    }

    @Test
    @AFSocketCapabilityRequirement(value={AFSocketCapability.CAPABILITY_UNIX_DATAGRAMS})
    public void testDatagramFileChannel() throws Exception {
        AFUNIXSocketAddress addr = AFUNIXSocketAddress.ofNewTempPath((int)123);
        try (AFUNIXDatagramChannel dc1 = AFUNIXDatagramChannel.open();
             AFUNIXDatagramChannel dc2 = AFUNIXDatagramChannel.open();){
            dc1.setDeleteOnClose(true);
            dc2.setDeleteOnClose(true);
            dc1.bind((SocketAddress)addr);
            dc2.connect((SocketAddress)addr);
            FileDescriptorCast fdc1 = FileDescriptorCast.using((FileDescriptor)dc1.getFileDescriptor());
            Assertions.assertTrue((boolean)fdc1.isAvailable(DatagramChannel.class));
            Assertions.assertTrue((boolean)fdc1.isAvailable(AFUNIXDatagramChannel.class));
            Assertions.assertTrue((boolean)fdc1.isAvailable(FileChannel.class));
            Assertions.assertTrue((boolean)fdc1.availableTypes().contains(ReadableByteChannel.class));
            Assertions.assertTrue((boolean)fdc1.availableTypes().contains(WritableByteChannel.class));
            FileChannel fc = (FileChannel)fdc1.as(FileChannel.class);
            ByteBuffer bb = ByteBuffer.allocate(4);
            bb.putInt(305419896);
            bb.flip();
            dc2.write(bb);
            bb.clear();
            Assertions.assertEquals((int)4, (int)fc.read(bb));
            bb.flip();
            Assertions.assertEquals((int)305419896, (int)bb.getInt());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @AFSocketCapabilityRequirement(value={AFSocketCapability.CAPABILITY_FD_AS_REDIRECT})
    @ProcessUtilRequirement(canGetJavaCommandArguments=true)
    public void testForkedVMRedirectStdin() throws Exception {
        AFUNIXSocketAddress addr = AFUNIXSocketAddress.ofNewTempFile();
        try (AFUNIXServerSocket serverSocket = AFUNIXServerSocket.bindOn((AFUNIXSocketAddress)addr);
             AFUNIXSocket clientConn = AFUNIXSocket.connectTo((AFUNIXSocketAddress)addr);
             AFUNIXSocket serverConn = serverSocket.accept();){
            Object processObject;
            Assertions.assertTrue((boolean)addr.getFile().delete());
            ForkedVM vm = new ForkedVM(StdinSocketApp.class);
            vm.setRedirectInput((ProcessBuilder.Redirect)FileDescriptorCast.using((FileDescriptor)clientConn.getFileDescriptor()).as(ProcessBuilder.Redirect.class));
            vm.setRedirectError(ProcessBuilder.Redirect.INHERIT);
            CompletableFuture<Object> cf = CompletableFuture.supplyAsync(() -> {
                try {
                    return vm.fork();
                }
                catch (IOException | UnsupportedOperationException e) {
                    return e;
                }
            });
            try {
                processObject = cf.get(10L, TimeUnit.SECONDS);
            }
            catch (Exception e) {
                throw new TestAbortedWithImportantMessageException(TestAbortedWithImportantMessageException.MessageType.TEST_ABORTED_INFORMATIONAL, "Environment may not support forking new processes, which one test requires", (Throwable)e);
            }
            if (!(processObject instanceof Process)) {
                if (processObject instanceof Exception) {
                    throw (Exception)processObject;
                }
                if (processObject instanceof Throwable) {
                    throw new TestAbortedWithImportantMessageException(TestAbortedWithImportantMessageException.MessageType.TEST_ABORTED_INFORMATIONAL, "Environment may not support forking new processes, which one test requires", (Throwable)processObject);
                }
                throw new TestAbortedWithImportantMessageException(TestAbortedWithImportantMessageException.MessageType.TEST_ABORTED_INFORMATIONAL, "Environment may not support forking new processes, which one test requires");
            }
            Process p = (Process)processObject;
            try {
                long elapsed;
                try (BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)serverConn.getInputStream(), StandardCharsets.UTF_8));){
                    Assertions.assertEquals((Object)"Hello world", (Object)br.readLine());
                    String l = br.readLine();
                    if (l != null) {
                        Assertions.fail((String)("Unexpected output: " + l));
                    }
                }
                long time = System.currentTimeMillis();
                while ((elapsed = System.currentTimeMillis() - time) < 30000L && !p.waitFor(1L, TimeUnit.SECONDS)) {
                    if (elapsed <= 5000L) continue;
                    System.out.println("Still waiting for process to terminate: " + String.valueOf(p));
                }
                Assertions.assertEquals((int)0, (int)p.exitValue());
            }
            finally {
                p.destroyForcibly();
            }
        }
    }
}

