/*
 * Decompiled with CFR 0.152.
 */
package org.newsclub.net.unix.vsock;

import com.kohlschutter.testutil.TestAbortedWithImportantMessageException;
import java.io.Closeable;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.nio.channels.DatagramChannel;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import org.newsclub.net.unix.AFDatagramSocket;
import org.newsclub.net.unix.AFSelectorProvider;
import org.newsclub.net.unix.AFServerSocket;
import org.newsclub.net.unix.AFSocket;
import org.newsclub.net.unix.AFSocketAddress;
import org.newsclub.net.unix.AFVSOCKSocketAddress;
import org.newsclub.net.unix.AddressSpecifics;
import org.newsclub.net.unix.AddressUnavailableSocketException;
import org.newsclub.net.unix.CloseablePair;
import org.newsclub.net.unix.InvalidSocketException;
import org.newsclub.net.unix.vsock.AFVSOCKDatagramSocket;
import org.newsclub.net.unix.vsock.AFVSOCKSelectorProvider;
import org.newsclub.net.unix.vsock.AFVSOCKServerSocket;
import org.newsclub.net.unix.vsock.AFVSOCKSocket;
import org.newsclub.net.unix.vsock.AFVSOCKSocketPair;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public final class AFVSOCKAddressSpecifics
implements AddressSpecifics<AFVSOCKSocketAddress> {
    public static final AddressSpecifics<AFVSOCKSocketAddress> INSTANCE = new AFVSOCKAddressSpecifics();
    static final String KERNEL_NOT_CONFIGURED = "Kernel may be too old or not configured for full VSOCK support";
    static final String ACCESS_DENIED = "Access to VSOCK resources (e.g., /dev/vsock) were denied";

    private AFVSOCKAddressSpecifics() {
    }

    public AFSocketAddress newTempAddress() throws IOException {
        return AFVSOCKSocketAddress.ofAnyLocalPort();
    }

    public AFSocket<?> newSocket() throws IOException {
        return AFVSOCKSocket.newInstance();
    }

    public AFSocket<?> newStrictSocket() throws IOException {
        return AFVSOCKSocket.newStrictInstance();
    }

    public AFDatagramSocket<?> newDatagramSocket() throws IOException {
        return AFVSOCKDatagramSocket.newInstance();
    }

    @Override
    public DatagramChannel newDatagramChannel() throws IOException {
        return AFVSOCKDatagramSocket.newInstance().getChannel();
    }

    public AFServerSocket<?> newServerSocket() throws IOException {
        return AFVSOCKServerSocket.newInstance();
    }

    public AFSocketAddress newTempAddressForDatagram() throws IOException {
        return AFVSOCKSocketAddress.ofAnyPort();
    }

    public AFSocketAddress unwrap(InetAddress addr, int port) throws SocketException {
        return AFVSOCKSocketAddress.unwrap((InetAddress)addr, (int)port);
    }

    public AFSelectorProvider<?> selectorProvider() {
        return AFVSOCKSelectorProvider.provider();
    }

    @Override
    public CloseablePair<? extends SocketChannel> newSocketPair() throws IOException {
        try {
            return AFVSOCKSocketPair.open();
        }
        catch (SocketException e) {
            throw AFVSOCKAddressSpecifics.handleSocketException(e, "");
        }
    }

    @Override
    public CloseablePair<? extends DatagramChannel> newDatagramSocketPair() throws IOException {
        try {
            return AFVSOCKSocketPair.openDatagram();
        }
        catch (SocketException e) {
            throw AFVSOCKAddressSpecifics.handleSocketException(e, "");
        }
    }

    public AFServerSocket<?> newServerSocketBindOn(SocketAddress addr) throws IOException {
        try {
            return AFVSOCKServerSocket.bindOn((AFVSOCKSocketAddress)((AFVSOCKSocketAddress)addr));
        }
        catch (SocketException e) {
            throw AFVSOCKAddressSpecifics.handleSocketException(e, addr);
        }
    }

    private static SocketException handleSocketException(SocketException e, String msg) throws SocketException, IOException {
        String shortMsg;
        if (e instanceof AddressUnavailableSocketException) {
            shortMsg = ACCESS_DENIED;
        } else if (e instanceof InvalidSocketException) {
            shortMsg = KERNEL_NOT_CONFIGURED;
        } else {
            return e;
        }
        String message = msg == null || msg.isEmpty() ? shortMsg : shortMsg + ": " + msg;
        throw new TestAbortedWithImportantMessageException(TestAbortedWithImportantMessageException.MessageType.TEST_ABORTED_SHORT_INFORMATIONAL, message, AFVSOCKAddressSpecifics.summaryImportantMessage0(), (Throwable)e);
    }

    private static SocketException handleSocketException(SocketException e, SocketAddress addr) throws IOException {
        if (!(addr instanceof AFVSOCKSocketAddress)) {
            return e;
        }
        AFVSOCKSocketAddress sa = (AFVSOCKSocketAddress)addr;
        switch (sa.getVSOCKCID()) {
            case 2: {
                return AFVSOCKAddressSpecifics.handleSocketException(e, "Cannot connect to addresses with CID=" + sa.getVSOCKCID());
            }
            case 1: {
                return AFVSOCKAddressSpecifics.handleSocketException(e, "Cannot connect to addresses with CID=" + sa.getVSOCKCID() + "; try \"modprobe vsock_loopback\"");
            }
        }
        if (e instanceof InvalidSocketException) {
            return AFVSOCKAddressSpecifics.handleSocketException(e, "Cannot connect to addresses with CID=" + sa.getVSOCKCID() + "; try \"modprobe vsock_loopback\"");
        }
        return e;
    }

    @Override
    public void bindServerSocket(ServerSocket serverSocket, SocketAddress bindpoint) throws IOException {
        try {
            serverSocket.bind(bindpoint);
        }
        catch (SocketException e) {
            throw AFVSOCKAddressSpecifics.handleSocketException(e, bindpoint);
        }
    }

    @Override
    public void bindServerSocket(ServerSocket serverSocket, SocketAddress bindpoint, int backlog) throws IOException {
        try {
            serverSocket.bind(bindpoint, backlog);
        }
        catch (SocketException e) {
            throw AFVSOCKAddressSpecifics.handleSocketException(e, bindpoint);
        }
    }

    @Override
    public void bindServerSocket(ServerSocketChannel serverSocketChannel, SocketAddress bindpoint) throws IOException {
        try {
            serverSocketChannel.bind(bindpoint);
        }
        catch (SocketException e) {
            throw AFVSOCKAddressSpecifics.handleSocketException(e, bindpoint);
        }
    }

    @Override
    public void bindServerSocket(ServerSocketChannel serverSocketChannel, SocketAddress bindpoint, int backlog) throws IOException {
        try {
            serverSocketChannel.bind(bindpoint, backlog);
        }
        catch (SocketException e) {
            throw AFVSOCKAddressSpecifics.handleSocketException(e, bindpoint);
        }
    }

    @Override
    public Socket connectTo(SocketAddress addr) throws IOException {
        AFVSOCKSocketAddress sa = (AFVSOCKSocketAddress)addr;
        try {
            return AFVSOCKSocket.connectTo((AFVSOCKSocketAddress)sa);
        }
        catch (SocketException e) {
            throw AFVSOCKAddressSpecifics.handleSocketException(e, (SocketAddress)sa);
        }
    }

    @Override
    public void connectSocket(Socket sock, SocketAddress addr) throws IOException {
        try {
            sock.connect(addr);
        }
        catch (SocketException e) {
            throw AFVSOCKAddressSpecifics.handleSocketException(e, addr);
        }
    }

    @Override
    public boolean connectSocket(SocketChannel sock, SocketAddress addr) throws IOException {
        try {
            return sock.connect(addr);
        }
        catch (SocketException e) {
            throw AFVSOCKAddressSpecifics.handleSocketException(e, addr);
        }
    }

    public AFServerSocket<?> newServerSocketBindOn(SocketAddress addr, boolean deleteOnClose) throws IOException {
        try {
            return AFVSOCKServerSocket.bindOn((AFVSOCKSocketAddress)((AFVSOCKSocketAddress)addr), (boolean)deleteOnClose);
        }
        catch (SocketException e) {
            throw AFVSOCKAddressSpecifics.handleSocketException(e, addr);
        }
    }

    @Override
    public CloseablePair<? extends Socket> newInterconnectedSockets() throws IOException {
        CloseablePair<? extends SocketChannel> sp = this.newSocketPair();
        return new CloseablePair((Closeable)((SocketChannel)sp.getFirst()).socket(), (Closeable)((SocketChannel)sp.getSecond()).socket());
    }

    @Override
    public String addressFamilyString() {
        return "AF_VSOCK";
    }

    @Override
    public String summaryImportantMessage(String message) {
        return AFVSOCKAddressSpecifics.summaryImportantMessage0();
    }

    private static String summaryImportantMessage0() {
        return "Environment may not be configured for VSOCK. More information at https://kohlschutter.github.io/junixsocket/junixsocket-vsock/";
    }
}

