/*
 * Decompiled with CFR 0.152.
 */
package org.newsclub.net.unix.vsock;

import com.kohlschutter.annotations.compiletime.SuppressFBWarnings;
import com.kohlschutter.testutil.TestAbortedWithImportantMessageException;
import java.io.IOException;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import org.newsclub.net.unix.AFSocketCapability;
import org.newsclub.net.unix.AFSocketCapabilityRequirement;
import org.newsclub.net.unix.AFVSOCKSocketAddress;
import org.newsclub.net.unix.InvalidSocketException;
import org.newsclub.net.unix.vsock.AFVSOCKAddressSpecifics;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
@AFSocketCapabilityRequirement(value={AFSocketCapability.CAPABILITY_VSOCK})
@SuppressFBWarnings(value={"NM_SAME_SIMPLE_NAME_AS_SUPERCLASS"})
public final class SocketChannelTest
extends org.newsclub.net.unix.SocketChannelTest<AFVSOCKSocketAddress> {
    public SocketChannelTest() {
        super(AFVSOCKAddressSpecifics.INSTANCE);
    }

    @Override
    protected String checkKnownBugAcceptFailure(SocketException e) {
        if (e instanceof InvalidSocketException) {
            return "Server accept failed. VSOCK may not be available";
        }
        return null;
    }

    @Override
    protected String checkKnownBugAcceptFailure(SocketTimeoutException e) {
        return "Server accept failed. VSOCK may not be available";
    }

    @Override
    protected String checkKnownBugFirstAcceptCallNotTerminated() {
        return "Kernel may be too old or not configured for full VSOCK support";
    }

    @Override
    protected void handleBind(ServerSocketChannel ssc, SocketAddress sa) throws IOException {
        try {
            super.handleBind(ssc, sa);
        }
        catch (InvalidSocketException e) {
            String msg = "Could not bind AF_VSOCK server socket to CID=" + ((AFVSOCKSocketAddress)sa).getVSOCKCID() + "; check kernel capabilities.";
            throw (TestAbortedWithImportantMessageException)new TestAbortedWithImportantMessageException(TestAbortedWithImportantMessageException.MessageType.TEST_ABORTED_SHORT_WITH_ISSUES, msg, this.summaryImportantMessage(msg)).initCause((Throwable)e);
        }
    }

    @Override
    protected boolean handleConnect(SocketChannel sc, SocketAddress sa) throws IOException {
        try {
            return super.handleConnect(sc, sa);
        }
        catch (InvalidSocketException e) {
            String msg = "Could not connect AF_VSOCK socket to CID=" + ((AFVSOCKSocketAddress)sa).getVSOCKCID() + "; check kernel capabilities.";
            throw (TestAbortedWithImportantMessageException)new TestAbortedWithImportantMessageException(TestAbortedWithImportantMessageException.MessageType.TEST_ABORTED_SHORT_WITH_ISSUES, msg, this.summaryImportantMessage(msg)).initCause((Throwable)e);
        }
    }
}

