/*
 * Decompiled with CFR 0.152.
 */
package org.newsclub.net.unix;

import com.kohlschutter.util.ExecutionEnvironmentUtil;
import java.util.Map;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.newsclub.net.unix.BuildProperties;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class BuildPropertiesTest {
    @Test
    public void testNotEmpty() throws Exception {
        Map properties = BuildProperties.getBuildProperties();
        Assertions.assertNotEquals((int)0, (int)properties.size());
    }

    @Test
    public void testHasProperties() throws Exception {
        Map properties = BuildProperties.getBuildProperties();
        Assertions.assertTrue((boolean)properties.containsKey("project.version"));
        Assertions.assertTrue((boolean)properties.containsKey("git.commit.id.full"));
    }

    @Test
    public void testResolved() throws Exception {
        Map properties = BuildProperties.getBuildProperties();
        String projectVersion = (String)properties.get("project.version");
        if (ExecutionEnvironmentUtil.isInEclipse()) {
            Assertions.assertEquals((Object)"${project.version}", (Object)projectVersion);
        } else {
            Assertions.assertNotEquals((Object)"", (Object)projectVersion);
            Assertions.assertNotEquals((Object)"${project.version}", (Object)projectVersion);
        }
    }
}

