/*
 * Decompiled with CFR 0.152.
 */
package org.newsclub.net.unix;

import com.kohlschutter.annotations.compiletime.SuppressFBWarnings;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;
import java.nio.channels.SocketChannel;
import java.util.Objects;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.newsclub.net.unix.AFSocketAddress;
import org.newsclub.net.unix.AFSocketCapability;
import org.newsclub.net.unix.AFSocketCapabilityRequirement;
import org.newsclub.net.unix.AFUNIXDatagramChannel;
import org.newsclub.net.unix.AFUNIXSocketAddress;
import org.newsclub.net.unix.AFUNIXSocketChannel;
import org.newsclub.net.unix.AddressSpecifics;
import org.newsclub.net.unix.CloseablePair;
import org.newsclub.net.unix.SocketTestBase;
import org.newsclub.net.unix.TestUtil;
import org.opentest4j.AssertionFailedError;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
@SuppressFBWarnings(value={"THROWS_METHOD_THROWS_CLAUSE_THROWABLE", "THROWS_METHOD_THROWS_CLAUSE_BASIC_EXCEPTION"})
public abstract class SocketPairTest<A extends SocketAddress>
extends SocketTestBase<A> {
    protected SocketPairTest(AddressSpecifics<A> asp) {
        super(asp);
    }

    private static void assertCovered(SocketAddress addr, SocketAddress covered) {
        if (addr instanceof AFSocketAddress && covered instanceof AFSocketAddress) {
            SocketPairTest.assertCovered((AFSocketAddress)addr, (AFSocketAddress)covered);
        } else {
            Assertions.assertEquals((Object)addr, (Object)covered);
        }
    }

    private static void assertCovered(AFSocketAddress addr, AFSocketAddress covered) {
        if (!addr.covers(covered)) {
            Assertions.fail((String)("Address not covered by " + addr + ": " + covered));
        }
    }

    @Test
    public void testSocketPair() throws Exception {
        CloseablePair<SocketChannel> pair = this.newSocketPair();
        SocketChannel sc1 = (SocketChannel)pair.getFirst();
        SocketChannel sc2 = (SocketChannel)pair.getSecond();
        Objects.requireNonNull(sc1);
        Objects.requireNonNull(sc2);
        Assertions.assertTrue((boolean)sc1.isConnected());
        Assertions.assertTrue((boolean)sc2.isConnected());
        Assertions.assertNotEquals((Object)pair.getFirst(), (Object)pair.getSecond());
        Assertions.assertNotEquals((Object)((SocketChannel)pair.getFirst()).socket(), (Object)((SocketChannel)pair.getSecond()).socket());
        if (sc1 instanceof AFUNIXSocketChannel) {
            Assertions.assertEquals((Object)((AFUNIXSocketChannel)sc1).getPeerCredentials(), (Object)((AFUNIXSocketChannel)sc2).getPeerCredentials());
        }
        ByteBuffer bb = ByteBuffer.allocate(4096);
        bb.putInt(67305985);
        bb.flip();
        sc1.write(bb);
        ByteBuffer bb2 = ByteBuffer.allocate(4096);
        sc2.read(bb2);
        bb2.flip();
        Assertions.assertEquals((int)67305985, (int)bb2.getInt());
        if (this.getServerBindAddress() instanceof AFUNIXSocketAddress && ((SocketChannel)pair.getFirst()).getLocalAddress() == null && ((SocketChannel)pair.getSecond()).getLocalAddress() == null && ((SocketChannel)pair.getFirst()).getRemoteAddress() == null && ((SocketChannel)pair.getSecond()).getRemoteAddress() == null) {
            return;
        }
        try {
            SocketPairTest.assertCovered(((SocketChannel)pair.getFirst()).getLocalAddress(), ((SocketChannel)pair.getSecond()).getRemoteAddress());
            SocketPairTest.assertCovered(((SocketChannel)pair.getSecond()).getLocalAddress(), ((SocketChannel)pair.getFirst()).getRemoteAddress());
        }
        catch (AssertionFailedError e) {
            if (TestUtil.isHaikuOS()) {
                throw TestUtil.haikuBug18534(e);
            }
            throw e;
        }
    }

    @Test
    @AFSocketCapabilityRequirement(value={AFSocketCapability.CAPABILITY_UNIX_DATAGRAMS})
    public void testDatagramPair() throws Exception {
        CloseablePair<DatagramChannel> pair = this.newDatagramSocketPair();
        DatagramChannel sc1 = (DatagramChannel)pair.getFirst();
        DatagramChannel sc2 = (DatagramChannel)pair.getSecond();
        Objects.requireNonNull(sc1);
        Objects.requireNonNull(sc2);
        Assertions.assertTrue((boolean)sc1.isConnected());
        Assertions.assertTrue((boolean)sc2.isConnected());
        Assertions.assertNotEquals((Object)pair.getFirst(), (Object)pair.getSecond());
        Assertions.assertNotEquals((Object)((DatagramChannel)pair.getFirst()).socket(), (Object)((DatagramChannel)pair.getSecond()).socket());
        if (sc1 instanceof AFUNIXDatagramChannel) {
            Assertions.assertEquals((Object)((AFUNIXDatagramChannel)sc1).getPeerCredentials(), (Object)((AFUNIXDatagramChannel)sc2).getPeerCredentials());
        }
        ByteBuffer bb = ByteBuffer.allocate(4096);
        bb.putInt(67305985);
        bb.flip();
        sc1.write(bb);
        ByteBuffer bb2 = ByteBuffer.allocate(4096);
        sc2.read(bb2);
        bb2.flip();
        Assertions.assertEquals((int)67305985, (int)bb2.getInt());
        if (this.getServerBindAddress() instanceof AFUNIXSocketAddress && ((DatagramChannel)pair.getFirst()).getLocalAddress() == null && ((DatagramChannel)pair.getSecond()).getLocalAddress() == null && ((DatagramChannel)pair.getFirst()).getRemoteAddress() == null && ((DatagramChannel)pair.getSecond()).getRemoteAddress() == null) {
            return;
        }
        try {
            SocketPairTest.assertCovered(((DatagramChannel)pair.getFirst()).getLocalAddress(), ((DatagramChannel)pair.getSecond()).getRemoteAddress());
            SocketPairTest.assertCovered(((DatagramChannel)pair.getSecond()).getLocalAddress(), ((DatagramChannel)pair.getFirst()).getRemoteAddress());
        }
        catch (AssertionFailedError e) {
            if (TestUtil.isHaikuOS()) {
                throw TestUtil.haikuBug18534(e);
            }
            throw e;
        }
    }
}

