/*
 * Decompiled with CFR 0.152.
 */
package org.newsclub.net.unix.ssl;

import com.google.errorprone.annotations.Immutable;
import com.kohlschutter.annotations.compiletime.SuppressFBWarnings;
import com.kohlschutter.testutil.LoggerUtil;
import com.kohlschutter.testutil.TestAbortedNotAnIssueException;
import com.kohlschutter.util.ReflectionUtil;
import java.io.FileNotFoundException;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.Security;
import java.util.function.Supplier;
import javax.net.ssl.SSLContext;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Named;
import org.newsclub.net.unix.AFSocket;
import org.newsclub.net.unix.ssl.SSLContextBuilder;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public abstract class SSLTestBase {
    static final Class<? extends Throwable> BOUNCYCASTLE_TLS_EXCEPTION = ReflectionUtil.throwableByNameForAssertion((String)"org.bouncycastle.tls.TlsException");
    private static final String SYSTEM_PROVIDER_NAME = new Supplier<String>(){

        @Override
        public String get() {
            SSLTestBase.removeAllConfigurableProviders();
            try {
                return TestSSLConfiguration.SYSTEM.name() + " (" + SSLContext.getDefault().getProvider().getName() + ")";
            }
            catch (NoSuchAlgorithmException e) {
                return TestSSLConfiguration.SYSTEM.name() + " (" + e.getMessage() + ")";
            }
        }
    }.get();
    private static final Provider PROVIDER_BOUNCYCASTLE_JCE = (Provider)ReflectionUtil.instantiateIfPossible(Provider.class, (String)"org.bouncycastle.jce.provider.BouncyCastleProvider", (Object[])new Object[0]);
    private static final Provider PROVIDER_BOUNCYCASTLE_JSSE = (Provider)ReflectionUtil.instantiateIfPossible(Provider.class, (String)"org.bouncycastle.jsse.provider.BouncyCastleJsseProvider", (Object[])new Object[0]);
    private static final Provider PROVIDER_BOUNCYCASTLE_JSSE_FIPS = (Provider)ReflectionUtil.instantiateIfPossible(Provider.class, (String)"org.bouncycastle.jsse.provider.BouncyCastleJsseProvider", (Object[])new Object[]{true});
    private static final Provider PROVIDER_IAIK_JCE = (Provider)ReflectionUtil.instantiateIfPossible(Provider.class, (String)"iaik.security.provider.IAIK", (Object[])new Object[0]);
    private static final Provider PROVIDER_IAIK_JSSE = (Provider)ReflectionUtil.instantiateIfPossible(Provider.class, (String)"iaik.security.jsse.provider.IAIKJSSEProvider", (Object[])new Object[0]);
    private static final Provider PROVIDER_OPENJSSE = (Provider)ReflectionUtil.instantiateIfPossible(Provider.class, (String)"org.openjsse.net.ssl.OpenJSSE", (Object[])new Object[0]);
    private static final Provider PROVIDER_CONSCRYPT = (Provider)ReflectionUtil.singletonIfPossible(Provider.class, (String)"org.conscrypt.Conscrypt", (String)"newProvider");
    private static final Provider PROVIDER_WOLFSSL_JSSE = (Provider)ReflectionUtil.instantiateIfPossible(Provider.class, (String)"com.wolfssl.provider.jsse.WolfSSLProvider", (Object[])new Object[0]);
    private static final Provider PROVIDER_WOLFCRYPT_JCE = (Provider)ReflectionUtil.instantiateIfPossible(Provider.class, (String)"com.wolfssl.provider.jce.WolfCryptProvider", (Object[])new Object[0]);
    private static final String DEFAULT_PROVIDER_NAME = new Supplier<String>(){

        @Override
        public String get() {
            SSLTestBase.removeAllConfigurableProviders();
            try {
                if (PROVIDER_BOUNCYCASTLE_JSSE != null) {
                    if (AFSocket.isRunningOnAndroid()) {
                        return TestSSLConfiguration.DEFAULT.name() + " (" + PROVIDER_BOUNCYCASTLE_JSSE.getName() + ")";
                    }
                    return TestSSLConfiguration.DEFAULT.name() + " (" + SSLContext.getDefault().getProvider().getName() + " with BouncyCastle JSSE available)";
                }
                return TestSSLConfiguration.DEFAULT.name() + " (" + SSLContext.getDefault().getProvider().getName() + ")";
            }
            catch (NoSuchAlgorithmException e) {
                return TestSSLConfiguration.DEFAULT.name() + " (" + e.getMessage() + ")";
            }
        }
    }.get();

    SSLTestBase() {
    }

    static void removeAllConfigurableProviders() {
        SSLTestBase.removeProvider("BCJSSE", PROVIDER_BOUNCYCASTLE_JSSE);
        SSLTestBase.removeProvider("BC", PROVIDER_BOUNCYCASTLE_JCE);
        SSLTestBase.removeProvider("IAIK_JSSE", PROVIDER_IAIK_JSSE);
        SSLTestBase.removeProvider("IAIK", PROVIDER_IAIK_JCE);
        SSLTestBase.removeProvider("OpenJSSE", PROVIDER_OPENJSSE);
        SSLTestBase.removeProvider("wolfJSSE", PROVIDER_WOLFSSL_JSSE);
        SSLTestBase.removeProvider("wolfJCE", PROVIDER_WOLFCRYPT_JCE);
        SSLTestBase.removeProvider("Conscrypt", PROVIDER_CONSCRYPT);
    }

    private static void removeProvider(String name, Provider provider) {
        Provider p;
        if (provider == null) {
            return;
        }
        String providerName = provider.getName();
        if (!name.equals(providerName)) {
            System.err.println("WARNING: Unexpected provider name " + providerName + " for provider " + provider);
        }
        if ((p = Security.getProvider(providerName)) == provider) {
            Security.removeProvider(providerName);
        }
    }

    @BeforeAll
    public static void beforeAll() {
        LoggerUtil.overrideDefaultConfiguration(SSLTestBase.class, (String)"logging.properties");
    }

    @AfterAll
    public static void afterAll() {
        block2: {
            try {
                LoggerUtil.revertToDefaultConfiguration();
            }
            catch (IllegalStateException e) {
                if (e.getCause() instanceof FileNotFoundException) break block2;
                throw e;
            }
        }
        SSLTestBase.removeAllConfigurableProviders();
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    @SuppressFBWarnings(value={"SE_BAD_FIELD"})
    public static enum TestSSLConfiguration implements Named<TestSSLConfiguration>
    {
        DEFAULT(b -> {
            SSLTestBase.removeAllConfigurableProviders();
            return b;
        }, false),
        SYSTEM(b -> {
            SSLTestBase.removeAllConfigurableProviders();
            b.withProvider((Provider)null);
            return b;
        }, false),
        BOUNCYCASTLE_JCE(b -> {
            if (PROVIDER_BOUNCYCASTLE_JCE == null) {
                throw new TestAbortedNotAnIssueException("BouncyCastle JCE provider unvailable");
            }
            SSLTestBase.removeAllConfigurableProviders();
            Security.addProvider(PROVIDER_BOUNCYCASTLE_JCE);
            return b;
        }, false),
        BOUNCYCASTLE_JCE_AND_JSEE(b -> {
            if (PROVIDER_BOUNCYCASTLE_JCE == null) {
                throw new TestAbortedNotAnIssueException("BouncyCastle JCE provider unvailable");
            }
            if (PROVIDER_BOUNCYCASTLE_JSSE == null) {
                throw new TestAbortedNotAnIssueException("BouncyCastle JSSE provider unvailable");
            }
            SSLTestBase.removeAllConfigurableProviders();
            Security.addProvider(PROVIDER_BOUNCYCASTLE_JCE);
            Security.addProvider(PROVIDER_BOUNCYCASTLE_JSSE);
            b.withProvider(PROVIDER_BOUNCYCASTLE_JSSE);
            return b;
        }, false),
        BOUNCYCASTLE_JCE_AND_JSEE_FIPS(b -> {
            if (PROVIDER_BOUNCYCASTLE_JCE == null) {
                throw new TestAbortedNotAnIssueException("BouncyCastle JCE provider unvailable");
            }
            if (PROVIDER_BOUNCYCASTLE_JSSE_FIPS == null) {
                throw new TestAbortedNotAnIssueException("BouncyCastle JSSE provider unvailable");
            }
            SSLTestBase.removeAllConfigurableProviders();
            Security.addProvider(PROVIDER_BOUNCYCASTLE_JCE);
            Security.addProvider(PROVIDER_BOUNCYCASTLE_JSSE_FIPS);
            b.withProvider(PROVIDER_BOUNCYCASTLE_JSSE_FIPS);
            b.withKeyStoreSupplier(() -> KeyStore.getInstance("PKCS12", PROVIDER_BOUNCYCASTLE_JCE));
            return b;
        }, false),
        IAIK_JCE(b -> {
            if (PROVIDER_IAIK_JCE == null) {
                throw new TestAbortedNotAnIssueException("IAIK JCE provider unvailable");
            }
            SSLTestBase.removeAllConfigurableProviders();
            Security.insertProviderAt(PROVIDER_IAIK_JCE, 0);
            return b;
        }, false),
        IAIK_JCE_AND_JSSE(b -> {
            if (PROVIDER_IAIK_JCE == null) {
                throw new TestAbortedNotAnIssueException("IAIK JCE provider unvailable");
            }
            if (PROVIDER_IAIK_JSSE == null) {
                throw new TestAbortedNotAnIssueException("IAIK JSSE provider unvailable");
            }
            SSLTestBase.removeAllConfigurableProviders();
            Security.insertProviderAt(PROVIDER_IAIK_JCE, 0);
            Security.addProvider(PROVIDER_IAIK_JSSE);
            b.withProvider(PROVIDER_IAIK_JSSE);
            return b;
        }, false),
        OPENJSSE(b -> {
            if (PROVIDER_OPENJSSE == null) {
                throw new TestAbortedNotAnIssueException("OPENJSSE provider unvailable");
            }
            SSLTestBase.removeAllConfigurableProviders();
            Security.addProvider(PROVIDER_OPENJSSE);
            b.withProvider(PROVIDER_OPENJSSE);
            return b;
        }, false),
        WOLFCRYPT_WOLFSSL(b -> {
            if (PROVIDER_WOLFCRYPT_JCE == null) {
                throw new TestAbortedNotAnIssueException("Wolfcrypt JCE provider unvailable");
            }
            if (PROVIDER_WOLFSSL_JSSE == null) {
                throw new TestAbortedNotAnIssueException("WolfSSL JSSE provider unvailable");
            }
            SSLTestBase.removeAllConfigurableProviders();
            Security.addProvider(PROVIDER_WOLFCRYPT_JCE);
            Security.addProvider(PROVIDER_WOLFSSL_JSSE);
            b.withProvider(PROVIDER_WOLFSSL_JSSE);
            return b;
        }, false),
        CONSCRYPT(b -> {
            if (PROVIDER_CONSCRYPT == null) {
                throw new TestAbortedNotAnIssueException("Conscrypt provider unvailable");
            }
            SSLTestBase.removeAllConfigurableProviders();
            Security.addProvider(PROVIDER_CONSCRYPT);
            b.withProvider(PROVIDER_CONSCRYPT);
            return b;
        }, true);

        private final boolean sniBroken;
        private final TestSSLContextBuilderConfigurator builderConfigurator;

        private TestSSLConfiguration(TestSSLContextBuilderConfigurator configurator, boolean sniBroken) {
            this.builderConfigurator = configurator;
            this.sniBroken = sniBroken;
        }

        public String getName() {
            switch (this) {
                case DEFAULT: {
                    return DEFAULT_PROVIDER_NAME;
                }
                case SYSTEM: {
                    return SYSTEM_PROVIDER_NAME;
                }
            }
            return this.name();
        }

        public boolean isSniBroken() {
            return this.sniBroken;
        }

        public TestSSLConfiguration getPayload() {
            return this;
        }

        Exception handleException(Throwable e) throws Exception {
            if (this == SYSTEM && AFSocket.isRunningOnAndroid()) {
                throw new TestAbortedNotAnIssueException("Known to fail on Android", e);
            }
            if (e instanceof Error) {
                throw (Error)e;
            }
            throw (Exception)e;
        }

        SSLContextBuilder configure(SSLContextBuilder builder) throws Exception {
            return this.builderConfigurator.configure(builder);
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    @FunctionalInterface
    @Immutable
    public static interface TestSSLContextBuilderConfigurator {
        public SSLContextBuilder configure(SSLContextBuilder var1) throws Exception;
    }
}

