/*
 * Decompiled with CFR 0.152.
 */
package org.newsclub.net.unix.selftest;

import com.kohlschutter.annotations.compiletime.SuppressFBWarnings;
import com.kohlschutter.testutil.TestAbortedNotAnIssueException;
import com.kohlschutter.testutil.TestAbortedWithImportantMessageException;
import com.kohlschutter.util.ConsolePrintStream;
import com.kohlschutter.util.SystemPropertyUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.function.Supplier;
import org.junit.jupiter.engine.JupiterTestEngine;
import org.junit.jupiter.engine.discovery.DiscoverySelectorResolver;
import org.junit.platform.engine.TestExecutionResult;
import org.junit.platform.engine.support.descriptor.EngineDescriptor;
import org.junit.platform.engine.support.hierarchical.HierarchicalTestEngine;
import org.junit.platform.launcher.TestIdentifier;
import org.junit.platform.launcher.listeners.TestExecutionSummary;
import org.newsclub.lib.junixsocket.custom.NarMetadata;
import org.newsclub.net.unix.AFSocket;
import org.newsclub.net.unix.AFSocketCapability;
import org.newsclub.net.unix.AFUNIXSocket;
import org.newsclub.net.unix.selftest.SelftestExecutor;
import org.newsclub.net.unix.selftest.SelftestProvider;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class Selftest {
    private final Class<?> diagnosticsHelperClass = Selftest.resolveOptionalClass("org.newsclub.net.unix.SelftestDiagnosticsHelper");
    private final ConsolePrintStream out;
    private final Map<String, ModuleResult> results = new LinkedHashMap<String, ModuleResult>();
    private final List<AFSocketCapability> supportedCapabilites = new ArrayList<AFSocketCapability>();
    private final List<AFSocketCapability> unsupportedCapabilites = new ArrayList<AFSocketCapability>();
    private boolean withIssues = false;
    private boolean fail = false;
    private boolean modified = false;
    private boolean isSupportedAFUNIX = false;
    private final Set<String> important = new LinkedHashSet<String>();
    private boolean inconclusive = false;
    private final SelftestProvider sp;

    public Selftest(PrintStream out, SelftestProvider sp) {
        this.out = ConsolePrintStream.wrapPrintStream((PrintStream)out);
        this.sp = sp;
    }

    public void checkVM() {
        boolean isSubstrateVM = "Substrate VM".equals(System.getProperty("java.vm.name"));
        if (isSubstrateVM) {
            this.important.add("Substrate VM detected: Support for native-images is work in progress");
            if (!this.getSkipModeForModule("junixsocket-rmi").isDeclared()) {
                this.important.add("Auto-skipping junixsocket-rmi tests due to Substrate VM");
                System.setProperty("selftest.skip.junixsocket-rmi", "force_auto");
                this.withIssues = true;
            }
            if (!this.getSkipModeForClass("org.newsclub.net.unix.FileDescriptorCastTest").isDeclared()) {
                this.important.add("Auto-skipping FileDescriptorCastTest tests due to Substrate VM");
                System.setProperty("selftest.skip.FileDescriptorCastTest", "force_auto");
                this.withIssues = true;
            }
        } else if (!this.getSkipModeForModule("junixsocket-rmi").isDeclared()) {
            try {
                Class.forName("java.rmi.Remote");
            }
            catch (ClassNotFoundException e) {
                this.important.add("Auto-skipping junixsocket-rmi tests due to java.rmi.Remote class missing");
                System.setProperty("selftest.skip.junixsocket-rmi", "force_auto");
                this.withIssues = true;
            }
            if (!AFSocket.supports((AFSocketCapability)AFSocketCapability.CAPABILITY_LARGE_PORTS)) {
                this.important.add("Auto-skipping junixsocket-rmi tests due to missing CAPABILITY_LARGE_PORTS");
                System.setProperty("selftest.skip.junixsocket-rmi", "force_auto");
                this.withIssues = true;
            }
        }
    }

    @SuppressFBWarnings(value={"THROWS_METHOD_THROWS_CLAUSE_THROWABLE", "THROWS_METHOD_THROWS_CLAUSE_BASIC_EXCEPTION"})
    public static void main(String[] args) throws Exception {
        int delay = SystemPropertyUtil.getIntSystemProperty((String)"selftest.delay.at-start", (int)0);
        if (delay > 0) {
            System.out.println("Delaying execution of selftest by " + delay + " seconds");
            Thread.sleep(Duration.ofSeconds(delay).toMillis());
        }
        int rc = Selftest.runSelftest();
        if (SystemPropertyUtil.getBooleanSystemProperty((String)"selftest.wait.at-end", (boolean)false)) {
            System.gc();
            System.out.print("Press any key to end test. ");
            System.out.flush();
            System.in.read();
            System.out.println("RC=" + rc);
        }
        System.out.flush();
        System.exit(rc);
    }

    @SuppressFBWarnings(value={"THROWS_METHOD_THROWS_CLAUSE_THROWABLE", "THROWS_METHOD_THROWS_CLAUSE_BASIC_EXCEPTION"})
    public static int runSelftest() throws Exception {
        return Selftest.runSelftest(System.out);
    }

    private static void printStackTrace(Throwable t) {
        t.printStackTrace();
    }

    public static int runSelftest(final Writer out) throws Exception {
        PipedInputStream pis = new PipedInputStream();
        PipedOutputStream pos = new PipedOutputStream(pis);
        PrintStream ps = new PrintStream((OutputStream)pos, false, Charset.defaultCharset().name());
        final InputStreamReader isr = new InputStreamReader((InputStream)pis, Charset.defaultCharset());
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                char[] buf = new char[4096];
                try {
                    int read;
                    while ((read = isr.read(buf)) >= 0) {
                        out.write(buf, 0, read);
                        out.flush();
                    }
                }
                catch (IOException e) {
                    Selftest.printStackTrace(e);
                }
            }
        });
        t.start();
        return Selftest.runSelftest0(ps, () -> {
            ps.close();
            try {
                t.join();
            }
            catch (InterruptedException e) {
                Selftest.printStackTrace(e);
            }
        });
    }

    @SuppressFBWarnings(value={"THROWS_METHOD_THROWS_CLAUSE_THROWABLE", "THROWS_METHOD_THROWS_CLAUSE_BASIC_EXCEPTION"})
    public static int runSelftest(PrintStream out) throws Exception {
        return Selftest.runSelftest0(out, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int runSelftest0(PrintStream out, Runnable whenDone) throws Exception {
        int rc;
        PrintStream origSystemOut = System.out;
        System.setOut(out);
        try {
            rc = Selftest.runSelftest0(out);
        }
        finally {
            out.flush();
            System.setOut(origSystemOut);
            if (whenDone != null) {
                whenDone.run();
            }
        }
        return rc;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static int runSelftest0(PrintStream out) throws Exception {
        SelftestProvider sp = new SelftestProvider();
        Selftest st = new Selftest(out, sp);
        st.checkVM();
        st.printExplanation();
        st.dumpAdditionalProperties();
        st.dumpSystemProperties();
        st.dumpOSReleaseFiles();
        st.checkSupported();
        st.checkCapabilities();
        Set<String> disabledModules = sp.modulesDisabledByDefault();
        ArrayList<String> messagesAtEnd = new ArrayList<String>();
        for (Map.Entry<String, Class<?>[]> en : sp.tests().entrySet()) {
            String module;
            block7: {
                module = en.getKey();
                if (disabledModules.contains(module)) {
                    if (SystemPropertyUtil.getBooleanSystemProperty((String)("selftest.enable-module." + module), (boolean)false)) {
                        st.modified = true;
                        break block7;
                    } else {
                        messagesAtEnd.add("Skipping optional module: " + module + "; enable by launching with -Dselftest.enable-module." + module + "=true");
                        continue;
                    }
                }
                if (SystemPropertyUtil.getBooleanSystemProperty((String)("selftest.disable-module." + module), (boolean)false)) {
                    messagesAtEnd.add("Skipping required module: " + module + "; this taints the test");
                    st.withIssues = true;
                }
            }
            st.runTests(module, en.getValue());
        }
        if (!messagesAtEnd.isEmpty()) {
            for (String m : messagesAtEnd) {
                out.println(m);
            }
        }
        st.checkInitError();
        st.dumpResults();
        int rc = st.isFail() ? 1 : 0;
        out.flush();
        return rc;
    }

    private void dumpAdditionalProperties() {
        PrintWriter pw = new PrintWriter(new OutputStreamWriter((OutputStream)this.out, Charset.defaultCharset()));
        this.sp.printAdditionalProperties(pw);
        pw.flush();
        this.out.println();
    }

    public void printExplanation() throws IOException {
        this.out.println("This program determines whether junixsocket is supported on the current platform.");
        this.out.println("The final line should say whether the selftest passed or failed.");
        this.out.println();
        this.out.println("If the selftest failed, please visit https://github.com/kohlschutter/junixsocket/issues");
        this.out.println("and file a new bug report with the output below.");
        this.out.println();
        this.out.println("junixsocket selftest version " + AFUNIXSocket.getVersion());
        LinkedHashMap<String, String> buildProperties = new LinkedHashMap<String, String>(this.retrieveBuildProperties());
        try (InputStream in = this.getClass().getResourceAsStream("/META-INF/maven/com.kohlschutter.junixsocket/junixsocket-selftest/git.properties");){
            if (in != null) {
                Properties props = new Properties();
                props.load(in);
                for (String key : new TreeSet<String>(props.stringPropertyNames())) {
                    buildProperties.put(key, props.getProperty(key));
                }
            }
        }
        this.out.println();
        this.out.println("Build properties:");
        for (Map.Entry en : buildProperties.entrySet()) {
            this.out.println((String)en.getKey() + ": " + (String)en.getValue());
        }
        this.out.println();
    }

    public void dumpSystemProperties() {
        TreeMap<Object, Object> map = new TreeMap<Object, Object>(System.getProperties());
        for (String expectedKey : new String[]{"android.icu.library.version", "android.icu.unicode.version", "android.icu.cldr.version", "ICUDebug", "android.icu.text.DecimalFormat.SkipExtendedSeparatorParsing", "android.icu.text.MessagePattern.ApostropheMode", "sun.io.useCanonCaches", "sun.io.useCanonPrefixCache", "sun.stdout.encoding", "sun.stderr.encoding", "http.keepAlive", "http.keepAliveDuration", "http.maxConnections", "javax.net.debug", "com.sun.security.preserveOldDCEncoding", "java.util.logging.manager", "file.encoding", "file.separator", "line.separator", "path.separator", "java.boot.class.path", "java.class.path", "java.class.version", "java.compiler", "java.ext.dirs", "java.home", "java.io.tmpdir", "java.library.path", "java.vendor", "java.vendor.url", "java.version", "java.net.preferIPv6Addresses", "java.specification.version", "java.specification.vendor", "java.specification.name", "java.vm.version", "java.vm.vendor", "java.vm.vendor.url", "java.vm.name", "java.vm.specification.version", "java.vm.specification.vendor", "java.vm.specification.name", "os.arch", "os.name", "os.version", "user.dir", "user.home", "user.language", "user.region", "user.variant", "user.name"}) {
            String value;
            if (map.containsKey(expectedKey) || (value = System.getProperty(expectedKey)) == null) continue;
            map.put(expectedKey, value);
        }
        this.out.println("System properties:");
        this.out.println();
        for (Map.Entry entry : map.entrySet()) {
            String key = String.valueOf(entry.getKey());
            String value = String.valueOf(entry.getValue());
            StringBuilder sb = new StringBuilder();
            block7: for (int i = 0; i < value.length(); ++i) {
                char c = value.charAt(i);
                switch (c) {
                    case '\n': {
                        sb.append("\\n");
                        continue block7;
                    }
                    case '\r': {
                        sb.append("\\r");
                        continue block7;
                    }
                    case '\t': {
                        sb.append("\\r");
                        continue block7;
                    }
                    default: {
                        if (c < ' ' || c >= '\u007f') {
                            sb.append(String.format(Locale.ENGLISH, "\\u%04x", (int)c));
                        }
                        sb.append(c);
                    }
                }
            }
            this.out.println(key + ": " + sb.toString());
        }
        this.out.println();
    }

    public void checkSupported() {
        this.out.print("AFSocket.isSupported: ");
        this.out.flush();
        boolean isSupported = AFSocket.isSupported();
        this.out.println(isSupported);
        this.out.println();
        this.out.flush();
        if (!isSupported) {
            this.out.println("FAIL: junixsocket is not supported on this platform");
            this.out.println();
            this.fail = true;
        }
        this.out.print("AFUNIXSocket.isSupported: ");
        this.out.flush();
        this.isSupportedAFUNIX = AFUNIXSocket.isSupported();
        this.out.println(this.isSupportedAFUNIX);
        this.out.println();
        this.out.flush();
        if (!this.isSupportedAFUNIX) {
            this.out.println("WARNING: AF_UNIX sockets are not supported on this platform");
            this.out.println();
            this.withIssues = true;
        }
    }

    public void checkCapabilities() {
        for (AFSocketCapability cap : AFSocketCapability.values()) {
            boolean supported = AFSocket.supports((AFSocketCapability)cap);
            (supported ? this.supportedCapabilites : this.unsupportedCapabilites).add(cap);
        }
    }

    public boolean isFail() {
        return this.fail;
    }

    private void checkInitError() {
        Throwable t = this.retrieveInitError();
        if (t == null) {
            return;
        }
        this.important.add("The native library failed to load.");
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        t.printStackTrace(pw);
        pw.flush();
        String ts = sw.toString();
        String tsLower = ts.toLowerCase(Locale.ENGLISH);
        if (tsLower.contains("not permitted") || ts.contains("permission")) {
            this.important.add("It looks like there were some permission errors.");
        }
        if (tsLower.contains("failed to map segment")) {
            this.important.add("Your temporary directory is probably mounted with \"noexec\", which prevents the native library from loading.");
            this.important.add("see: https://github.com/kohlschutter/junixsocket/issues/99");
            Object tmpDir = this.retrieveTempDir();
            if (tmpDir == null) {
                tmpDir = System.getProperty("java.io.tmpdir");
            }
            if (tmpDir != null) {
                this.important.add("Temp dir: " + tmpDir);
            }
            this.important.add("You can specify a different directory using -Dorg.newsclub.net.unix.library.tmpdir=");
        }
    }

    public void dumpResults() {
        if (this.modified) {
            this.important.add("Selftest was modified, for example to exclude/include certain tests.");
            this.inconclusive = true;
        }
        if (!this.isSupportedAFUNIX) {
            this.important.add("Environment does not support UNIX sockets, which is an important part of junixsocket.");
        }
        if (this.inconclusive) {
            this.important.add("Selftest results may be inconclusive.");
        }
        if (this.withIssues) {
            this.important.add("\"With issues\": Please carefully check the output above; the software may not be able to do what you want.");
        }
        this.out.println();
        this.out.println("Selftest results:");
        for (Map.Entry<String, ModuleResult> en : this.results.entrySet()) {
            String extra;
            String result;
            ModuleResult res = en.getValue();
            String string = result = res == null ? null : res.result.name();
            if (res == null || (res.result == Result.SKIP || res.result == Result.AUTOSKIP) && res.throwable == null) {
                result = "SKIP";
                extra = res != null && res.result == Result.AUTOSKIP ? "(skipped automatically)" : "(skipped by user request)";
            } else if (res.summary == null) {
                extra = res.throwable == null ? "(unknown error)" : res.throwable.toString();
                this.fail = true;
            } else {
                TestExecutionSummary summary = res.summary;
                long nSucceeded = summary.getTestsSucceededCount() + res.getNumAbortedNonIssues();
                extra = nSucceeded + "/" + summary.getTestsFoundCount();
                long nSkipped = summary.getTestsSkippedCount();
                if (nSkipped > 0L) {
                    extra = extra + " (" + nSkipped + " skipped)";
                }
            }
            this.out.println(result + "\t" + en.getKey() + "\t" + extra);
        }
        this.out.println();
        if (!this.important.isEmpty()) {
            for (String l : this.important) {
                this.out.println("IMPORTANT: " + l);
            }
            this.out.println();
        }
        this.out.println("Supported capabilities:   " + this.supportedCapabilites);
        this.out.println("Unsupported capabilities: " + this.unsupportedCapabilites);
        this.out.println();
        if (this.fail) {
            this.out.println("Selftest FAILED");
        } else if (this.inconclusive || this.modified) {
            this.out.println("Selftest INCONCLUSIVE");
        } else if (this.withIssues) {
            this.out.println("Selftest PASSED WITH ISSUES");
        } else {
            this.out.println("Selftest PASSED");
        }
    }

    private SkipMode getSkipModeForModule(String moduleName) {
        return SkipMode.parse(System.getProperty("selftest.skip." + moduleName));
    }

    private SkipMode getSkipModeForClass(String className) {
        SkipMode skipMode = SkipMode.parse(System.getProperty("selftest.skip." + className));
        if (skipMode.isDeclared()) {
            return skipMode;
        }
        int i = className.lastIndexOf(46);
        if (i < 0) {
            return SkipMode.UNDECLARED;
        }
        className = className.substring(i + 1);
        return SkipMode.parse(System.getProperty("selftest.skip." + className));
    }

    public void runTests(String module, Class<?>[] testClasses) {
        ModuleResult moduleResult;
        String prefix = "Testing \"" + module + "\"... ";
        this.out.markPosition();
        this.out.update(prefix);
        this.out.flush();
        String only = System.getProperty("selftest.only", "");
        if (!only.isEmpty()) {
            this.modified = true;
        }
        boolean skipped = false;
        SkipMode skipMode = this.getSkipModeForModule(module);
        if (skipMode.isSkip()) {
            boolean autoSkip = skipMode == SkipMode.SKIP_AUTO;
            this.out.println("Skipping module " + module + "; skipped " + (autoSkip ? "automatically" : "by user request" + (skipMode.isForce() ? " (force)" : "")));
            if (!skipMode.isForce()) {
                this.withIssues = true;
                this.modified = true;
            }
            moduleResult = new ModuleResult(autoSkip ? Result.AUTOSKIP : Result.SKIP, null, null);
        } else {
            ArrayList list = new ArrayList(testClasses.length);
            for (Class<?> testClass : testClasses) {
                if (testClass == null) continue;
                String className = testClass.getName();
                String simpleName = testClass.getSimpleName();
                if (!only.isEmpty() && !only.equals(className) && !only.equals(simpleName)) continue;
                skipMode = this.getSkipModeForClass(className);
                if (skipMode.isSkip()) {
                    this.out.println("Skipping test class " + className + "; skipped by request" + (skipMode.isForce() ? " (force)" : ""));
                    if (skipMode.isForce()) continue;
                    this.modified = true;
                    this.withIssues = true;
                    continue;
                }
                list.add(testClass);
            }
            TestExecutionSummary summary = null;
            Exception exception = null;
            long numAbortedNonIssues = 0L;
            try {
                SelftestExecutor ex = new SelftestExecutor(list, prefix);
                summary = ex.execute(this.out);
                for (Map.Entry<TestIdentifier, TestExecutionResult> en : ex.getTestsWithWarnings().entrySet()) {
                    TestIdentifier tid = en.getKey();
                    TestExecutionResult res = en.getValue();
                    Optional t = res.getThrowable();
                    if (!t.isPresent()) continue;
                    Throwable throwable = (Throwable)t.get();
                    if (throwable instanceof TestAbortedWithImportantMessageException) {
                        String key = module + ": " + ex.getTestIdentifier((String)tid.getParentId().get()).getDisplayName() + "." + tid.getDisplayName();
                        TestAbortedWithImportantMessageException ime = (TestAbortedWithImportantMessageException)((Object)t.get());
                        TestAbortedWithImportantMessageException.MessageType messageType = ime.messageType();
                        if (messageType.isIncludeTestInfo()) {
                            this.important.add(ime.getSummaryMessage() + "; " + key);
                        } else {
                            String msg = ime.getSummaryMessage();
                            if (!msg.isEmpty()) {
                                this.important.add(msg);
                            }
                        }
                        if (messageType.isWithIssues()) continue;
                        ++numAbortedNonIssues;
                        continue;
                    }
                    if (!(throwable instanceof TestAbortedNotAnIssueException)) continue;
                    ++numAbortedNonIssues;
                }
            }
            catch (Exception e) {
                e.printStackTrace((PrintStream)this.out);
                exception = e;
            }
            if (skipped) {
                moduleResult = new ModuleResult(Result.SKIP, null, exception);
            } else if (exception != null || summary == null) {
                moduleResult = new ModuleResult(Result.FAIL, null, exception);
                this.fail = true;
            } else {
                Result result;
                if (summary.getTestsFailedCount() > 0L) {
                    result = Result.FAIL;
                    this.fail = true;
                } else if (summary.getTestsFoundCount() == 0L) {
                    result = Result.NONE;
                } else if (summary.getTestsSucceededCount() + summary.getTestsSkippedCount() + numAbortedNonIssues == summary.getTestsFoundCount()) {
                    result = Result.PASS;
                } else if (summary.getTestsAbortedCount() > 0L) {
                    result = Result.DONE;
                    this.withIssues = true;
                } else {
                    result = Result.DONE;
                }
                moduleResult = new ModuleResult(result, summary, null);
                moduleResult.numAbortedNonIssues = numAbortedNonIssues;
            }
        }
        this.results.put(module, moduleResult);
    }

    private void dumpContentsOfSystemConfigFile(File file) {
        if (!file.exists()) {
            return;
        }
        String p = file.getAbsolutePath();
        this.out.println("BEGIN contents of file: " + p);
        int maxToRead = 4096;
        char[] buf = new char[4096];
        try (InputStreamReader isr = new InputStreamReader((InputStream)new FileInputStream(file), StandardCharsets.UTF_8);){
            OutputStreamWriter outWriter = new OutputStreamWriter((OutputStream)this.out, Charset.defaultCharset());
            int read = -1;
            boolean lastWasNewline = false;
            for (int numRead = 0; numRead < 4096 && (read = isr.read(buf)) != -1; numRead += read) {
                outWriter.write(buf, 0, read);
                outWriter.flush();
                lastWasNewline = read > 0 && buf[read - 1] == '\n';
            }
            if (!lastWasNewline) {
                this.out.println();
            }
            if (read != -1) {
                this.out.println("[...]");
            }
        }
        catch (Exception e) {
            this.out.println("ERROR while reading contents of file: " + p + ": " + e);
        }
        this.out.println("=END= contents of file: " + p);
        this.out.println();
    }

    public void dumpOSReleaseFiles() throws IOException {
        HashSet<Path> canonicalPaths = new HashSet<Path>();
        for (String f : new String[]{"/etc/os-release", "/etc/lsb-release", "/etc/lsb_release", "/etc/system-release", "/etc/system-release-cpe", "/etc/debian_version", "/etc/fedora-release", "/etc/redhat-release", "/etc/centos-release", "/etc/centos-release-upstream", "/etc/SuSE-release", "/etc/arch-release", "/etc/gentoo-release", "/etc/ubuntu-release"}) {
            File file = new File(f);
            if (!file.exists() || file.isDirectory()) continue;
            Path p = file.toPath().toAbsolutePath();
            for (int i = 0; i < 2; ++i) {
                Path p2;
                if (!Files.isSymbolicLink(p) || (p2 = Files.readSymbolicLink(p)).isAbsolute()) continue;
                p = new File(p.toFile().getParentFile(), p2.toString()).toPath().toAbsolutePath();
            }
            if (!canonicalPaths.add(p)) continue;
            this.dumpContentsOfSystemConfigFile(file);
        }
    }

    private Throwable retrieveInitError() {
        return (Throwable)Selftest.callStaticMethod(this.diagnosticsHelperClass, "initError", null);
    }

    private File retrieveTempDir() {
        return (File)Selftest.callStaticMethod(this.diagnosticsHelperClass, "tempDir", null);
    }

    private Map<String, String> retrieveBuildProperties() {
        return Selftest.callStaticMethod(this.diagnosticsHelperClass, "buildProperties", () -> Collections.emptyMap());
    }

    private static Class<?> resolveOptionalClass(String name) {
        try {
            return Class.forName(name);
        }
        catch (Exception e) {
            return null;
        }
    }

    private static <T> T callStaticMethod(Class<?> clazz, String methodName, Supplier<T> defaultSupplier) {
        try {
            return (T)clazz.getMethod(methodName, new Class[0]).invoke(null, new Object[0]);
        }
        catch (Exception e) {
            return defaultSupplier == null ? null : (T)defaultSupplier.get();
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    private static enum SkipMode {
        UNDECLARED(false),
        KEEP(false),
        SKIP(true),
        SKIP_FORCE(true),
        SKIP_AUTO(true);

        final boolean skip;

        private SkipMode(boolean skip) {
            this.skip = skip;
        }

        boolean isSkip() {
            return this.skip;
        }

        boolean isDeclared() {
            return this != UNDECLARED;
        }

        boolean isForce() {
            return this == SKIP_FORCE || this == SKIP_AUTO;
        }

        public static SkipMode parse(String skipMode) {
            if (skipMode == null || skipMode.isEmpty()) {
                return UNDECLARED;
            }
            if ("force".equalsIgnoreCase(skipMode)) {
                return SKIP_FORCE;
            }
            if ("force_auto".equalsIgnoreCase(skipMode)) {
                return SKIP_AUTO;
            }
            return Boolean.parseBoolean(skipMode) ? SKIP : KEEP;
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    private static final class ModuleResult {
        private final Result result;
        private final TestExecutionSummary summary;
        private final Throwable throwable;
        private long numAbortedNonIssues = 0L;

        ModuleResult(Result result, TestExecutionSummary summary, Throwable t) {
            Objects.requireNonNull(result);
            this.result = result;
            this.summary = summary;
            this.throwable = t;
        }

        long getNumAbortedNonIssues() {
            return this.numAbortedNonIssues;
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    private static enum Result {
        AUTOSKIP,
        SKIP,
        PASS,
        DONE,
        NONE,
        FAIL;

    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    @SuppressFBWarnings(value={"UUF_UNUSED_FIELD"})
    static final class MinimizeJarDependencies {
        JupiterTestEngine jte;
        HierarchicalTestEngine<?> hte;
        EngineDescriptor ed;
        DiscoverySelectorResolver dsr;
        org.newsclub.lib.junixsocket.common.NarMetadata nmCommon;
        NarMetadata nmCustom;

        MinimizeJarDependencies() {
        }
    }
}

