/*
 * Decompiled with CFR 0.152.
 */
package org.newsclub.net.unix.darwin.system;

import com.kohlschutter.testutil.ExecutionEnvironmentRequirement;
import java.io.IOException;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.Test;
import org.newsclub.net.unix.AFSYSTEMSocketAddress;
import org.newsclub.net.unix.AFSocketCapability;
import org.newsclub.net.unix.AFSocketCapabilityRequirement;
import org.newsclub.net.unix.darwin.system.AFSYSTEMDatagramChannel;
import org.newsclub.net.unix.darwin.system.AFSYSTEMDatagramSocket;
import org.newsclub.net.unix.darwin.system.IPUtil;
import org.newsclub.net.unix.darwin.system.WellKnownKernelControlNames;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class UtunTest {
    private static final Inet4Address UTUN_SRC_IP;
    private static final Inet4Address UTUN_DST_IP;

    private static Object unchecked(Object v) {
        return v;
    }

    private static int getAddressAsInt(Inet4Address addr) {
        return addr.hashCode();
    }

    @Test
    @ExecutionEnvironmentRequirement(root=ExecutionEnvironmentRequirement.Rule.REQUIRED)
    @AFSocketCapabilityRequirement(value={AFSocketCapability.CAPABILITY_DARWIN})
    public void testTunnelPingPong() throws Exception {
        AFSYSTEMDatagramSocket socket = AFSYSTEMDatagramSocket.newInstance();
        try {
            int id = socket.getNodeIdentity(WellKnownKernelControlNames.UTUN_CONTROL);
            try {
                socket.connect((SocketAddress)AFSYSTEMSocketAddress.ofSysAddrIdUnit((AFSYSTEMSocketAddress.SysAddr)AFSYSTEMSocketAddress.SysAddr.AF_SYS_CONTROL, (int)id, (int)0));
            }
            catch (SocketException e) {
                Assumptions.assumeTrue((boolean)false, (String)("Could not connect to UTUN_CONTROL: " + e));
                if (socket != null) {
                    socket.close();
                }
                return;
            }
            Assertions.assertTimeoutPreemptively((Duration)Duration.ofSeconds(5L), () -> {
                int rcIfconfig;
                AFSYSTEMSocketAddress rsa = (AFSYSTEMSocketAddress)socket.getRemoteSocketAddress();
                Objects.requireNonNull(rsa);
                Assertions.assertEquals((Object)AFSYSTEMSocketAddress.SysAddr.AF_SYS_CONTROL, (Object)rsa.getSysAddr());
                Assertions.assertEquals((int)id, (int)rsa.getId());
                Assertions.assertNotEquals((int)0, (int)rsa.getUnit());
                String utun = "utun" + (rsa.getUnit() - 1);
                Process p = Runtime.getRuntime().exec(new String[]{"/sbin/ifconfig", utun, UTUN_SRC_IP.getHostAddress(), UTUN_DST_IP.getHostAddress()});
                try {
                    rcIfconfig = p.waitFor();
                }
                finally {
                    p.destroyForcibly();
                }
                Assertions.assertEquals((int)0, (int)rcIfconfig, (String)("Could not set IP address for " + utun));
                AFSYSTEMDatagramChannel channel = socket.getChannel();
                ByteBuffer bb = ByteBuffer.allocateDirect(1500).order(ByteOrder.BIG_ENDIAN);
                CompletableFuture<Boolean> ping = CompletableFuture.supplyAsync(() -> {
                    try {
                        return UTUN_DST_IP.isReachable(1000);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        return false;
                    }
                });
                if (channel.read(bb) >= 0) {
                    bb.flip();
                    int totalSize = bb.remaining();
                    int domain = bb.getInt();
                    Assertions.assertEquals((int)2, (int)domain, (String)"Expect domain 2 (AF_INET)");
                    int ipHeaderStartPos = bb.position();
                    int versionAndIHL = bb.get() & 0xFF;
                    int version = versionAndIHL >> 4;
                    Assertions.assertEquals((int)4, (int)version, (String)"expect IPv4 packet");
                    int ihl = versionAndIHL & 0xF;
                    int ihlBytes = ihl * 32 / 8;
                    Assertions.assertTrue((ihlBytes >= 20 ? 1 : 0) != 0, (String)"expect (at least) 20 bytes header length");
                    int tosDSCP = bb.get() & 0xFF;
                    UtunTest.unchecked(tosDSCP);
                    int totalLen = bb.getShort() & 0xFFFF;
                    Assertions.assertEquals((int)(totalSize - 4), (int)totalLen);
                    int identification = bb.getShort() & 0xFFFF;
                    UtunTest.unchecked(identification);
                    int flagsAndFragmentOffset = bb.getShort() & 0xFFFF;
                    int flags = flagsAndFragmentOffset >> 13;
                    int fragmentOffset = flagsAndFragmentOffset & 0x1FFF;
                    Assertions.assertEquals((int)0, (int)flags);
                    Assertions.assertEquals((int)0, (int)fragmentOffset);
                    int ttl = bb.get() & 0xFF;
                    Assertions.assertNotEquals((int)0, (int)ttl);
                    int protocol = bb.get() & 0xFF;
                    Assertions.assertEquals((int)1, (int)protocol);
                    int headerChecksum = bb.getShort() & 0xFFFF;
                    int srcIP = bb.getInt();
                    int dstIP = bb.getInt();
                    Assertions.assertEquals((int)UtunTest.getAddressAsInt(UTUN_SRC_IP), (int)srcIP);
                    Assertions.assertEquals((int)UtunTest.getAddressAsInt(UTUN_DST_IP), (int)dstIP);
                    int remainingHeaderLength = ihlBytes - 20;
                    if (remainingHeaderLength > 0) {
                        System.err.println("Warning: Found unexpected Options section in IPv4 header; len=" + remainingHeaderLength);
                        bb.position(bb.position() + remainingHeaderLength);
                    }
                    int computedHeaderChecksum = IPUtil.checksumIPv4header((ByteBuffer)bb, (int)ipHeaderStartPos, (int)bb.position());
                    Assertions.assertEquals((int)computedHeaderChecksum, (int)headerChecksum);
                    int icmpSize = bb.remaining();
                    int icmpBeginPosition = bb.position();
                    int icmpType = bb.get() & 0xFF;
                    Assertions.assertEquals((int)8, (int)icmpType);
                    int icmpCode = bb.get() & 0xFF;
                    Assertions.assertEquals((int)0, (int)icmpCode);
                    int icmpChecksum = bb.getShort() & 0xFFFF;
                    int icmpEchoIdentifier = bb.getShort() & 0xFFFF;
                    int icmpEchoSequenceNumber = bb.getShort() & 0xFFFF;
                    UtunTest.unchecked(icmpEchoIdentifier);
                    Assertions.assertEquals((int)1, (int)icmpEchoSequenceNumber);
                    int icmpChecksumComputed = IPUtil.checksumICMPheader((ByteBuffer)bb, (int)icmpBeginPosition, (int)(bb.position() + bb.remaining()));
                    Assertions.assertEquals((int)icmpChecksumComputed, (int)icmpChecksum);
                    ByteBuffer response = ByteBuffer.allocate(24 + icmpSize).order(ByteOrder.BIG_ENDIAN);
                    response.putInt(2);
                    IPUtil.putIPv4Header((ByteBuffer)response, (int)icmpSize, (byte)1, (int)dstIP, (int)srcIP);
                    int responsePayloadStart = response.position();
                    IPUtil.checksumIPv4header((ByteBuffer)response, (int)4, (int)responsePayloadStart);
                    IPUtil.putICMPEchoResponse((ByteBuffer)response, (short)((short)icmpEchoIdentifier), (short)((short)icmpEchoSequenceNumber), (ByteBuffer)bb);
                    Assertions.assertEquals((int)0, (int)bb.remaining());
                    int responsePayloadEnd = response.position();
                    IPUtil.checksumICMPheader((ByteBuffer)response, (int)responsePayloadStart, (int)responsePayloadEnd);
                    response.flip();
                    int written = channel.write(response);
                    bb.clear();
                    Assertions.assertEquals((int)response.capacity(), (int)written);
                    Assertions.assertTrue((boolean)ping.get(1L, TimeUnit.SECONDS));
                    return;
                }
                Assertions.fail((String)"Nothing received");
            });
        }
        finally {
            if (socket != null) {
                try {
                    socket.close();
                }
                catch (Throwable throwable) {
                    Throwable throwable2;
                    throwable2.addSuppressed(throwable);
                }
            }
        }
    }

    static {
        try {
            UTUN_SRC_IP = (Inet4Address)InetAddress.getByName("169.254.3.4");
            UTUN_DST_IP = (Inet4Address)InetAddress.getByName("169.254.3.5");
        }
        catch (UnknownHostException e) {
            throw new IllegalStateException(e);
        }
    }
}

