/*
 * Decompiled with CFR 0.152.
 */
package org.newsclub.net.unix.java;

import com.kohlschutter.annotations.compiletime.SuppressFBWarnings;
import com.kohlschutter.testutil.SystemPropertyRequirement;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.channels.DatagramChannel;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.nio.channels.spi.SelectorProvider;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.Test;
import org.newsclub.net.unix.java.JavaAddressSpecifics;
import org.newsclub.net.unix.java.JavaInetStackRequirement;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
@JavaInetStackRequirement
@SuppressFBWarnings(value={"THROWS_METHOD_THROWS_CLAUSE_THROWABLE", "THROWS_METHOD_THROWS_CLAUSE_BASIC_EXCEPTION", "NM_SAME_SIMPLE_NAME_AS_SUPERCLASS"})
public final class ThroughputTest
extends org.newsclub.net.unix.ThroughputTest<InetSocketAddress> {
    public ThroughputTest() {
        super(JavaAddressSpecifics.INSTANCE);
    }

    @Test
    @SystemPropertyRequirement(property="org.newsclub.net.unix.throughput-test.ip.enabled", value="1", message="Loopback TCP/IP testing is disabled")
    public void testTCPLoopback() throws Exception {
        Assumptions.assumeTrue((ENABLED > 0 ? 1 : 0) != 0, (String)"Throughput tests are disabled");
        Assumptions.assumeTrue((PAYLOAD_SIZE > 0 ? 1 : 0) != 0, (String)"Payload must be positive");
        this.runTestTCPLoopback(false);
    }

    @Test
    @SystemPropertyRequirement(property="org.newsclub.net.unix.throughput-test.ip.enabled", value="1", message="Loopback TCP/IP testing is disabled")
    public void testTCPLoopbackDirectBuffer() throws Exception {
        Assumptions.assumeTrue((ENABLED > 0 ? 1 : 0) != 0, (String)"Throughput tests are disabled");
        Assumptions.assumeTrue((PAYLOAD_SIZE > 0 ? 1 : 0) != 0, (String)"Payload must be positive");
        this.runTestTCPLoopback(true);
    }

    private void runTestTCPLoopback(boolean direct) throws Exception {
        InetSocketAddress sa = new InetSocketAddress(InetAddress.getLoopbackAddress(), 0);
        ServerSocketChannel ssc = ServerSocketChannel.open();
        this.runTestSocketChannel("TCP-Loopback", sa, ssc, () -> SocketChannel.open(ssc.getLocalAddress()), direct);
    }

    @Test
    @SystemPropertyRequirement(property="org.newsclub.net.unix.throughput-test.ip.enabled", value="1", message="Loopback UDP/IP testing is disabled")
    public void testUDPLoopback() throws Exception {
        this.testUDPLoopbackDatagramChannel(false);
    }

    @Test
    @SystemPropertyRequirement(property="org.newsclub.net.unix.throughput-test.ip.enabled", value="1", message="Loopback UDP/IP testing is disabled")
    public void testUDPLoopbackDirectBuffer() throws Exception {
        this.testUDPLoopbackDatagramChannel(true);
    }

    private void testUDPLoopbackDatagramChannel(boolean direct) throws Exception {
        InetSocketAddress dsAddr = new InetSocketAddress(InetAddress.getLoopbackAddress(), 0);
        InetSocketAddress dcAddr = new InetSocketAddress(InetAddress.getLoopbackAddress(), 0);
        try (DatagramChannel ds = SelectorProvider.provider().openDatagramChannel();
             DatagramChannel dc = SelectorProvider.provider().openDatagramChannel();){
            ds.bind(dsAddr);
            dc.bind(dcAddr).connect(ds.getLocalAddress());
            ds.connect(dc.getLocalAddress());
            Assertions.assertNotEquals((Object)ds.getLocalAddress(), (Object)dc.getLocalAddress());
            SelectorProvider sp = this.selectorProvider();
            this.testSocketDatagramChannel("UDP-Loopback DatagramChannel", ds, dc, sp, direct, true);
        }
    }

    @Override
    protected String stbTestType() {
        return "java.net";
    }
}

