/*
 * Decompiled with CFR 0.152.
 */
package org.newsclub.net.unix.selftest.apps;

import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.newsclub.net.unix.AFAddressFamily;
import org.newsclub.net.unix.AFSocket;
import org.newsclub.net.unix.AFSocketAddress;
import org.newsclub.net.unix.selftest.apps.IOUtil;
import org.newsclub.net.unix.selftest.apps.SocketAddressUtil;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class StreamClient {
    private static void printHelp() {
        System.err.println("Syntax: java " + StreamClient.class.getName() + " <URI>");
        System.err.println();
        System.err.println("Supported schemes: " + String.valueOf(AFAddressFamily.uriSchemes()));
    }

    public static void main(String[] args) throws IOException, InterruptedException, ExecutionException {
        AFSocketAddress address;
        if (args.length == 0) {
            StreamClient.printHelp();
            System.exit(1);
            return;
        }
        try {
            address = SocketAddressUtil.parseAddress(args[0]);
        }
        catch (Exception e) {
            StreamClient.printHelp();
            System.err.println();
            e.printStackTrace();
            System.exit(1);
            return;
        }
        ExecutorService exc = Executors.newCachedThreadPool();
        try (AFSocket sock = address.newConnectedSocket();){
            sock.setReceiveBufferSize(8192);
            Future<Long> sentFuture = exc.submit(() -> {
                try (FileInputStream in = new FileInputStream(FileDescriptor.in);){
                    Long l = sock.getOutputStream().transferFrom((InputStream)in);
                    return l;
                }
            });
            IOUtil.transfer((InputStream)sock.getInputStream(), System.out);
            sentFuture.get();
            exc.shutdown();
        }
    }
}

