/*
 * Decompiled with CFR 0.152.
 */
package org.newsclub.net.unix;

import com.kohlschutter.annotations.compiletime.SuppressFBWarnings;
import com.kohlschutter.testutil.TestAbortedWithImportantMessageException;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.newsclub.net.unix.AddressSpecifics;
import org.newsclub.net.unix.SocketTestBase;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
@SuppressFBWarnings(value={"THROWS_METHOD_THROWS_CLAUSE_THROWABLE", "THROWS_METHOD_THROWS_CLAUSE_BASIC_EXCEPTION"})
public abstract class CancelAcceptTest<A extends SocketAddress>
extends SocketTestBase<A> {
    protected static final String NO_SOCKETEXCEPTION_CLOSED_SERVER = "Did not throw SocketException when connecting to closed server socket";
    private boolean serverSocketClosed = false;

    protected CancelAcceptTest(AddressSpecifics<A> asp) {
        super(asp);
    }

    @Test
    public void issue6test1() throws Exception {
        block23: {
            this.serverSocketClosed = false;
            final AtomicBoolean ignoreServerSocketClosedException = new AtomicBoolean(false);
            try (SocketTestBase.ServerThread serverThread = new SocketTestBase.ServerThread(){

                @Override
                protected void handleConnection(Socket sock) throws IOException {
                }

                @Override
                protected void onServerSocketClose() {
                    CancelAcceptTest.this.serverSocketClosed = true;
                }

                @Override
                protected SocketTestBase.ExceptionHandlingDecision handleException(Exception e) {
                    ServerSocket serverSocket;
                    if (ignoreServerSocketClosedException.get() && e instanceof SocketException && (serverSocket = this.getServerSocket()) != null && serverSocket.isClosed()) {
                        return SocketTestBase.ExceptionHandlingDecision.IGNORE;
                    }
                    return SocketTestBase.ExceptionHandlingDecision.RAISE;
                }
            };){
                String noticeNoSocketException2;
                Socket sock;
                Socket sock2 = this.connectTo(serverThread.getServerAddress());
                if (sock2 != null) {
                    sock2.close();
                }
                if ((sock2 = this.connectTo(serverThread.getServerAddress())) != null) {
                    sock2.close();
                }
                ServerSocket serverSocket = serverThread.getServerSocket();
                Assertions.assertFalse((this.serverSocketClosed && !serverSocket.isClosed() ? 1 : 0) != 0, (String)"ServerSocket should not be closed now");
                ignoreServerSocketClosedException.set(true);
                SocketAddress serverAddress = serverThread.getServerAddress();
                serverSocket.close();
                try {
                    sock = this.connectTo(serverAddress);
                    if (sock != null) {
                        sock.close();
                    }
                    if ((noticeNoSocketException2 = this.checkKnownConditionDidNotThrowSocketException()) != null) {
                        throw new TestAbortedWithImportantMessageException(TestAbortedWithImportantMessageException.MessageType.TEST_ABORTED_WITH_ISSUES, noticeNoSocketException2);
                    }
                    Assertions.fail((String)NO_SOCKETEXCEPTION_CLOSED_SERVER);
                }
                catch (SocketException noticeNoSocketException2) {
                    // empty catch block
                }
                Assertions.assertTrue((this.serverSocketClosed || serverSocket.isClosed() ? 1 : 0) != 0, (String)"ServerSocket should be closed now");
                try {
                    sock = this.connectTo(serverAddress);
                    try {
                        Assertions.fail((String)"ServerSocket should have been closed already");
                    }
                    finally {
                        if (sock != null) {
                            sock.close();
                        }
                    }
                    noticeNoSocketException2 = this.checkKnownConditionDidNotThrowSocketException();
                    if (noticeNoSocketException2 == null) {
                        Assertions.fail((String)NO_SOCKETEXCEPTION_CLOSED_SERVER);
                        break block23;
                    }
                    throw new TestAbortedWithImportantMessageException(TestAbortedWithImportantMessageException.MessageType.TEST_ABORTED_WITH_ISSUES, noticeNoSocketException2);
                }
                catch (SocketException socketException) {
                    // empty catch block
                }
            }
            catch (SocketException e) {
                e.printStackTrace();
            }
        }
    }

    protected String checkKnownConditionDidNotThrowSocketException() {
        return null;
    }
}

