/*
 * Decompiled with CFR 0.152.
 */
package org.newsclub.net.unix.vsock;

import com.kohlschutter.annotations.compiletime.SuppressFBWarnings;
import com.kohlschutter.testutil.TestAbortedWithImportantMessageException;
import java.io.IOException;
import java.net.SocketAddress;
import java.net.SocketTimeoutException;
import org.junit.jupiter.api.Test;
import org.newsclub.net.unix.AFSocketCapability;
import org.newsclub.net.unix.AFSocketCapabilityRequirement;
import org.newsclub.net.unix.AFVSOCKSocketAddress;
import org.newsclub.net.unix.vsock.AFVSOCKAddressSpecifics;
import org.newsclub.net.unix.vsock.AFVSOCKSocket;
import org.opentest4j.TestAbortedException;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
@AFSocketCapabilityRequirement(value={AFSocketCapability.CAPABILITY_VSOCK})
@SuppressFBWarnings(value={"NM_SAME_SIMPLE_NAME_AS_SUPERCLASS"})
public final class AcceptTimeoutTest
extends org.newsclub.net.unix.AcceptTimeoutTest<AFVSOCKSocketAddress> {
    public AcceptTimeoutTest() {
        super(AFVSOCKAddressSpecifics.INSTANCE);
    }

    @Override
    @Test
    public void testTimeoutAfterDelay() throws Exception {
        try {
            super.testTimeoutAfterDelay();
        }
        catch (SocketTimeoutException e) {
            e.printStackTrace();
            try {
                this.newInterconnectedSockets();
            }
            catch (TestAbortedException e2) {
                TestAbortedWithImportantMessageException e3 = new TestAbortedWithImportantMessageException(TestAbortedWithImportantMessageException.MessageType.TEST_ABORTED_SHORT_WITH_ISSUES, "Kernel may be too old or not configured for full VSOCK support", (Throwable)e);
                e3.addSuppressed((Throwable)e2);
                throw e3;
            }
        }
    }

    @Override
    protected String checkKnownBugAcceptTimeout(SocketAddress serverAddress) {
        AFVSOCKSocketAddress sa;
        boolean vsockNotAvailable = false;
        Integer cid = null;
        try {
            cid = AFVSOCKSocket.getLocalCID();
            if (cid == -1) {
                vsockNotAvailable = true;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            vsockNotAvailable = true;
        }
        if (vsockNotAvailable) {
            return "Server accept timed out. " + (String)(cid != null ? "Local CID=" + cid : "Local CID could not be retrieved") + ". VSOCK may not be available";
        }
        if (serverAddress instanceof AFVSOCKSocketAddress && (sa = (AFVSOCKSocketAddress)serverAddress).getVSOCKCID() == 1) {
            return "Server accept timed out. Requested VMADDR_CID_LOCAL with local CID=" + cid + ". VSOCK may not be available";
        }
        return null;
    }
}

