/*
 * Decompiled with CFR 0.152.
 */
package org.newsclub.net.unix;

import com.kohlschutter.testutil.TestAbortedWithImportantMessageException;
import java.io.IOException;
import java.net.SocketAddress;
import java.net.SocketException;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.newsclub.net.unix.AddressSpecifics;
import org.newsclub.net.unix.InvalidArgumentSocketException;
import org.newsclub.net.unix.SocketTestBase;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public abstract class SocketChannelTest<A extends SocketAddress>
extends SocketTestBase<A> {
    protected SocketChannelTest(AddressSpecifics<A> asp) {
        super(asp);
    }

    @Test
    public void testNonBlockingConnect() throws IOException {
        SocketAddress sa = this.newTempAddress();
        ServerSocketChannel ssc = this.selectorProvider().openServerSocketChannel();
        ssc.configureBlocking(false);
        this.bindServerSocket(ssc, sa, 1);
        sa = ssc.getLocalAddress();
        SocketChannel sc = this.selectorProvider().openSocketChannel();
        sc.configureBlocking(false);
        if (!sc.connect(sa)) {
            Assertions.assertTrue((sc.isConnected() || sc.isConnectionPending() ? 1 : 0) != 0);
            long now = System.currentTimeMillis();
            while (!sc.finishConnect()) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    break;
                }
                if (System.currentTimeMillis() - now > 1000L) {
                    Assertions.fail((String)"Non-blocking connect not connected after 1s");
                    break;
                }
                if (!Thread.interrupted()) continue;
            }
            Assertions.assertTrue((boolean)sc.finishConnect());
        }
        Assertions.assertTrue((boolean)sc.isConnected());
        Assertions.assertFalse((boolean)sc.isConnectionPending());
    }

    @Test
    public void testDoubleBindAddressNotReusable() throws Exception {
        this.testDoubleBind(false);
    }

    @Test
    public void testDoubleBindAddressReusable() throws Exception {
        this.testDoubleBind(true);
    }

    private void testDoubleBind(boolean reuseAddress) throws Exception {
        String triggerWithIssues;
        CompletableFuture<Void> connectCall;
        block30: {
            CompletableFuture<SocketChannel> acceptCall2;
            CompletableFuture<SocketChannel> acceptCall;
            SocketAddress sa0 = this.newTempAddress();
            connectCall = null;
            AtomicBoolean socketDomainWillAcceptCallOnFirstBind = new AtomicBoolean(true);
            try (ServerSocketChannel ssc1 = this.selectorProvider().openServerSocketChannel();){
                this.bindServerSocket(ssc1, sa0, 1);
                SocketAddress sa = this.resolveAddressForSecondBind(sa0, ssc1);
                AtomicBoolean connectMustSucceed = new AtomicBoolean(false);
                acceptCall = CompletableFuture.supplyAsync(() -> {
                    try {
                        SocketChannel sc = ssc1.accept();
                        socketDomainWillAcceptCallOnFirstBind.set(false);
                        Objects.requireNonNull(sc);
                        if (reuseAddress && !connectMustSucceed.get()) {
                            Assertions.fail((String)"Did not throw SocketException");
                        }
                        return sc;
                    }
                    catch (SocketException e) {
                        if (!reuseAddress) {
                            Assertions.fail((Throwable)e);
                        }
                    }
                    catch (IOException e) {
                        Assertions.fail((Throwable)e);
                    }
                    return null;
                });
                try (ServerSocketChannel ssc2 = this.selectorProvider().openServerSocketChannel();){
                    block28: {
                        ssc2.socket().setReuseAddress(reuseAddress);
                        try {
                            this.bindServerSocket(ssc2, sa, 1);
                            if (!reuseAddress && !this.socketDomainPermitsDoubleBind()) {
                                Assertions.fail((String)"Did not throw expected SocketException (Address already in use)");
                            }
                        }
                        catch (SocketException e) {
                            if (!reuseAddress) break block28;
                            connectMustSucceed.set(true);
                        }
                    }
                    acceptCall2 = reuseAddress ? CompletableFuture.supplyAsync(() -> {
                        try {
                            SocketChannel sc = ssc2.accept();
                            socketDomainWillAcceptCallOnFirstBind.set(false);
                            Objects.requireNonNull(sc);
                            return sc;
                        }
                        catch (InvalidArgumentSocketException e) {
                            if (!acceptCall.isDone()) {
                                socketDomainWillAcceptCallOnFirstBind.set(true);
                            } else {
                                Assertions.fail((Throwable)e);
                            }
                        }
                        catch (IOException e) {
                            Assertions.fail((Throwable)e);
                        }
                        return null;
                    }) : null;
                    if (!acceptCall.isDone() && socketDomainWillAcceptCallOnFirstBind.get()) {
                        connectCall = CompletableFuture.runAsync(() -> {
                            try {
                                this.newSocket().connect(sa);
                            }
                            catch (SocketException e) {
                                if (connectMustSucceed.get()) {
                                    Assertions.fail((String)"Connect should have succeeded", (Throwable)e);
                                }
                            }
                            catch (IOException e) {
                                Assertions.fail((Throwable)e);
                            }
                        });
                    }
                }
            }
            if (acceptCall2 != null) {
                try {
                    acceptCall2.get(5L, TimeUnit.SECONDS);
                }
                catch (ExecutionException ssc1) {
                }
                catch (TimeoutException e) {
                    Assertions.fail((String)"Second accept call did not terminate");
                }
            }
            triggerWithIssues = null;
            try {
                acceptCall.get(5L, TimeUnit.SECONDS);
            }
            catch (ExecutionException sa) {
            }
            catch (TimeoutException e) {
                triggerWithIssues = this.checkKnownBugFirstAcceptCallNotTerminated();
                if (triggerWithIssues != null) break block30;
                Assertions.fail((String)"First accept call did not terminate");
            }
        }
        if (connectCall != null) {
            try {
                connectCall.get(5L, TimeUnit.SECONDS);
            }
            catch (ExecutionException e) {
            }
            catch (TimeoutException e) {
                Assertions.fail((String)"Connect call did not terminate");
            }
        }
        if (triggerWithIssues != null) {
            throw new TestAbortedWithImportantMessageException(TestAbortedWithImportantMessageException.MessageType.TEST_ABORTED_WITH_ISSUES, triggerWithIssues);
        }
    }

    protected String checkKnownBugFirstAcceptCallNotTerminated() {
        return null;
    }

    protected SocketAddress resolveAddressForSecondBind(SocketAddress originalAddress, ServerSocketChannel ssc) throws IOException {
        return ssc.getLocalAddress();
    }

    protected boolean socketDomainPermitsDoubleBind() {
        return false;
    }
}

