/*
 * Decompiled with CFR 0.152.
 */
package org.newsclub.net.unix;

import com.kohlschutter.annotations.compiletime.SuppressFBWarnings;
import com.kohlschutter.testutil.CommandAvailabilityRequirement;
import com.kohlschutter.testutil.ForkedVM;
import com.kohlschutter.testutil.ForkedVMRequirement;
import com.kohlschutter.util.ExceptionUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketAddress;
import java.time.Duration;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Semaphore;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.Test;
import org.newsclub.net.unix.AFSocketAddress;
import org.newsclub.net.unix.AddressSpecifics;
import org.newsclub.net.unix.FinalizeTestClient;
import org.newsclub.net.unix.SocketTestBase;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
@CommandAvailabilityRequirement(commands={"lsof"})
@ForkedVMRequirement(forkSupported=true)
@SuppressFBWarnings(value={"THROWS_METHOD_THROWS_CLAUSE_THROWABLE", "THROWS_METHOD_THROWS_CLAUSE_BASIC_EXCEPTION"})
public abstract class FinalizeTest<A extends SocketAddress>
extends SocketTestBase<A> {
    private Process process = null;

    protected FinalizeTest(AddressSpecifics<A> asp) {
        super(asp);
    }

    @Test
    public void testLeak() throws Exception {
        Assertions.assertTimeoutPreemptively((Duration)Duration.ofSeconds(10L), () -> {
            final Semaphore sema = new Semaphore(0);
            final CompletableFuture future = new CompletableFuture();
            try (SocketTestBase.ServerThread serverThread = new SocketTestBase.ServerThread(){

                @Override
                protected void onServerReady() {
                    sema.release();
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                protected void handleConnection(Socket socket) throws IOException {
                    try {
                        Assumptions.assumeTrue((FinalizeTest.this.process.pid() > 0L ? 1 : 0) != 0);
                        Object preRunCheck = null;
                        try (OutputStream out = socket.getOutputStream();
                             InputStream in = socket.getInputStream();){
                            preRunCheck = FinalizeTest.this.preRunCheck(FinalizeTest.this.process);
                            out.write(64);
                        }
                        finally {
                            future.complete(preRunCheck);
                        }
                    }
                    catch (Exception e) {
                        future.completeExceptionally(e);
                    }
                    finally {
                        this.stopAcceptingConnections();
                    }
                }
            };){
                sema.acquire();
                this.process = this.launchServerProcess(this.socketType(), ((AFSocketAddress)serverThread.getServerAddress()).getHostString());
                Object preRunCheck = future.get();
                this.postRunCheck(this.process, preRunCheck);
            }
            catch (ExecutionException e) {
                throw ExceptionUtil.unwrapExecutionException((ExecutionException)e);
            }
            finally {
                Process p = this.process;
                if (p != null) {
                    p.destroy();
                }
                this.process = null;
            }
        });
    }

    protected Object preRunCheck(Process p) throws IOException, InterruptedException {
        return null;
    }

    protected void postRunCheck(Process p, Object preRunCheck) throws IOException, InterruptedException {
    }

    private Process launchServerProcess(final String socketType, final String socketPath) throws IOException {
        ForkedVM vm = new ForkedVM(){

            protected void onJavaMainClass(String arg) {
                super.onJavaOption("-Dtest.junixsocket.socket.type=" + socketType);
                super.onJavaOption("-Dtest.junixsocket.socket=" + socketPath);
                super.onJavaMainClass(FinalizeTestClient.class.getName());
            }

            protected void onArguments(List<String> args) {
                super.onArguments(Collections.emptyList());
            }
        };
        vm.setRedirectError(ProcessBuilder.Redirect.INHERIT);
        vm.setRedirectOutput(ProcessBuilder.Redirect.INHERIT);
        return vm.fork();
    }

    protected abstract String socketType();
}

