/*
 * Decompiled with CFR 0.152.
 */
package org.newsclub.net.unix.vsock;

import com.kohlschutter.testutil.TestAbortedWithImportantMessageException;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.nio.channels.DatagramChannel;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import org.newsclub.net.unix.AFDatagramSocket;
import org.newsclub.net.unix.AFSelectorProvider;
import org.newsclub.net.unix.AFServerSocket;
import org.newsclub.net.unix.AFSocket;
import org.newsclub.net.unix.AFSocketAddress;
import org.newsclub.net.unix.AFVSOCKSocketAddress;
import org.newsclub.net.unix.AddressSpecifics;
import org.newsclub.net.unix.AddressUnavailableSocketException;
import org.newsclub.net.unix.CloseablePair;
import org.newsclub.net.unix.InvalidSocketException;
import org.newsclub.net.unix.vsock.AFVSOCKDatagramSocket;
import org.newsclub.net.unix.vsock.AFVSOCKSelectorProvider;
import org.newsclub.net.unix.vsock.AFVSOCKServerSocket;
import org.newsclub.net.unix.vsock.AFVSOCKSocket;
import org.newsclub.net.unix.vsock.AFVSOCKSocketPair;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public final class AFVSOCKAddressSpecifics
implements AddressSpecifics<AFVSOCKSocketAddress> {
    public static final AddressSpecifics<AFVSOCKSocketAddress> INSTANCE = new AFVSOCKAddressSpecifics();
    static final String KERNEL_TOO_OLD = "Kernel may be too old for full VSOCK support";
    static final String ACCESS_DENIED = "Access to VSOCK resources (e.g., /dev/vsock) were denied";

    private AFVSOCKAddressSpecifics() {
    }

    @Override
    public AFSocketAddress newTempAddress() throws IOException {
        return AFVSOCKSocketAddress.ofAnyLocalPort();
    }

    @Override
    public AFSocket<?> newSocket() throws IOException {
        return AFVSOCKSocket.newInstance();
    }

    @Override
    public AFSocket<?> newStrictSocket() throws IOException {
        return AFVSOCKSocket.newStrictInstance();
    }

    @Override
    public AFDatagramSocket<?> newDatagramSocket() throws IOException {
        return AFVSOCKDatagramSocket.newInstance();
    }

    @Override
    public DatagramChannel newDatagramChannel() throws IOException {
        return AFVSOCKDatagramSocket.newInstance().getChannel();
    }

    @Override
    public AFServerSocket<?> newServerSocket() throws IOException {
        return AFVSOCKServerSocket.newInstance();
    }

    @Override
    public AFSocketAddress newTempAddressForDatagram() throws IOException {
        return AFVSOCKSocketAddress.ofAnyPort();
    }

    @Override
    public AFSocketAddress unwrap(InetAddress addr, int port) throws SocketException {
        return AFVSOCKSocketAddress.unwrap(addr, port);
    }

    @Override
    public AFSelectorProvider<?> selectorProvider() {
        return AFVSOCKSelectorProvider.provider();
    }

    @Override
    public CloseablePair<? extends SocketChannel> newSocketPair() throws IOException {
        try {
            return AFVSOCKSocketPair.open();
        }
        catch (InvalidSocketException e) {
            throw AFVSOCKAddressSpecifics.handleSocketException((SocketException)e, "");
        }
    }

    @Override
    public CloseablePair<? extends DatagramChannel> newDatagramSocketPair() throws IOException {
        try {
            return AFVSOCKSocketPair.openDatagram();
        }
        catch (InvalidSocketException e) {
            throw AFVSOCKAddressSpecifics.handleSocketException((SocketException)e, "");
        }
    }

    @Override
    public AFServerSocket<?> newServerSocketBindOn(SocketAddress addr) throws IOException {
        try {
            return AFVSOCKServerSocket.bindOn((AFVSOCKSocketAddress)((AFVSOCKSocketAddress)addr));
        }
        catch (InvalidSocketException e) {
            throw AFVSOCKAddressSpecifics.handleSocketException((SocketException)e, addr);
        }
    }

    private static SocketException handleSocketException(SocketException e, String msg) throws SocketException, IOException {
        String shortMsg;
        if (e instanceof AddressUnavailableSocketException) {
            shortMsg = ACCESS_DENIED;
        } else if (e instanceof InvalidSocketException) {
            shortMsg = KERNEL_TOO_OLD;
        } else {
            return e;
        }
        if (AFVSOCKSocket.getLocalCID() == 2) {
            throw new TestAbortedWithImportantMessageException(TestAbortedWithImportantMessageException.MessageType.TEST_ABORTED_SHORT_INFORMATIONAL, msg == null || msg.isEmpty() ? shortMsg : shortMsg + ": " + msg, (Throwable)e);
        }
        return e;
    }

    private static SocketException handleSocketException(SocketException e, SocketAddress addr) throws IOException {
        if (!(addr instanceof AFVSOCKSocketAddress)) {
            return e;
        }
        AFVSOCKSocketAddress sa = (AFVSOCKSocketAddress)addr;
        switch (sa.getVSOCKCID()) {
            case 1: 
            case 2: {
                return AFVSOCKAddressSpecifics.handleSocketException(e, "Cannot connect to addresses with CID=" + sa.getVSOCKCID());
            }
        }
        return e;
    }

    @Override
    public void bindServerSocket(ServerSocket serverSocket, SocketAddress bindpoint) throws IOException {
        try {
            serverSocket.bind(bindpoint);
        }
        catch (InvalidSocketException e) {
            throw AFVSOCKAddressSpecifics.handleSocketException((SocketException)e, bindpoint);
        }
    }

    @Override
    public void bindServerSocket(ServerSocket serverSocket, SocketAddress bindpoint, int backlog) throws IOException {
        try {
            serverSocket.bind(bindpoint, backlog);
        }
        catch (InvalidSocketException e) {
            throw AFVSOCKAddressSpecifics.handleSocketException((SocketException)e, bindpoint);
        }
    }

    @Override
    public void bindServerSocket(ServerSocketChannel serverSocketChannel, SocketAddress bindpoint) throws IOException {
        try {
            serverSocketChannel.bind(bindpoint);
        }
        catch (InvalidSocketException e) {
            throw AFVSOCKAddressSpecifics.handleSocketException((SocketException)e, bindpoint);
        }
    }

    @Override
    public void bindServerSocket(ServerSocketChannel serverSocketChannel, SocketAddress bindpoint, int backlog) throws IOException {
        try {
            serverSocketChannel.bind(bindpoint, backlog);
        }
        catch (InvalidSocketException e) {
            throw AFVSOCKAddressSpecifics.handleSocketException((SocketException)e, bindpoint);
        }
    }

    @Override
    public Socket connectTo(SocketAddress addr) throws IOException {
        AFVSOCKSocketAddress sa = (AFVSOCKSocketAddress)addr;
        try {
            return AFVSOCKSocket.connectTo((AFVSOCKSocketAddress)sa);
        }
        catch (InvalidSocketException e) {
            throw AFVSOCKAddressSpecifics.handleSocketException((SocketException)e, sa);
        }
    }

    @Override
    public void connectSocket(Socket sock, SocketAddress addr) throws IOException {
        try {
            sock.connect(addr);
        }
        catch (InvalidSocketException e) {
            throw AFVSOCKAddressSpecifics.handleSocketException((SocketException)e, addr);
        }
    }

    @Override
    public boolean connectSocket(SocketChannel sock, SocketAddress addr) throws IOException {
        try {
            return sock.connect(addr);
        }
        catch (InvalidSocketException e) {
            throw AFVSOCKAddressSpecifics.handleSocketException((SocketException)e, addr);
        }
    }

    @Override
    public AFServerSocket<?> newServerSocketBindOn(SocketAddress addr, boolean deleteOnClose) throws IOException {
        try {
            return AFVSOCKServerSocket.bindOn((AFVSOCKSocketAddress)((AFVSOCKSocketAddress)addr), (boolean)deleteOnClose);
        }
        catch (InvalidSocketException e) {
            throw AFVSOCKAddressSpecifics.handleSocketException((SocketException)e, addr);
        }
    }

    @Override
    public CloseablePair<? extends Socket> newInterconnectedSockets() throws IOException {
        CloseablePair<? extends SocketChannel> sp = this.newSocketPair();
        return new CloseablePair<Socket>(sp.getFirst().socket(), sp.getSecond().socket());
    }
}

