/*
 * Decompiled with CFR 0.152.
 */
package org.newsclub.net.unix.tipc;

import com.kohlschutter.annotations.compiletime.SuppressFBWarnings;
import java.io.IOException;
import java.net.Socket;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.newsclub.net.unix.AFSocketCapability;
import org.newsclub.net.unix.AFSocketCapabilityRequirement;
import org.newsclub.net.unix.AFTIPCSocketAddress;
import org.newsclub.net.unix.tipc.AFTIPCAddressSpecifics;
import org.newsclub.net.unix.tipc.AFTIPCErrInfo;
import org.newsclub.net.unix.tipc.AFTIPCServerSocket;
import org.newsclub.net.unix.tipc.AFTIPCSocket;
import org.newsclub.net.unix.tipc.AFTIPCSocketChannel;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
@AFSocketCapabilityRequirement(value={AFSocketCapability.CAPABILITY_TIPC})
@SuppressFBWarnings(value={"NM_SAME_SIMPLE_NAME_AS_SUPERCLASS"})
public final class AncillaryMessageTest
extends org.newsclub.net.unix.AncillaryMessageTest<AFTIPCSocketAddress> {
    public AncillaryMessageTest() throws IOException {
        super(AFTIPCAddressSpecifics.INSTANCE);
    }

    @Test
    public void testConnectionAbort() throws IOException {
        AFTIPCServerSocket serverSocket = (AFTIPCServerSocket)this.newServerSocket();
        serverSocket.bind((SocketAddress)AFTIPCSocketAddress.ofService(AFTIPCSocketAddress.Scope.SCOPE_NODE, 1234, 0));
        AFTIPCSocketChannel socket = (AFTIPCSocketChannel)this.newSocket().getChannel();
        socket.setAncillaryReceiveBufferSize(8192);
        socket.configureBlocking(false);
        socket.connect((SocketAddress)serverSocket.getLocalSocketAddress());
        AFTIPCSocket clientSocket = serverSocket.accept();
        Assertions.assertEquals((Object)clientSocket.getRemoteSocketAddress(), (Object)socket.getLocalAddress());
        socket.configureBlocking(true);
        new Thread(() -> AncillaryMessageTest.lambda$testConnectionAbort$0((Socket)clientSocket)).start();
        ByteBuffer buf = ByteBuffer.allocate(4096);
        Assertions.assertEquals((int)-1, (int)socket.read(buf));
        Assertions.assertEquals((int)0, (int)buf.position());
        Assertions.assertEquals((Object)new AFTIPCErrInfo(AFTIPCErrInfo.ErrorCode.TIPC_ERR_CONN_SHUTDOWN, 0), (Object)socket.getErrInfo());
        Assertions.assertEquals(null, (Object)socket.getErrInfo());
    }

    @Test
    public void testDestName() throws IOException, InterruptedException, ExecutionException {
        AFTIPCServerSocket serverSocket = (AFTIPCServerSocket)this.newServerSocket();
        AFTIPCSocketAddress bindAddress = AFTIPCSocketAddress.ofServiceRange(AFTIPCSocketAddress.Scope.SCOPE_NODE, 1234, 56, 910);
        serverSocket.bind((SocketAddress)bindAddress);
        AFTIPCSocketChannel socket = (AFTIPCSocketChannel)this.newSocket().getChannel();
        socket.configureBlocking(false);
        AFTIPCSocketAddress connectAddress = AFTIPCSocketAddress.ofService(AFTIPCSocketAddress.Scope.SCOPE_NODE, 1234, 78);
        socket.connect((SocketAddress)connectAddress);
        AFTIPCSocket clientSocket = serverSocket.accept();
        clientSocket.setAncillaryReceiveBufferSize(8192);
        Assertions.assertEquals((Object)clientSocket.getRemoteSocketAddress(), (Object)socket.getLocalAddress());
        socket.configureBlocking(true);
        CompletableFuture bytesSent = new CompletableFuture();
        new Thread(() -> {
            try {
                ByteBuffer buf = ByteBuffer.allocate(4096);
                bytesSent.complete(clientSocket.getChannel().read(buf));
            }
            catch (IOException e) {
                bytesSent.completeExceptionally(e);
            }
        }).start();
        ByteBuffer buf = ByteBuffer.allocate(64);
        int written = socket.write(buf);
        Assertions.assertEquals((Integer)((Integer)bytesSent.get()), (int)written);
        Assertions.assertEquals((int)64, (Integer)((Integer)bytesSent.get()));
        Assertions.assertEquals((Object)connectAddress, (Object)clientSocket.getDestName().toSocketAddress(connectAddress.getScope(), false));
    }

    private static /* synthetic */ void lambda$testConnectionAbort$0(Socket clientSocket) {
        try {
            clientSocket.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

