/*
 * Decompiled with CFR 0.152.
 */
package org.newsclub.net.unix.domain;

import com.kohlschutter.annotations.compiletime.SuppressFBWarnings;
import java.io.File;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.newsclub.net.unix.AFSocketCapability;
import org.newsclub.net.unix.AFSocketCapabilityRequirement;
import org.newsclub.net.unix.AFUNIXSocket;
import org.newsclub.net.unix.AFUNIXSocketAddress;
import org.newsclub.net.unix.AFUNIXSocketFactory;
import org.newsclub.net.unix.SocketTestBase;
import org.newsclub.net.unix.domain.AFUNIXAddressSpecifics;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
@AFSocketCapabilityRequirement(value={AFSocketCapability.CAPABILITY_UNIX_DOMAIN})
@SuppressFBWarnings(value={"THROWS_METHOD_THROWS_CLAUSE_THROWABLE", "THROWS_METHOD_THROWS_CLAUSE_BASIC_EXCEPTION", "DMI_HARDCODED_ABSOLUTE_FILENAME"})
public final class SocketFactoryTest
extends SocketTestBase<AFUNIXSocketAddress> {
    public SocketFactoryTest() {
        super(AFUNIXAddressSpecifics.INSTANCE);
    }

    @Test
    public void testURISchemeCeateSocketThenConnect() throws Exception {
        AFUNIXSocketFactory.URIScheme factory = new AFUNIXSocketFactory.URIScheme();
        try (Socket sock = factory.createSocket();
             AFUNIXSocket socket = (AFUNIXSocket)sock;){
            Assertions.assertThrows(IllegalArgumentException.class, () -> socket.connect(null));
            Assertions.assertThrows(IllegalArgumentException.class, () -> socket.connect(new InetSocketAddress("http://example.com./", 0)));
            Assertions.assertThrows(IllegalArgumentException.class, () -> socket.connect(new InetSocketAddress("", 0)));
            Assertions.assertThrows(SocketException.class, () -> socket.connect(new InetSocketAddress("file://", 0)));
            Assertions.assertThrows(SocketException.class, () -> socket.connect(new InetSocketAddress("file://not-absolute", 0)));
            Assertions.assertThrows(SocketException.class, () -> socket.connect(new InetSocketAddress("file:///", 0)));
        }
    }

    @Test
    public void testURISchemeCeateSocketWithIllegalArguments() throws Exception {
        AFUNIXSocketFactory.URIScheme factory = new AFUNIXSocketFactory.URIScheme();
        Assertions.assertThrows(IllegalArgumentException.class, () -> {
            Socket sock = factory.createSocket("file:///", 0, null, -1);
            if (sock != null) {
                sock.close();
            }
        });
    }

    @Test
    public void testURISchemeCeateSocketWithInvalidHostname() throws Exception {
        AFUNIXSocketFactory.URIScheme factory = new AFUNIXSocketFactory.URIScheme();
        Assertions.assertThrows(SocketException.class, () -> {
            Socket sock = factory.createSocket("", 0);
            if (sock != null) {
                sock.close();
            }
        });
        Assertions.assertThrows(SocketException.class, () -> {
            Socket sock = factory.createSocket("", 0, null, 0);
            if (sock != null) {
                sock.close();
            }
        });
        Assertions.assertThrows(SocketException.class, () -> {
            Socket sock = factory.createSocket(InetAddress.getByName(""), 0);
            if (sock != null) {
                sock.close();
            }
        });
        Assertions.assertThrows(SocketException.class, () -> {
            Socket sock = factory.createSocket(InetAddress.getLoopbackAddress(), 0, null, 0);
            if (sock != null) {
                sock.close();
            }
        });
        Assertions.assertThrows(SocketException.class, () -> {
            Socket sock = factory.createSocket("file:", 0);
            if (sock != null) {
                sock.close();
            }
        });
        Assertions.assertThrows(SocketException.class, () -> {
            Socket sock = factory.createSocket("file:/", 0);
            if (sock != null) {
                sock.close();
            }
        });
        Assertions.assertThrows(SocketException.class, () -> {
            Socket sock = factory.createSocket("file://", 0);
            if (sock != null) {
                sock.close();
            }
        });
        Assertions.assertThrows(SocketException.class, () -> {
            Socket sock = factory.createSocket("file://not-absolute", 0);
            if (sock != null) {
                sock.close();
            }
        });
        Assertions.assertThrows(SocketException.class, () -> {
            Socket sock = factory.createSocket("[", 0);
            if (sock != null) {
                sock.close();
            }
        });
        Assertions.assertThrows(SocketException.class, () -> {
            Socket sock = factory.createSocket("file%3A%2F%2F%", 0);
            if (sock != null) {
                sock.close();
            }
        });
    }

    @Test
    public void testURISchemeCeateSocketWithHostnameValidCases() throws Exception {
        AFUNIXSocketFactory.URIScheme factory = new AFUNIXSocketFactory.URIScheme();
        Assertions.assertThrows(SocketException.class, () -> {
            Socket sock = factory.createSocket("file:///", 0);
            if (sock != null) {
                sock.close();
            }
        });
        Assertions.assertThrows(SocketException.class, () -> {
            Socket sock = factory.createSocket("file://localhost/", 0);
            if (sock != null) {
                sock.close();
            }
        });
        Assertions.assertThrows(SocketException.class, () -> {
            Socket sock = factory.createSocket("[file:///]", 0);
            if (sock != null) {
                sock.close();
            }
        });
        Assertions.assertThrows(SocketException.class, () -> {
            Socket sock = factory.createSocket("[file:///", 0);
            if (sock != null) {
                sock.close();
            }
        });
        Assertions.assertThrows(SocketException.class, () -> {
            Socket sock = factory.createSocket("file%3A%2F%2F%2F", 0);
            if (sock != null) {
                sock.close();
            }
        });
        Assertions.assertThrows(SocketException.class, () -> {
            Socket sock = factory.createSocket("file%3A%2F%2Flocalhost%2F", 0);
            if (sock != null) {
                sock.close();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSystemProperty() throws Exception {
        AFUNIXSocketFactory.SystemProperty factory = new AFUNIXSocketFactory.SystemProperty();
        String hostnameToConnectTo = System.getProperty("org.newsclub.net.unix.socket.hostname", "localhost");
        String existingSocketDefault = System.getProperty("org.newsclub.net.unix.socket.default");
        try {
            System.clearProperty("org.newsclub.net.unix.socket.default");
            Assertions.assertThrows(IllegalStateException.class, () -> {
                Socket sock = factory.createSocket(hostnameToConnectTo, 0);
                if (sock != null) {
                    sock.close();
                }
            });
            System.setProperty("org.newsclub.net.unix.socket.default", "");
            Assertions.assertThrows(IllegalStateException.class, () -> {
                Socket sock = factory.createSocket(hostnameToConnectTo, 0);
                if (sock != null) {
                    sock.close();
                }
            });
            System.setProperty("org.newsclub.net.unix.socket.default", "/");
            Assertions.assertThrows(SocketException.class, () -> {
                Socket sock = factory.createSocket(hostnameToConnectTo, 0);
                if (sock != null) {
                    sock.close();
                }
            });
        }
        finally {
            if (existingSocketDefault == null) {
                System.clearProperty("org.newsclub.net.unix.socket.default");
            } else {
                System.setProperty("org.newsclub.net.unix.socket.default", existingSocketDefault);
            }
        }
    }

    @Test
    public void testFactoryArg() throws Exception {
        String hostnameToConnectTo = System.getProperty("org.newsclub.net.unix.socket.hostname", "localhost");
        Assertions.assertThrows(SocketException.class, () -> {
            AFUNIXSocketFactory.FactoryArg factory = new AFUNIXSocketFactory.FactoryArg("/");
            Socket sock = factory.createSocket(hostnameToConnectTo, 0);
            if (sock != null) {
                sock.close();
            }
        });
        Assertions.assertThrows(SocketException.class, () -> {
            AFUNIXSocketFactory.FactoryArg factory = new AFUNIXSocketFactory.FactoryArg(new File("/"));
            Socket sock = factory.createSocket(hostnameToConnectTo, 0);
            if (sock != null) {
                sock.close();
            }
        });
    }
}

