/*
 * Decompiled with CFR 0.152.
 */
package org.newsclub.net.unix;

import java.net.InetSocketAddress;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.newsclub.net.unix.AFTIPCSocketAddressTest;
import org.newsclub.net.unix.AFUNIXSocketAddress;
import org.newsclub.net.unix.AFUNIXSocketAddressTest;
import org.newsclub.net.unix.FileDescriptorCastTest;
import org.newsclub.net.unix.InetAddressTest;
import org.newsclub.net.unix.PipeTest;
import org.newsclub.net.unix.SocketTestBase;
import org.newsclub.net.unix.domain.AcceptTimeoutTest;
import org.newsclub.net.unix.domain.AvailableTest;
import org.newsclub.net.unix.domain.BufferOverflowTest;
import org.newsclub.net.unix.domain.CancelAcceptTest;
import org.newsclub.net.unix.domain.DatagramSocketTest;
import org.newsclub.net.unix.domain.EndOfFileTest;
import org.newsclub.net.unix.domain.FileDescriptorsTest;
import org.newsclub.net.unix.domain.PeerCredentialsTest;
import org.newsclub.net.unix.domain.ReadWriteTest;
import org.newsclub.net.unix.domain.ServerSocketCloseTest;
import org.newsclub.net.unix.domain.ServerSocketTest;
import org.newsclub.net.unix.domain.SoTimeoutTest;
import org.newsclub.net.unix.domain.SocketAddressTest;
import org.newsclub.net.unix.domain.SocketChannelTest;
import org.newsclub.net.unix.domain.SocketFactoryTest;
import org.newsclub.net.unix.domain.SocketPairTest;
import org.newsclub.net.unix.domain.SocketTest;
import org.newsclub.net.unix.domain.StandardSocketOptionsTest;
import org.newsclub.net.unix.domain.TcpNoDelayTest;
import org.newsclub.net.unix.java.SelectorTest;
import org.newsclub.net.unix.java.ThroughputTest;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class SelftestProvider {
    final Map<String, LinkedHashSet<Class<?>>> testMap = new LinkedHashMap();

    public SelftestProvider() {
        this.registerTest("junixsocket-common", AFTIPCSocketAddressTest.class);
        this.registerTest("junixsocket-common", AFUNIXSocketAddressTest.class);
        this.registerTest(AcceptTimeoutTest.class);
        this.registerTest(AvailableTest.class);
        this.registerTest(BufferOverflowTest.class);
        this.registerTest(CancelAcceptTest.class);
        this.registerTest(DatagramSocketTest.class);
        this.registerTest(EndOfFileTest.class);
        this.registerTest("junixsocket-common", FileDescriptorCastTest.class);
        this.registerTest("junixsocket-common", org.newsclub.net.unix.domain.FileDescriptorCastTest.class);
        this.registerTest(FileDescriptorsTest.class);
        this.registerTest(InetAddressTest.class);
        this.registerTest(PeerCredentialsTest.class);
        this.registerTest("junixsocket-common", PipeTest.class);
        this.registerTest(ReadWriteTest.class);
        this.registerTest(org.newsclub.net.unix.domain.SelectorTest.class);
        this.registerTestJavaInet(SelectorTest.class);
        this.registerTest(ServerSocketCloseTest.class);
        this.registerTest(ServerSocketTest.class);
        this.registerTest(SocketAddressTest.class);
        this.registerTest(SocketChannelTest.class);
        this.registerTest(SocketFactoryTest.class);
        this.registerTest(SocketPairTest.class);
        this.registerTest(SocketTest.class);
        this.registerTest(SoTimeoutTest.class);
        this.registerTest(StandardSocketOptionsTest.class);
        this.registerTest(TcpNoDelayTest.class);
        this.registerTest(org.newsclub.net.unix.domain.ThroughputTest.class);
        this.registerTestJavaInet(ThroughputTest.class);
    }

    public Set<String> modulesDisabledByDefault() {
        return Collections.singleton("junixsocket-common.JavaInet");
    }

    private void registerTest(Class<? extends SocketTestBase<AFUNIXSocketAddress>> testUnixDomain) {
        this.registerTest("junixsocket-common", testUnixDomain);
    }

    private void registerTestJavaInet(Class<? extends SocketTestBase<InetSocketAddress>> testJava) {
        this.registerTest("junixsocket-common.JavaInet", testJava);
    }

    private void registerTest(String group, Class<?> test) {
        if (test != null) {
            this.testMap.computeIfAbsent(group, key -> new LinkedHashSet()).add(test);
        }
    }

    public Map<String, Class<?>[]> tests() {
        LinkedHashMap<String, Class<?>[]> tests = new LinkedHashMap<String, Class<?>[]>();
        this.testMap.forEach((key, set) -> tests.put((String)key, set.toArray(new Class[0])));
        return tests;
    }
}

