/*
 * Decompiled with CFR 0.152.
 */
package org.newsclub.net.unix;

import com.kohlschutter.annotations.compiletime.ExcludeFromCodeCoverageGeneratedReport;
import java.net.DatagramPacket;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public final class AFDatagramUtil {
    @ExcludeFromCodeCoverageGeneratedReport
    private AFDatagramUtil() {
        throw new IllegalStateException("No instances");
    }

    public static DatagramPacket datagramWithCapacityAndPayload(byte[] payload) {
        return new DatagramPacket(payload, payload.length);
    }

    public static DatagramPacket datagramWithCapacityAndPayload(int capacity, byte[] payload) {
        if (capacity < payload.length) {
            throw new IllegalArgumentException("data exceeds capacity");
        }
        if (capacity == payload.length) {
            return new DatagramPacket(payload, payload.length);
        }
        byte[] buf = new byte[capacity];
        System.arraycopy(payload, 0, buf, 0, payload.length);
        DatagramPacket dp = new DatagramPacket(buf, buf.length);
        dp.setLength(payload.length);
        return dp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void expandToCapacity(DatagramPacket dp) {
        DatagramPacket datagramPacket = dp;
        synchronized (datagramPacket) {
            byte[] data = dp.getData();
            dp.setLength(data.length - dp.getOffset());
        }
    }

    public static DatagramPacket datagramWithCapacity(int i) {
        return new DatagramPacket(new byte[i], i);
    }
}

