/*
 * Decompiled with CFR 0.152.
 */
package org.newsclub.net.unix;

import com.kohlschutter.annotations.compiletime.SuppressFBWarnings;
import com.kohlschutter.testutil.SoftAssertions;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.NetworkInterface;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketOption;
import java.net.StandardSocketOptions;
import java.time.Duration;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.Callable;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.newsclub.net.unix.AddressSpecifics;
import org.newsclub.net.unix.SocketTestBase;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
@SuppressFBWarnings(value={"THROWS_METHOD_THROWS_CLAUSE_THROWABLE", "THROWS_METHOD_THROWS_CLAUSE_BASIC_EXCEPTION"})
public abstract class StandardSocketOptionsTest<A extends SocketAddress>
extends SocketTestBase<A> {
    private static final Set<SocketOption<?>> IGNORABLE_OPTIONS = Set.of(StandardSocketOptions.IP_TOS, StandardSocketOptions.TCP_NODELAY, StandardSocketOptions.SO_KEEPALIVE);
    private SoftAssertions softAssertions;

    protected StandardSocketOptionsTest(AddressSpecifics<A> asp) {
        super(asp);
    }

    @BeforeEach
    public void beforeEach() {
        this.softAssertions = new SoftAssertions();
    }

    @AfterEach
    public void afterEach() {
        this.softAssertions.assumePass();
    }

    @Test
    public void testUnconnectedServerSocketOptions() throws Exception {
        try (ServerSocket sock = this.newServerSocketBindOn(this.newTempAddress(), true);
             TestStateServerSocket state = new TestStateServerSocket(sock);){
            ((TestState)state).testSocketOption(StandardSocketOptions.SO_RCVBUF, null, 1024, null);
            ((TestState)state).testSocketOption(StandardSocketOptions.SO_REUSEADDR, null, true, true);
            ((TestState)state).testSocketOption(StandardSocketOptions.IP_MULTICAST_IF, null, NetworkInterface.getByIndex(0), null);
            ((TestState)state).testSocketOption(StandardSocketOptions.IP_MULTICAST_LOOP, null, true, null);
            ((TestState)state).testSocketOption(StandardSocketOptions.IP_MULTICAST_TTL, null, 123, null);
            ((TestState)state).testSocketOption(StandardSocketOptions.SO_BROADCAST, null, true, null);
            ((TestState)state).testSocketOption(StandardSocketOptions.SO_REUSEPORT, null, true, null);
            ((TestState)state).testSocketOption(StandardSocketOptions.TCP_NODELAY, null, true, null);
            ((TestState)state).testSocketOption(StandardSocketOptions.SO_SNDBUF, null, 4096, null);
            ((TestState)state).testSocketOption(StandardSocketOptions.SO_LINGER, null, 123, null);
            ((TestState)state).testSocketOption(StandardSocketOptions.SO_KEEPALIVE, null, null, null);
            ((TestState)state).coveredSupportedOptions.addAll(Set.of(StandardSocketOptions.TCP_NODELAY, StandardSocketOptions.SO_SNDBUF, StandardSocketOptions.SO_LINGER, StandardSocketOptions.SO_KEEPALIVE));
            ((TestState)state).testSocketOption(StandardSocketOptions.IP_TOS, 0, 3, 0);
        }
    }

    @Test
    public void testSocketOptions() throws Exception {
        Assertions.assertTimeoutPreemptively((Duration)Duration.ofSeconds(2L), () -> {
            try (SocketTestBase.ServerThread serverThread = new SocketTestBase.ServerThread(){

                @Override
                protected void handleConnection(Socket sock) throws IOException {
                    try (TestStateSocket state = new TestStateSocket(sock);){
                        ((TestState)state).testSocketOption(StandardSocketOptions.SO_REUSEADDR, null, true, true);
                        ((TestState)state).testSocketOption(StandardSocketOptions.SO_RCVBUF, null, 8192, null);
                        ((TestState)state).testSocketOption(StandardSocketOptions.SO_SNDBUF, null, 8192, null);
                        ((TestState)state).testSocketOption(StandardSocketOptions.SO_LINGER, null, 123, null);
                        ((TestState)state).testSocketOption(StandardSocketOptions.SO_KEEPALIVE, null, true, null);
                        try (OutputStream out = sock.getOutputStream();){
                            out.write(175);
                        }
                    }
                }
            };
                 Socket sock = this.connectTo(serverThread.getServerAddress());
                 InputStream in = sock.getInputStream();){
                Assertions.assertEquals((int)175, (int)in.read());
            }
        });
    }

    private class TestStateServerSocket
    extends TestState<ServerSocket> {
        TestStateServerSocket(ServerSocket sock) {
            super(StandardSocketOptionsTest.this, (Closeable)sock);
        }

        @Override
        protected <T> T getOption(SocketOption<T> option) throws IOException {
            return ((ServerSocket)this.sock).getOption(option);
        }

        @Override
        protected <T> Closeable setOption(SocketOption<T> option, T value) throws IOException {
            return ((ServerSocket)this.sock).setOption(option, value);
        }

        @Override
        protected Set<SocketOption<?>> supportedOptions() throws IOException {
            return ((ServerSocket)this.sock).supportedOptions();
        }
    }

    static abstract class TestState<S extends Closeable>
    implements Closeable {
        protected final S sock;
        private final Set<SocketOption<?>> coveredSupportedOptions = new HashSet();
        final /* synthetic */ StandardSocketOptionsTest this$0;

        protected TestState(S sock) {
            this.this$0 = this$0;
            this.sock = sock;
        }

        @Override
        public void close() throws AssertionError, IOException {
            Set<SocketOption<?>> sockSupportedOptions = this.supportedOptions();
            this.coveredSupportedOptions.removeAll(IGNORABLE_OPTIONS);
            for (SocketOption<?> opt : sockSupportedOptions) {
                if (this.coveredSupportedOptions.contains(opt)) continue;
                Assumptions.assumeTrue((boolean)false, (String)("Test did not cover supported option: " + opt));
            }
            for (SocketOption<?> opt : this.coveredSupportedOptions) {
                if (sockSupportedOptions.contains(opt)) continue;
                Assertions.fail((String)(this.sock.getClass() + "#supportedOptions does not cover supported option: " + opt));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private <T> void testSocketOption(SocketOption<T> option, T oldValExpected, T setVal, T newValExpected) {
            boolean unsupportedIsNotAFailure = newValExpected == null;
            try {
                Object prevVal = this.checkUnsupported(option, unsupportedIsNotAFailure, () -> this.getOption(option));
                if (oldValExpected != null) {
                    Assertions.assertEquals(oldValExpected, (Object)prevVal, () -> "Unexpected old value for " + option);
                }
                try {
                    Assertions.assertEquals(this.sock, (Object)this.checkUnsupported(option, unsupportedIsNotAFailure, () -> this.setOption(option, setVal)));
                    Object newVal = this.checkUnsupported(option, unsupportedIsNotAFailure, () -> this.getOption(option));
                    if (newValExpected != null) {
                        Assertions.assertEquals(newValExpected, (Object)newVal, () -> "Unexpected new value for " + option);
                    }
                }
                finally {
                    this.checkUnsupported(option, unsupportedIsNotAFailure, () -> this.setOption(option, prevVal));
                }
            }
            catch (UnsupportedOperationException e) {
                return;
            }
            this.coveredSupportedOptions.add(option);
        }

        protected abstract <T> T getOption(SocketOption<T> var1) throws IOException;

        protected abstract <T> Closeable setOption(SocketOption<T> var1, T var2) throws IOException;

        protected abstract Set<SocketOption<?>> supportedOptions() throws IOException;

        protected <R> R checkUnsupported(SocketOption<?> option, boolean unsupportedIsNotAFailure, Callable<R> r) {
            try {
                return r.call();
            }
            catch (UnsupportedOperationException e) {
                if (!unsupportedIsNotAFailure) {
                    this.this$0.softAssertions.fail("Unsupported socket option: " + option, (Throwable)e);
                }
                throw e;
            }
            catch (Exception e) {
                if (!unsupportedIsNotAFailure || !e.getMessage().toLowerCase(Locale.ENGLISH).contains("support")) {
                    this.this$0.softAssertions.fail("Unsupported socket option: " + option, (Throwable)e);
                }
                throw new UnsupportedOperationException(e);
            }
        }
    }

    private class TestStateSocket
    extends TestState<Socket> {
        TestStateSocket(Socket sock) {
            super(StandardSocketOptionsTest.this, (Closeable)sock);
        }

        @Override
        protected <T> T getOption(SocketOption<T> option) throws IOException {
            return ((Socket)this.sock).getOption(option);
        }

        @Override
        protected <T> Closeable setOption(SocketOption<T> option, T value) throws IOException {
            return ((Socket)this.sock).setOption(option, value);
        }

        @Override
        protected Set<SocketOption<?>> supportedOptions() throws IOException {
            return ((Socket)this.sock).supportedOptions();
        }
    }
}

