/*
 * Decompiled with CFR 0.152.
 */
package org.newsclub.net.unix;

import com.kohlschutter.annotations.compiletime.SuppressFBWarnings;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;
import java.nio.channels.SocketChannel;
import java.util.Objects;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.newsclub.net.unix.AFSocketCapability;
import org.newsclub.net.unix.AFSocketCapabilityRequirement;
import org.newsclub.net.unix.AFUNIXDatagramChannel;
import org.newsclub.net.unix.AFUNIXSocketAddress;
import org.newsclub.net.unix.AFUNIXSocketChannel;
import org.newsclub.net.unix.AddressSpecifics;
import org.newsclub.net.unix.CloseablePair;
import org.newsclub.net.unix.SocketTestBase;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
@SuppressFBWarnings(value={"THROWS_METHOD_THROWS_CLAUSE_THROWABLE", "THROWS_METHOD_THROWS_CLAUSE_BASIC_EXCEPTION"})
public abstract class SocketPairTest<A extends SocketAddress>
extends SocketTestBase<A> {
    protected SocketPairTest(AddressSpecifics<A> asp) {
        super(asp);
    }

    @Test
    public void testSocketPair() throws Exception {
        CloseablePair<SocketChannel> pair = this.newSocketPair();
        SocketChannel sc1 = pair.getFirst();
        SocketChannel sc2 = pair.getSecond();
        Objects.requireNonNull(sc1);
        Objects.requireNonNull(sc2);
        Assertions.assertTrue((boolean)sc1.isConnected());
        Assertions.assertTrue((boolean)sc2.isConnected());
        Assertions.assertNotEquals((Object)pair.getFirst(), (Object)pair.getSecond());
        Assertions.assertNotEquals((Object)pair.getFirst().socket(), (Object)pair.getSecond().socket());
        if (sc1 instanceof AFUNIXSocketChannel) {
            Assertions.assertEquals((Object)((AFUNIXSocketChannel)sc1).getPeerCredentials(), (Object)((AFUNIXSocketChannel)sc2).getPeerCredentials());
        }
        ByteBuffer bb = ByteBuffer.allocate(4096);
        bb.putInt(67305985);
        bb.flip();
        sc1.write(bb);
        ByteBuffer bb2 = ByteBuffer.allocate(4096);
        sc2.read(bb2);
        bb2.flip();
        Assertions.assertEquals((int)67305985, (int)bb2.getInt());
        if (this.getServerBindAddress() instanceof AFUNIXSocketAddress) {
            Assertions.assertNull((Object)pair.getFirst().getLocalAddress());
            Assertions.assertNull((Object)pair.getSecond().getLocalAddress());
            Assertions.assertNull((Object)pair.getFirst().getRemoteAddress());
            Assertions.assertNull((Object)pair.getSecond().getRemoteAddress());
        } else {
            Assertions.assertEquals((Object)pair.getFirst().getLocalAddress(), (Object)pair.getSecond().getRemoteAddress());
            Assertions.assertEquals((Object)pair.getSecond().getLocalAddress(), (Object)pair.getFirst().getRemoteAddress());
        }
    }

    @Test
    @AFSocketCapabilityRequirement(value={AFSocketCapability.CAPABILITY_UNIX_DATAGRAMS})
    public void testDatagramPair() throws Exception {
        CloseablePair<DatagramChannel> pair = this.newDatagramSocketPair();
        DatagramChannel sc1 = pair.getFirst();
        DatagramChannel sc2 = pair.getSecond();
        Objects.requireNonNull(sc1);
        Objects.requireNonNull(sc2);
        Assertions.assertTrue((boolean)sc1.isConnected());
        Assertions.assertTrue((boolean)sc2.isConnected());
        Assertions.assertNotEquals((Object)pair.getFirst(), (Object)pair.getSecond());
        Assertions.assertNotEquals((Object)pair.getFirst().socket(), (Object)pair.getSecond().socket());
        if (sc1 instanceof AFUNIXDatagramChannel) {
            Assertions.assertEquals((Object)((AFUNIXDatagramChannel)sc1).getPeerCredentials(), (Object)((AFUNIXDatagramChannel)sc2).getPeerCredentials());
        }
        ByteBuffer bb = ByteBuffer.allocate(4096);
        bb.putInt(67305985);
        bb.flip();
        sc1.write(bb);
        ByteBuffer bb2 = ByteBuffer.allocate(4096);
        sc2.read(bb2);
        bb2.flip();
        Assertions.assertEquals((int)67305985, (int)bb2.getInt());
        if (this.getServerBindAddress() instanceof AFUNIXSocketAddress) {
            Assertions.assertNull((Object)pair.getFirst().getLocalAddress());
            Assertions.assertNull((Object)pair.getSecond().getLocalAddress());
            Assertions.assertNull((Object)pair.getFirst().getRemoteAddress());
            Assertions.assertNull((Object)pair.getSecond().getRemoteAddress());
        } else {
            Assertions.assertEquals((Object)pair.getFirst().getLocalAddress(), (Object)pair.getSecond().getRemoteAddress());
            Assertions.assertEquals((Object)pair.getSecond().getLocalAddress(), (Object)pair.getFirst().getRemoteAddress());
        }
    }
}

