/*
 * Decompiled with CFR 0.152.
 */
package org.newsclub.net.unix;

import com.kohlschutter.annotations.compiletime.SuppressFBWarnings;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketAddress;
import java.time.Duration;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.newsclub.net.unix.AddressSpecifics;
import org.newsclub.net.unix.SocketTestBase;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
@SuppressFBWarnings(value={"THROWS_METHOD_THROWS_CLAUSE_THROWABLE", "THROWS_METHOD_THROWS_CLAUSE_BASIC_EXCEPTION", "RANGE_ARRAY_LENGTH"})
public abstract class BufferOverflowTest<A extends SocketAddress>
extends SocketTestBase<A> {
    private ServerSocket server;
    private ExecutorService executor;

    protected BufferOverflowTest(AddressSpecifics<A> asp) {
        super(asp);
    }

    @BeforeEach
    public void setUp() throws IOException {
        this.server = this.newServerSocket();
        this.server.bind(this.getServerBindAddress());
        this.executor = Executors.newFixedThreadPool(2);
    }

    @AfterEach
    public void tearDown() throws IOException {
        try {
            if (this.server != null) {
                this.server.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (this.executor != null) {
            this.executor.shutdown();
        }
    }

    Socket[] connect() throws Exception {
        Socket clientSocket = this.newSocket();
        Future<Socket> serverAcceptFuture = this.executor.submit(new Callable<Socket>(){

            @Override
            public Socket call() throws Exception {
                return BufferOverflowTest.this.server.accept();
            }
        });
        Thread.sleep(100L);
        clientSocket.connect(this.server.getLocalSocketAddress());
        Socket serverSocket = serverAcceptFuture.get(100L, TimeUnit.MILLISECONDS);
        return new Socket[]{serverSocket, clientSocket};
    }

    @Test
    public void readOutOfBounds() throws Exception {
        Assertions.assertTimeoutPreemptively((Duration)Duration.ofSeconds(2L), () -> {
            Socket[] sockets = this.connect();
            try (Socket serverSocket = sockets[0];
                 Socket clientSocket = sockets[1];){
                byte[] input = new byte[16];
                byte[] output = new byte[15];
                try (OutputStream clientOutStream = clientSocket.getOutputStream();
                     InputStream serverInStream = serverSocket.getInputStream();){
                    clientOutStream.write(input, 0, 16);
                    int numRead = serverInStream.read(output, 0, 16);
                    Assertions.fail((String)("The call to read should have thrown an IndexOutOfBoundsException, read: " + numRead + " bytes"));
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    // empty catch block
                }
            }
        });
    }

    @Test
    public void readUpTo() throws Exception {
        Assertions.assertTimeoutPreemptively((Duration)Duration.ofSeconds(2L), () -> {
            Socket[] sockets = this.connect();
            try (Socket serverSocket = sockets[0];
                 Socket clientSocket = sockets[1];){
                byte[] input = new byte[16];
                byte[] output = new byte[256];
                try (OutputStream clientOutStream = clientSocket.getOutputStream();
                     InputStream serverInStream = serverSocket.getInputStream();){
                    clientOutStream.write(input, 0, 16);
                    int numRead = serverInStream.read(output, 0, 256);
                    Assertions.assertEquals((int)16, (int)numRead, (String)"Number of bytes read mismatch");
                }
            }
        });
    }

    @Test
    public void writeOverflow() throws Exception {
        Assertions.assertTimeoutPreemptively((Duration)Duration.ofSeconds(2L), () -> {
            Socket[] sockets = this.connect();
            try (Socket serverSocket = sockets[0];
                 Socket clientSocket = sockets[1];){
                byte[] input = new byte[15];
                byte[] output = new byte[16];
                try (OutputStream clientOutStream = clientSocket.getOutputStream();
                     InputStream serverInStream = serverSocket.getInputStream();){
                    try {
                        clientOutStream.write(input, 0, 16);
                        int numRead = serverInStream.read(output, 0, 15);
                        Assertions.assertEquals((int)15, (int)numRead);
                        serverInStream.read();
                        Assertions.fail((String)"The call to read should have thrown an IndexOutOfBoundsException");
                    }
                    catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                        // empty catch block
                    }
                }
            }
        });
    }
}

