/*
 * Decompiled with CFR 0.152.
 */
package org.newsclub.net.unix.rmi;

import com.kohlschutter.util.IOUtil;
import java.io.Closeable;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.rmi.Remote;
import java.rmi.server.RMISocketFactory;
import java.util.Arrays;
import org.junit.jupiter.api.Assertions;
import org.newsclub.net.unix.AFUNIXSocketCredentials;
import org.newsclub.net.unix.rmi.AFUNIXNaming;
import org.newsclub.net.unix.rmi.AFUNIXRMISocketFactory;
import org.newsclub.net.unix.rmi.NaiveFileInputStreamRemote;
import org.newsclub.net.unix.rmi.NaiveFileInputStreamRemoteImpl;
import org.newsclub.net.unix.rmi.RemoteCloseable;
import org.newsclub.net.unix.rmi.RemoteCloseableImpl;
import org.newsclub.net.unix.rmi.RemoteCloseableThing;
import org.newsclub.net.unix.rmi.RemoteCloseableThingImpl;
import org.newsclub.net.unix.rmi.RemoteFileDescriptor;
import org.newsclub.net.unix.rmi.RemoteFileInput;
import org.newsclub.net.unix.rmi.RemoteFileOutput;
import org.newsclub.net.unix.rmi.RemotePeerInfo;
import org.newsclub.net.unix.rmi.TestService;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class TestServiceImpl
implements TestService,
Closeable {
    private final File tmpFile;
    private final AFUNIXRMISocketFactory socketFactory;
    private final RemoteCloseableThingImpl.NotCloseableImpl testNotCloseableImpl = new RemoteCloseableThingImpl.NotCloseableImpl();
    private final RemoteCloseableThingImpl.IsCloseableImpl testCloseableImpl = new RemoteCloseableThingImpl.IsCloseableImpl();

    public TestServiceImpl(AFUNIXRMISocketFactory socketFactory) throws IOException {
        this.socketFactory = socketFactory;
        this.tmpFile = File.createTempFile("FDTestService", ".tmp");
        this.tmpFile.deleteOnExit();
        AFUNIXNaming.exportObject((Remote)this, (RMISocketFactory)socketFactory);
    }

    @Override
    public RemoteFileDescriptor stdout() throws IOException {
        return new RemoteFileDescriptor(this.socketFactory, FileDescriptor.out);
    }

    @Override
    public RemoteFileInput input() throws IOException {
        return new RemoteFileInput(this.socketFactory, new FileInputStream(this.tmpFile));
    }

    @Override
    public RemoteFileInput input(long skipBytes) throws IOException {
        FileInputStream fin = new FileInputStream(this.tmpFile);
        try {
            long skipped;
            while (skipBytes > 0L && (skipped = fin.skip(skipBytes)) >= 0L) {
                skipBytes -= skipped;
            }
            return new RemoteFileInput(this.socketFactory, fin);
        }
        catch (IOException e) {
            fin.close();
            throw e;
        }
    }

    @Override
    public RemoteFileOutput output() throws IOException {
        return new RemoteFileOutput(this.socketFactory, new FileOutputStream(this.tmpFile));
    }

    @Override
    public void verifyContents(byte[] expectedData) throws IOException {
        try (FileInputStream fin = new FileInputStream(this.tmpFile);){
            byte[] bytes = IOUtil.readAllBytes((InputStream)fin);
            if (!Arrays.equals(bytes, expectedData)) {
                throw new IOException("Unexpected bytes");
            }
        }
    }

    @Override
    public void verifyContents(int numBytes, byte[] expectedData) throws IOException {
        try (FileInputStream fin = new FileInputStream(this.tmpFile);){
            byte[] bytes = new byte[numBytes];
            int numRead = fin.read(bytes);
            if (numRead != bytes.length || !Arrays.equals(bytes, expectedData)) {
                throw new IOException("Unexpected bytes");
            }
        }
    }

    @Override
    public void deleteFile() throws IOException {
        Files.deleteIfExists(this.tmpFile.toPath());
    }

    @Override
    public void touchFile() throws IOException {
        Files.createFile(this.tmpFile.toPath(), new FileAttribute[0]);
    }

    @Override
    public NaiveFileInputStreamRemote naiveInputStreamRemote() throws IOException {
        return new NaiveFileInputStreamRemoteImpl(this.socketFactory, this.tmpFile);
    }

    @Override
    public void close() throws IOException {
        AFUNIXNaming.unexportObject((Remote)this);
        this.deleteFile();
    }

    @Override
    public AFUNIXSocketCredentials remotePeerCredentials() {
        AFUNIXSocketCredentials creds = AFUNIXSocketCredentials.remotePeerCredentials();
        AFUNIXSocketCredentials credsRpi = RemotePeerInfo.remotePeerCredentials();
        Assertions.assertEquals((Object)creds, (Object)credsRpi);
        return creds;
    }

    @Override
    public <T extends RemoteCloseableThing> RemoteCloseable<? extends T> remoteCloseable(Class<T> klass) throws IOException {
        if (klass.equals(RemoteCloseableThing.NotCloseable.class)) {
            return new RemoteCloseableImpl((RMISocketFactory)this.socketFactory, (Object)this.testNotCloseableImpl);
        }
        if (klass.equals(RemoteCloseableThing.IsCloseable.class)) {
            return new RemoteCloseableImpl((RMISocketFactory)this.socketFactory, (Object)this.testCloseableImpl);
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public <T extends RemoteCloseableThing> void remoteCloseableThingResetNumberOfCloseCalls(Class<T> klass) throws IOException {
        if (klass.equals(RemoteCloseableThing.NotCloseable.class)) {
            this.testNotCloseableImpl.resetCount();
        } else if (klass.equals(RemoteCloseableThing.IsCloseable.class)) {
            this.testCloseableImpl.resetCount();
        } else {
            throw new UnsupportedOperationException();
        }
    }

    @Override
    public <T extends RemoteCloseableThing> int remoteCloseableThingNumberOfCloseCalls(Class<T> klass) throws IOException {
        if (klass.equals(RemoteCloseableThing.NotCloseable.class)) {
            return this.testNotCloseableImpl.numberOfCloseCalls();
        }
        if (klass.equals(RemoteCloseableThing.IsCloseable.class)) {
            return this.testCloseableImpl.numberOfCloseCalls();
        }
        throw new UnsupportedOperationException();
    }
}

