/*
 * Decompiled with CFR 0.152.
 */
package org.newsclub.net.unix;

import java.io.IOException;
import java.net.SocketException;
import java.nio.file.Files;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.newsclub.net.unix.AFUNIXSocket;
import org.newsclub.net.unix.SocketTestBase;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class TcpNoDelayTest
extends SocketTestBase {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testStrictImpl() throws Exception {
        try (SocketTestBase.ServerThread serverThread = new SocketTestBase.ServerThread(){

            @Override
            protected void handleConnection(AFUNIXSocket sock) throws IOException {
            }

            @Override
            protected SocketTestBase.ExceptionHandlingDecision handleException(Exception e) {
                if (e instanceof SocketException) {
                    return SocketTestBase.ExceptionHandlingDecision.IGNORE;
                }
                return super.handleException(e);
            }

            @Override
            protected void onServerSocketClose() {
            }
        };
             AFUNIXSocket sock = this.connectToServer(AFUNIXSocket.newStrictInstance());){
            boolean gotException = false;
            try {
                sock.setTcpNoDelay(true);
            }
            catch (SocketException e) {
                gotException = true;
            }
            if (!gotException) {
                Assertions.assertTrue((boolean)sock.getTcpNoDelay());
            }
        }
        finally {
            Files.deleteIfExists(this.getSocketFile().toPath());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDefaultImpl() throws Exception {
        try (SocketTestBase.ServerThread serverThread = new SocketTestBase.ServerThread(){

            @Override
            protected void handleConnection(AFUNIXSocket sock) throws IOException {
            }

            @Override
            protected SocketTestBase.ExceptionHandlingDecision handleException(Exception e) {
                if (e instanceof SocketException) {
                    return SocketTestBase.ExceptionHandlingDecision.IGNORE;
                }
                return super.handleException(e);
            }

            @Override
            protected void onServerSocketClose() {
            }
        };
             AFUNIXSocket sock = this.connectToServer();){
            sock.setTcpNoDelay(true);
        }
        finally {
            Files.deleteIfExists(this.getSocketFile().toPath());
        }
    }
}

