/*
 * Decompiled with CFR 0.152.
 */
package org.newsclub.net.unix.selftest;

import com.kohlschutter.annotations.compiletime.SuppressFBWarnings;
import com.kohlschutter.util.ConsolePrintStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import org.junit.jupiter.engine.JupiterTestEngine;
import org.junit.jupiter.engine.discovery.DiscoverySelectorResolver;
import org.junit.platform.engine.support.descriptor.EngineDescriptor;
import org.junit.platform.engine.support.hierarchical.HierarchicalTestEngine;
import org.junit.platform.launcher.listeners.TestExecutionSummary;
import org.newsclub.lib.junixsocket.custom.NarMetadata;
import org.newsclub.net.unix.AFUNIXSocket;
import org.newsclub.net.unix.AFUNIXSocketCapability;
import org.newsclub.net.unix.selftest.SelftestExecutor;
import org.newsclub.net.unix.selftest.SelftestProvider;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class Selftest {
    private static final Class<? extends Annotation> CAP_ANNOTATION_CLASS = Selftest.getAFUNIXSocketCapabilityRequirementClass();
    private final ConsolePrintStream out = ConsolePrintStream.wrapSystemOut();
    private final Map<String, Object> results = new LinkedHashMap<String, Object>();
    private final List<AFUNIXSocketCapability> supportedCapabilites = new ArrayList<AFUNIXSocketCapability>();
    private final List<AFUNIXSocketCapability> unsupportedCapabilites = new ArrayList<AFUNIXSocketCapability>();
    private boolean withIssues = false;
    private boolean fail = false;

    public static void main(String[] args) throws Exception {
        Selftest st = new Selftest();
        st.printExplanation();
        st.dumpSystemProperties();
        st.dumpOSReleaseFiles();
        st.checkSupported();
        st.checkCapabilities();
        for (Map.Entry<String, Class<?>[]> en : new SelftestProvider().tests().entrySet()) {
            st.runTests(en.getKey(), en.getValue());
        }
        st.dumpResults();
        System.exit(st.isFail() ? 1 : 0);
    }

    public void printExplanation() throws IOException {
        this.out.println("This program determines whether junixsocket is supported on the current platform.");
        this.out.println("The final line should say whether the selftest passed or failed.");
        this.out.println();
        this.out.println("If the selftest failed, please visit https://github.com/kohlschutter/junixsocket/issues");
        this.out.println("and file a new bug report with the output below.");
        this.out.println();
        this.out.println("junixsocket selftest version " + AFUNIXSocket.getVersion());
        this.out.println();
    }

    public void dumpSystemProperties() {
        this.out.println("System properties:");
        this.out.println();
        for (Map.Entry<Object, Object> en : new TreeMap<Object, Object>(System.getProperties()).entrySet()) {
            String key = String.valueOf(en.getKey());
            String value = String.valueOf(en.getValue());
            StringBuilder sb = new StringBuilder();
            block6: for (int i = 0; i < value.length(); ++i) {
                char c = value.charAt(i);
                switch (c) {
                    case '\n': {
                        sb.append("\\n");
                        continue block6;
                    }
                    case '\r': {
                        sb.append("\\r");
                        continue block6;
                    }
                    case '\t': {
                        sb.append("\\r");
                        continue block6;
                    }
                    default: {
                        if (c < ' ' || c >= '\u007f') {
                            sb.append(String.format(Locale.ENGLISH, "\\u%04x", (int)c));
                        }
                        sb.append(c);
                    }
                }
            }
            this.out.println(key + ": " + sb.toString());
        }
        this.out.println();
    }

    public void checkSupported() {
        this.out.print("AFUNIXSocket.isSupported: ");
        this.out.flush();
        boolean isSupported = AFUNIXSocket.isSupported();
        this.out.println(isSupported);
        this.out.println();
        this.out.flush();
        if (!isSupported) {
            this.out.println("FAIL: junixsocket is not supported on this platform");
            this.out.println();
            this.fail = true;
        }
    }

    public void checkCapabilities() {
        for (AFUNIXSocketCapability cap : AFUNIXSocketCapability.values()) {
            boolean supported = AFUNIXSocket.supports((AFUNIXSocketCapability)cap);
            (supported ? this.supportedCapabilites : this.unsupportedCapabilites).add(cap);
        }
    }

    public boolean isFail() {
        return this.fail;
    }

    public void dumpResults() {
        this.out.println();
        this.out.println("Selftest results:");
        for (Map.Entry<String, Object> en : this.results.entrySet()) {
            Object extra;
            Object res = en.getValue();
            String result = "DONE";
            if (res == null) {
                result = "SKIP";
                extra = "(skipped by user request)";
            } else if (res instanceof Throwable) {
                result = "FAIL";
                extra = res.toString();
                this.fail = true;
            } else {
                TestExecutionSummary summary = (TestExecutionSummary)en.getValue();
                extra = summary.getTestsSucceededCount() + "/" + summary.getTestsFoundCount();
                long nSkipped = summary.getTestsSkippedCount();
                if (nSkipped > 0L) {
                    extra = (String)extra + " (" + nSkipped + " skipped)";
                }
                if (summary.getTestsFailedCount() > 0L) {
                    result = "FAIL";
                    this.fail = true;
                } else if (summary.getTestsFoundCount() == 0L) {
                    result = "NONE";
                    this.fail = true;
                } else if (summary.getTestsSucceededCount() + summary.getTestsSkippedCount() == summary.getTestsFoundCount()) {
                    result = "PASS";
                } else if (summary.getTestsAbortedCount() > 0L) {
                    this.withIssues = true;
                }
            }
            this.out.println(result + "\t" + en.getKey() + "\t" + (String)extra);
        }
        this.out.println();
        this.out.println("Supported capabilities:   " + this.supportedCapabilites);
        this.out.println("Unsupported capabilities: " + this.unsupportedCapabilites);
        this.out.println();
        if (this.fail) {
            this.out.println("Selftest FAILED");
        } else if (this.withIssues) {
            this.out.println("Selftest PASSED WITH ISSUES");
        } else {
            this.out.println("Selftest PASSED");
        }
    }

    private static Class<? extends Annotation> getAFUNIXSocketCapabilityRequirementClass() {
        try {
            return Class.forName("org.newsclub.net.unix.AFUNIXSocketCapabilityRequirement");
        }
        catch (ClassNotFoundException e1) {
            return null;
        }
    }

    private boolean checkIfCapabilitiesSupported(String className) {
        block7: {
            if (CAP_ANNOTATION_CLASS != null) {
                try {
                    Class<?> klass = Class.forName(className);
                    Annotation annotation = klass.getAnnotation(CAP_ANNOTATION_CLASS);
                    if (annotation == null) break block7;
                    try {
                        AFUNIXSocketCapability[] caps = (AFUNIXSocketCapability[])annotation.getClass().getMethod("value", new Class[0]).invoke((Object)annotation, new Object[0]);
                        if (caps != null) {
                            for (AFUNIXSocketCapability cap : caps) {
                                if (AFUNIXSocket.supports((AFUNIXSocketCapability)cap)) continue;
                                this.out.println("Skipping class " + className + "; unsupported capability: " + cap);
                                return false;
                            }
                        }
                    }
                    catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException exception) {
                    }
                }
                catch (ClassNotFoundException e) {
                    this.out.println("Class not found: " + className);
                    this.withIssues = true;
                }
            }
        }
        return true;
    }

    public void runTests(String module, Class<?>[] testClasses) {
        Exception summary;
        String prefix = "Testing \"" + module + "\"... ";
        this.out.markPosition();
        this.out.update(prefix);
        this.out.flush();
        String only = System.getProperty("selftest.only", "");
        if (Boolean.valueOf(System.getProperty("selftest.skip." + module, "false")).booleanValue()) {
            this.out.println("Skipping module " + module + "; skipped by request");
            this.withIssues = true;
            summary = null;
        } else {
            ArrayList list = new ArrayList(testClasses.length);
            for (Class<?> testClass : testClasses) {
                boolean skipFullyQualified;
                if (testClass == null) continue;
                String className = testClass.getName();
                String simpleName = testClass.getSimpleName();
                if (!only.isEmpty() && !only.equals(className) && !only.equals(simpleName)) continue;
                String skipFullyQualifiedProp = System.getProperty("selftest.skip." + className, "");
                boolean bl = skipFullyQualified = !skipFullyQualifiedProp.isEmpty() && Boolean.valueOf(skipFullyQualifiedProp) != false;
                if (skipFullyQualified || Boolean.valueOf(System.getProperty("selftest.skip." + simpleName, "false")).booleanValue()) {
                    this.out.println("Skipping test class " + className + "; skipped by request");
                    this.withIssues = true;
                    continue;
                }
                if (!this.checkIfCapabilitiesSupported(className)) continue;
                list.add(testClass);
            }
            try {
                summary = new SelftestExecutor(list, prefix).execute(this.out);
            }
            catch (Exception e) {
                e.printStackTrace((PrintStream)this.out);
                summary = e;
            }
        }
        this.results.put(module, summary);
    }

    private void dumpContentsOfSystemConfigFile(File file) {
        if (!file.exists()) {
            return;
        }
        String p = file.getAbsolutePath();
        System.out.println("BEGIN contents of file: " + p);
        int maxToRead = 4096;
        char[] buf = new char[4096];
        try (InputStreamReader isr = new InputStreamReader((InputStream)new FileInputStream(file), StandardCharsets.UTF_8);){
            OutputStreamWriter outWriter = new OutputStreamWriter((OutputStream)System.out, Charset.defaultCharset());
            int read = -1;
            boolean lastWasNewline = false;
            for (int numRead = 0; numRead < 4096 && (read = isr.read(buf)) != -1; numRead += read) {
                outWriter.write(buf, 0, read);
                outWriter.flush();
                lastWasNewline = read > 0 && buf[read - 1] == '\n';
            }
            if (!lastWasNewline) {
                System.out.println();
            }
            if (read != -1) {
                System.out.println("[...]");
            }
        }
        catch (Exception e) {
            System.out.println("ERROR while reading contents of file: " + p + ": " + e);
        }
        System.out.println("=END= contents of file: " + p);
        System.out.println();
    }

    public void dumpOSReleaseFiles() throws IOException {
        HashSet<Path> canonicalPaths = new HashSet<Path>();
        for (String f : new String[]{"/etc/os-release", "/etc/lsb-release", "/etc/lsb_release", "/etc/system-release", "/etc/system-release-cpe", "/etc/debian_version", "/etc/fedora-release", "/etc/redhat-release", "/etc/centos-release", "/etc/centos-release-upstream", "/etc/SuSE-release", "/etc/arch-release", "/etc/gentoo-release", "/etc/ubuntu-release"}) {
            File file = new File(f);
            if (!file.exists() || file.isDirectory()) continue;
            Path p = file.toPath().toAbsolutePath();
            for (int i = 0; i < 2; ++i) {
                Path p2;
                if (!Files.isSymbolicLink(p) || (p2 = Files.readSymbolicLink(p)).isAbsolute()) continue;
                p = new File(p.toFile().getParentFile(), p2.toString()).toPath().toAbsolutePath();
            }
            if (!canonicalPaths.add(p)) continue;
            this.dumpContentsOfSystemConfigFile(file);
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    @SuppressFBWarnings(value={"UUF_UNUSED_FIELD"})
    static final class MinimizeJarDependencies {
        JupiterTestEngine jte;
        HierarchicalTestEngine<?> hte;
        EngineDescriptor ed;
        DiscoverySelectorResolver dsr;
        org.newsclub.lib.junixsocket.common.NarMetadata nmCommon;
        NarMetadata nmCustom;

        MinimizeJarDependencies() {
        }
    }
}

