/*
 * Decompiled with CFR 0.152.
 */
package org.newsclub.net.unix;

import java.io.IOException;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.time.Duration;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.newsclub.net.unix.AFUNIXServerSocket;
import org.newsclub.net.unix.AFUNIXSocket;
import org.newsclub.net.unix.SocketTestBase;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class AcceptTimeoutTest
extends SocketTestBase {
    private static final int TIMING_INACCURACY_MILLIS = 5000;

    @Test
    public void testCatchTimeout() throws Exception {
        int timeoutMillis = 500;
        Assertions.assertTimeoutPreemptively((Duration)Duration.ofMillis(2500L), () -> {
            try (AFUNIXServerSocket sock = this.startServer();){
                long time = System.currentTimeMillis();
                sock.setSoTimeout(500);
                long actualTimeout = sock.getSoTimeout();
                Assertions.assertTrue((Math.abs(500L - actualTimeout) <= 5000L ? 1 : 0) != 0, (String)("We should roughly get the same timeout back that we set before, but was " + actualTimeout + " instead of 500"));
                try (AFUNIXSocket socket = sock.accept();){
                    Assertions.fail((String)("Did not receive " + SocketTimeoutException.class.getName() + "; socket=" + socket));
                }
                catch (SocketException | SocketTimeoutException e) {
                    time = System.currentTimeMillis() - time;
                    Assertions.assertTrue((Math.abs(time - 500L) <= 5000L ? 1 : 0) != 0, (String)("Timeout not properly honored. Exception thrown after " + time + "ms vs. expected 500ms"));
                }
            }
        });
    }

    @Test
    public void testTimeoutAfterDelay() throws Exception {
        int timeoutMillis = 5000;
        Assertions.assertTimeoutPreemptively((Duration)Duration.ofMillis(10000L), () -> {
            try (AFUNIXServerSocket sock = this.startServer();){
                final int connectDelayMillis = 50;
                sock.setSoTimeout(5000);
                long actualTimeout = sock.getSoTimeout();
                Assertions.assertTrue((Math.abs(5000L - actualTimeout) <= 10L ? 1 : 0) != 0, (String)("We should roughly get the same timeout back that we set before, but was " + actualTimeout + " instead of 5000"));
                new Thread(){
                    private final AFUNIXSocket socket = AFUNIXSocket.newInstance();
                    {
                        this.setDaemon(true);
                    }

                    @Override
                    public void run() {
                        try {
                            Thread.sleep(connectDelayMillis);
                        }
                        catch (InterruptedException e) {
                            return;
                        }
                        try {
                            this.socket.connect((SocketAddress)AcceptTimeoutTest.this.getServerAddress());
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                }.start();
                long time = System.currentTimeMillis();
                try (AFUNIXSocket socket = sock.accept();){
                    Assertions.assertNotNull((Object)socket);
                }
                time = System.currentTimeMillis() - time;
                Assertions.assertTrue((time >= 50L && (time < 5000L || time - 50L <= 5000L) ? 1 : 0) != 0, (String)("Timeout not properly honored. Accept succeeded after " + time + "ms vs. expected 5000ms"));
            }
        });
    }
}

